<?php 
if(service('request')->uri->getSegment(2) == "novo-cadastro") { 
	echo form_open_multipart($MyMod . "/cadastrando", array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
else { 
	echo form_open_multipart($MyMod . "/atualizando-cadastro/" . $id, array ('class' => 'form validate', 'id' => 'form_principal')); 
} 
?>

<div class="wrapper wrapper-content animated fadeInRight">
	<?php echo view('Views\view_header'); ?>

	<?php if(isset($cms_plataformas->data_cadastro) AND !empty($cms_plataformas->data_cadastro)) { ?>
		<div class="row">
			<div class="col-12">
				<div class="ibox float-e-margins">
					<div class="ibox-title">
						<i class="fa-light fa-calendar mr-1"></i> Este conteúdo foi criado em <b><?php echo date("d-m-Y H:i:s", strtotime($cms_plataformas->data_cadastro)); ?> </b>
						
						<?php if(isset($cms_plataformas->data_alteracao) AND !empty($cms_plataformas->data_alteracao)) { ?>
							e alterado em <b><?php echo date("d-m-Y H:i:s", strtotime($cms_plataformas->data_alteracao)); ?></b>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title border-danger">
					<h5>
						Formulário de cadastro 
					</h5>
				</div>

				<div class="ibox-content border-danger">
					<div class="row">
						<div class="col-12">
							<label for="ativo" class="form-label">
								Status:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="ativo">
									<i class="fa-light fa-power-off"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="ativo" name="ativo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cms_plataformas->ativo) and $cms_plataformas->ativo == 1) { echo 'selected'; } ?> value="1">Cadastro ativo</option>
									<option <?php if(isset($cms_plataformas->ativo) and $cms_plataformas->ativo == 0) { echo 'selected'; } ?> value="0">Cadastro inativo</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="titulo" class="form-label">
								Título:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="titulo">
									<i class="fa-light fa-align-left"></i>
								</span>

								<input type="text" class="form-control" aria-label="titulo" aria-describedby="titulo" data-rule-required="true" data-msg-required="Campo obrigatório." id="titulo" name="titulo" value="<?php if(isset($cms_plataformas->titulo)) { echo $cms_plataformas->titulo; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="fundacao" class="form-label">
								Ano da fundação:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="fundacao">
									<i class="fa-light fa-calendar"></i>
								</span>

								<input type="text" class="form-control" aria-label="fundacao" aria-describedby="fundacao" data-rule-required="true" data-msg-required="Campo obrigatório." id="fundacao" name="fundacao" value="<?php if(isset($cms_plataformas->fundacao)) { echo $cms_plataformas->fundacao; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="link" class="form-label">
								Link:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="link">
									<i class="fa-light fa-link"></i>
								</span>

								<input type="text" class="form-control" aria-label="link" aria-describedby="link" id="link" name="link" value="<?php if(isset($cms_plataformas->link)) { echo $cms_plataformas->link; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title border-danger">
					<h5>
						Formulário de cadastro 
					</h5>
				</div>

				<div class="ibox-content border-danger">
					<div class="row">
						<div class="col-12">
							<label for="whatsapp_ativo" class="form-label">
								Status:
							</label>

							<div class="input-group mb-3">
								<label class="input-group-text" for="whatsapp_ativo">
									<i class="fa-light fa-power-off"></i>
								</label>

								<select class="form-select" data-rule-required="true" data-msg-required="Campo obrigatório." id="whatsapp_ativo" name="whatsapp_ativo">
									<option value="" disabled selected hidden></option>
									<option <?php if(isset($cms_plataformas->whatsapp_ativo) and $cms_plataformas->whatsapp_ativo == 1) { echo 'selected'; } ?> value="1">Mostrar WhatsApps no menu</option>
									<option <?php if(isset($cms_plataformas->whatsapp_ativo) and $cms_plataformas->whatsapp_ativo == 0) { echo 'selected'; } ?> value="0">Não mostrar WhatsApps no menu</option>
								</select>
							</div>
						</div>

						<div class="col-12">
							<label for="whatsapp_suporte" class="form-label">
								WhatsApp ( suporte ):
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="whatsapp_suporte">
									<i class="fa-brands fa-whatsapp"></i>
								</span>

								<input type="text" class="form-control mask-phone" aria-label="whatsapp_suporte" aria-describedby="whatsapp_suporte" id="whatsapp_suporte" name="whatsapp_suporte" value="<?php if(isset($cms_plataformas->whatsapp_suporte)) { echo $cms_plataformas->whatsapp_suporte; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="whatsapp_comercial" class="form-label">
								WhatsApp ( comercial ):
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="whatsapp_comercial">
									<i class="fa-brands fa-whatsapp"></i>
								</span>

								<input type="text" class="form-control mask-phone" aria-label="whatsapp_comercial" aria-describedby="whatsapp_comercial" id="whatsapp_comercial" name="whatsapp_comercial" value="<?php if(isset($cms_plataformas->whatsapp_comercial)) { echo $cms_plataformas->whatsapp_comercial; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="whatsapp_financeiro" class="form-label">
								WhatsApp ( financeiro ):
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="whatsapp_financeiro">
									<i class="fa-brands fa-whatsapp"></i>
								</span>

								<input type="text" class="form-control mask-phone" aria-label="whatsapp_financeiro" aria-describedby="whatsapp_financeiro" id="whatsapp_financeiro" name="whatsapp_financeiro" value="<?php if(isset($cms_plataformas->whatsapp_financeiro)) { echo $cms_plataformas->whatsapp_financeiro; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title border-danger">
					<h5>
						Google reCAPTCHA
					</h5>
				</div>

				<div class="ibox-content border-danger">
					<div class="row">
						<div class="col-12">
							<label for="recaptcha_site" class="form-label">
								Chave do site:
							</label>

							<div class="input-group mb-3">
								<span class="input-group-text" id="recaptcha_site">
									<i class="fa-light fa-key"></i>
								</span>

								<input type="text" class="form-control" aria-label="recaptcha_site" aria-describedby="recaptcha_site" data-rule-required="true" data-msg-required="Campo obrigatório." id="recaptcha_site" name="recaptcha_site" value="<?php if(isset($cms_plataformas->recaptcha_site)) { echo $cms_plataformas->recaptcha_site; } ?>">
							</div>
						</div>

						<div class="col-12">
							<label for="recaptcha_secreta" class="form-label">
								Chave secreta:
							</label>

							<div class="input-group mb-0">
								<span class="input-group-text" id="recaptcha_secreta">
									<i class="fa-light fa-key"></i>
								</span>

								<input type="text" class="form-control" aria-label="recaptcha_secreta" aria-describedby="recaptcha_secreta" data-rule-required="true" data-msg-required="Campo obrigatório." id="recaptcha_secreta" name="recaptcha_secreta" value="<?php if(isset($cms_plataformas->recaptcha_secreta)) { echo $cms_plataformas->recaptcha_secreta; } ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title border-danger">
					<h5>
						Imagens
					</h5>
				</div>

				<div class="ibox-content border-danger">
					<div class="row">
						<div class="col-6 border-end">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Logo da empresa:
							</label>

							<br>

							<?php if(isset($id) AND !empty($id)) { ?>
								<label class="mb-3">
									<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Largura <b>qualquer</b> e altura <b>qualquer</b></span>
								</label>
							<?php } else { ?> 
								<label class="mb-3">
									<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Selecione a categoria. </span>
								</label>
							<?php } ?>

							<?php if(isset($cms_plataformas->imagem) and $cms_plataformas->imagem) { ?>
								<a href="<?php echo PUBLICURL . 'uploads/upload_cms_plataformas/' . $cms_plataformas->imagem; ?>" data-gallery="gallery-logos" data-title="<?php if(isset($cms_plataformas->titulo) and $cms_plataformas->titulo) { echo $cms_plataformas->titulo; } ?>">
									<center class="center-img">
										<img class="img-responsive" src="<?php echo PUBLICURL . 'uploads/upload_cms_plataformas/item_' . $cms_plataformas->id . '/' . $cms_plataformas->imagem; ?>"/>
									</center>
								</a>										
							<?php } else { ?>
								<center class="center-preview-img">
								</center>
							<?php } ?>
						</div>

						<div class="col-6">
							<label class="mb-2">
								<i class="fa-light fa-image"></i> Preview:
							</label>

							<br/>

							<?php if(isset($id) AND !empty($id)) { ?>
								<label class="mb-3">
									<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Largura <b>qualquer</b> e altura <b>qualquer</b></span>
								</label>
							<?php } else { ?> 
								<label class="mb-3">
									<i class="fa-light fa-arrows-maximize"></i> Dimensão recomenda: <span class="dimension-desktop"> Selecione a categoria. </span>
								</label>
							<?php } ?>

							<center class="center-preview-img mb-3">
								<div class="image-preview" id="image-preview"></div>
							</center>

							<label title="Selecione a imagem." for="imagem" class="btn btn-primary w-100">
								<input type="file" accept="image/*" name="imagem" id="imagem" data-holder="image-preview" class="btn-imagem-preview" <?php if(empty($cms_plataformas->imagem)) { echo ''; } ?>>
								<i class="fa-light fa-computer"></i> Selecionar imagem
							</label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php echo view('Views\view_logs'); ?>
</div>

<?php echo view('Views\view_footer'); ?>
<?php echo form_close(); ?>