<?php
$routes->group(
	'cadastro-de-usuarios', 
	[
		'namespace' => 'Modules\Cms_usuario\Controllers', 
		'filter' 		=> 'CheckAccessPermission'
	], 
	function ($routes) {
		$routes->get('/', 'Cms_usuario::listagem');

		$routes->match(['get', 'post'], 'novo-cadastro', 'Cms_usuario::cadastrar');
		$routes->post('cadastrando', 'Cms_usuario::cadastrando');
		
		$routes->match(['get', 'post'], 'alterando-cadastro/(:any)', 'Cms_usuario::alterar/$1');
		$routes->post('atualizando-cadastro/(:any)', 'Cms_usuario::alterando/$1');
		
		$routes->get('deletando-cadastro/(:any)', 'Cms_usuario::deletar/$1');

		$routes->post('gerar-2fa', 'Cms_usuario::gerar2FA');
		$routes->post('valida-2fa', 'Cms_usuario::validar2FA');

		$routes->match(['get', 'post'], 'api-cadastrar/(:any)/(:any)/(:any)', 'Cms_usuario::api/$1/$2/$3');
		$routes->post('api-cadastrando/(:any)/(:any)/(:any)', 'Cms_usuario::api/$1/$2/$3');
	}
);