<?php
namespace Modules\Cms_usuario\Controllers;

use App\Controllers\BaseController;
use Modules\Cms_usuario\Models\model_cms_usuario;
use Store\DataHelper;
use Api\ApiHelper;

use CodeIgniter\Encryption\Encryption;

class Cms_usuario extends BaseController {
	public function __construct() {
		$this->dataHelper				 	= new DataHelper;
		$this->model_cms_usuario 	= new Model_cms_usuario;
	}

	/**
	* index
	* 
	* @version 1.0.0.0 - 2023-06-16
	* 
	* @param não definido ainda
	* 
	* @return não definido ainda
	*/ 

	public function index() {
	}

	/**
	* index
	* 
	* @version 1.0.0.0 - 2023-06-16
	* 
	* @param não definido ainda
	* 
	* @return não definido ainda
	*/ 

	public function listagem() {
		$imgIcon = "";
		$u 			 = service('session')->get('usuario');

		if($u->id_categoria <= 2) {
			$dados['cms_usuarios'] = $this->model_cms_usuario->getCadastros();

			foreach ($dados['cms_usuarios'] as $key => $usuario) {
				$usuario->senha = service('encrypter')->decrypt(hex2bin($usuario->senha), ['key' => getenv('ENCRYPTKEY')]);

				if(isset($imgIcon) AND !empty($imgIcon)) {
					$usuario->api_1_icon = PUBLICURL . 'uploads/upload_conf_apis/api_1/'. $imgIcon;					
				}
			}

			$this->dataHelper->DH_actionRecord();
			$this->_cms('Modules\Cms_usuario\Views\view_cms_usuario_listar', $dados);
		}
		else {
			return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $u->id));
		}
	}

	/**
	* cadastrar
	* 
	* @version 1.0.0.0 - 2023-06-16
	* 
	* @param não definido ainda
	* 
	* @return não definido ainda
	*/ 

	public function cadastrar() {
		$u = service('session')->get('usuario');

		if($u->id_categoria <= 2) {
			$dados['cms_usuarios_categorias']   = $this->model_cms_usuario->getUsuariosCategorias();
			$dados['cms_modulos_categorias']    = $this->model_cms_usuario->getModulosCategorias();
			$dados['cms_modulos']               = $this->model_cms_usuario->getModulos();

			$this->dataHelper->DH_actionRecord();
			$this->_cms('Modules\Cms_usuario\Views\view_cms_usuario_cadastrar', $dados);
		}
		else {
			service('session')->set('msg', array('titulo' => 'Acesso negado!', 'descricao' => 'No momento você não possui permissão para acessar este módulo', 'tipo' => 'error'));
			return redirect()->to(site_url(service('request')->uri->getSegment(1)));
		}
	}

	/**
	* cadastrando
	* 
	* @version 1.0.0.0 - 2023-06-16
	* 
	* @param não definido ainda
	* 
	* @return não definido ainda
	*/ 

	public function cadastrando() {
		$senha = service('request')->getPost('senha');

		if($senha == "") {
			unset($_POST['senha']);
		}
		else {
			$_POST['senha'] = bin2hex(service('encrypter')->encrypt($senha, ['key' => getenv('ENCRYPTKEY')]));
		}

		$idModuloCategoria 	= $this->request->getPost('id_modulo_categoria');
		$idModulo 					= $this->request->getPost('id_modulo');

		$moduloCadastrar		= $this->request->getPost('modulo_cadastrar');
		$moduloEditar				= $this->request->getPost('modulo_editar');
		$moduloSalvar				= $this->request->getPost('modulo_salvar');
		$moduloExcluir			= $this->request->getPost('modulo_excluir');
		$moduloLote					= $this->request->getPost('modulo_lote');
		$moduloDashboard		= $this->request->getPost('modulo_dashboard');

		/*
		* Monta o menu do CMS
		*/

		if(isset($idModuloCategoria) AND !empty($idModuloCategoria)) {
			foreach ($idModuloCategoria as $keyCategoria => $categoria) {
				$dadosModulosCategoria[$keyCategoria] = $this->model_cms_usuario->getDadosModulosCategoria($categoria);
				$dadosModulos 												= $this->model_cms_usuario->getDadosModulos($dadosModulosCategoria[$keyCategoria]->id, $idModulo);

				foreach ($dadosModulos as $keyModulo => $modulo) {
					if(isset($moduloCadastrar) AND !empty($moduloCadastrar) AND in_array($modulo->id . "-1", $moduloCadastrar)) {
						$modulo->cadastrar = 1;
					}
					else {
						$modulo->cadastrar = 0;
					}

					if(isset($moduloEditar) AND !empty($moduloEditar) AND in_array($modulo->id . "-1", $moduloEditar)) {
						$modulo->editar = 1;
					}
					else {
						$modulo->editar = 0;
					}

					if(isset($moduloSalvar) AND !empty($moduloSalvar) AND in_array($modulo->id . "-1", $moduloSalvar)) {
						$modulo->salvar = 1;
					}
					else {
						$modulo->salvar = 0;
					}

					if(isset($moduloExcluir) AND !empty($moduloExcluir) AND in_array($modulo->id . "-1", $moduloExcluir)) {
						$modulo->excluir = 1;
					}
					else {
						$modulo->excluir = 0;
					}

					if(isset($moduloLote) AND !empty($moduloLote) AND in_array($modulo->id . "-1", $moduloLote)) {
						$modulo->lote = 1;
					}
					else {
						$modulo->lote = 0;
					}

					if(isset($moduloDashboard) AND !empty($moduloDashboard) AND in_array($modulo->id . "-1", $moduloDashboard)) {
						$modulo->dashboard = 1;
					}
					else {
						$modulo->dashboard = 0;
					}

					$dadosModulosCategoria[$keyCategoria]->submenu = $dadosModulos;
				}
			}

			$_POST['menu'] = base64_encode(serialize($dadosModulosCategoria));
		}

		if((isset($idModuloCategoria) AND !empty($idModuloCategoria)) AND (isset($idModulo) AND !empty($idModulo))) {
			$ar = array(
				'idModuloCategoria' 	=> $idModuloCategoria, 
				'idModulo' 						=> $idModulo,
				'moduloCadastrar' 		=> $moduloCadastrar,
				'moduloEditar' 				=> $moduloEditar,
				'moduloSalvar' 				=> $moduloSalvar,
				'moduloExcluir' 			=> $moduloExcluir,
				'moduloLote' 					=> $moduloLote,
				'moduloDashboard'			=> $moduloDashboard
			);
			
			$_POST['permissoes'] = base64_encode(serialize($ar));
		}

		/*
		* Remove index do $_POST
		*/

		unset($_POST['id_modulo_categoria']);
		unset($_POST['id_modulo']);
		
		unset($_POST['modulo_cadastrar']);
		unset($_POST['modulo_editar']);
		unset($_POST['modulo_salvar']);
		unset($_POST['modulo_excluir']);
		unset($_POST['modulo_lote']);
		unset($_POST['modulo_dashboard']);

		unset($_POST['repetir_senha']);

		$_POST['token_access'] = uniqid();

		/*
		* Notificações
		*/

		$_POST['notificacoes'] = base64_encode(serialize($this->request->getPost('notificacoes')));

		$id = $this->model_cms_usuario->cadastrando();
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Novo cadastro', 'cms_usuario', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	/**
	* alterar
	* 
	* @version 1.0.0.0 - 2023-06-16
	* 
	* @param não definido ainda
	* 
	* @return não definido ainda
	*/ 

	public function alterar($id) {
		if($id == 1 AND service('session')->get('usuario')->id != 1) {
			service('session')->set('msg', array('titulo' => 'Acesso negado!', 'descricao' => 'No momento você não possui permissão para acessar este módulo', 'tipo' => 'error'));
			return redirect()->to(site_url(service('request')->uri->getSegment(1)));
		}
		else {
			$dados['id']          = $id;
			$dados['cms_usuario'] = $this->model_cms_usuario->alterar($id);

			if(isset($dados['cms_usuario']) AND !empty($dados['cms_usuario'])) {
				$dados['cms_usuarios_categorias']   = $this->model_cms_usuario->getUsuariosCategorias();
				$dados['cms_modulos_categorias']    = $this->model_cms_usuario->getModulosCategorias();
				$dados['cms_modulos'] 							= $this->model_cms_usuario->getModulos();
				$dados['logs']											= $this->dataHelper->DH_getLogFile('cms_usuario', 'item_' . $id);

				$this->dataHelper->DH_actionRecord($id);
				$this->_cms('Modules\Cms_usuario\Views\view_cms_usuario_cadastrar', $dados);
			}
			else {
				service('session')->set('msg', array('titulo' => 'Acesso negado!', 'descricao' => 'No momento você não possui permissão para acessar este módulo', 'tipo' => 'error'));
				return redirect()->to(site_url(service('request')->uri->getSegment(1)));
			}
		}
	}

	/**
	* alterando
	* 
	* @version 1.0.0.0 - 2023-06-16
	* 
	* @param não definido ainda
	* 
	* @return não definido ainda
	*/ 

	public function alterando($id) {
		$senha = service('request')->getPost('senha');

		if($senha == "") {
			unset($_POST['senha']);
		}
		else {
			$_POST['senha'] = bin2hex(service('encrypter')->encrypt($senha, ['key' => getenv('ENCRYPTKEY')]));
		}

		$dados = $this->model_cms_usuario->alterar($id);

		if(empty($dados->token_access)) {
			$_POST['token_access'] = uniqid();
		}

		$idModuloCategoria 	= $this->request->getPost('id_modulo_categoria');
		$idModulo 					= $this->request->getPost('id_modulo');

		$moduloCadastrar		= $this->request->getPost('modulo_cadastrar');
		$moduloEditar				= $this->request->getPost('modulo_editar');
		$moduloSalvar				= $this->request->getPost('modulo_salvar');
		$moduloExcluir			= $this->request->getPost('modulo_excluir');
		$moduloLote					= $this->request->getPost('modulo_lote');
		$moduloDashboard		= $this->request->getPost('modulo_dashboard');

		/*
		* Monta o menu do CMS
		*/

		if(isset($idModuloCategoria) AND !empty($idModuloCategoria)) {
			foreach ($idModuloCategoria as $keyCategoria => $categoria) {
				$dadosModulosCategoria[$keyCategoria] = $this->model_cms_usuario->getDadosModulosCategoria($categoria);
				$dadosModulos 												= $this->model_cms_usuario->getDadosModulos($dadosModulosCategoria[$keyCategoria]->id, $idModulo);

				foreach ($dadosModulos as $keyModulo => $modulo) {
					if(isset($moduloCadastrar) AND !empty($moduloCadastrar) AND in_array($modulo->id . "-1", $moduloCadastrar)) {
						$modulo->cadastrar = 1;
					}
					else {
						$modulo->cadastrar = 0;
					}

					if(isset($moduloEditar) AND !empty($moduloEditar) AND in_array($modulo->id . "-1", $moduloEditar)) {
						$modulo->editar = 1;
					}
					else {
						$modulo->editar = 0;
					}

					if(isset($moduloSalvar) AND !empty($moduloSalvar) AND in_array($modulo->id . "-1", $moduloSalvar)) {
						$modulo->salvar = 1;
					}
					else {
						$modulo->salvar = 0;
					}

					if(isset($moduloExcluir) AND !empty($moduloExcluir) AND in_array($modulo->id . "-1", $moduloExcluir)) {
						$modulo->excluir = 1;
					}
					else {
						$modulo->excluir = 0;
					}

					if(isset($moduloLote) AND !empty($moduloLote) AND in_array($modulo->id . "-1", $moduloLote)) {
						$modulo->lote = 1;
					}
					else {
						$modulo->lote = 0;
					}

					if(isset($moduloDashboard) AND !empty($moduloDashboard) AND in_array($modulo->id . "-1", $moduloDashboard)) {
						$modulo->dashboard = 1;
					}
					else {
						$modulo->dashboard = 0;
					}

					$dadosModulosCategoria[$keyCategoria]->submenu = $dadosModulos;
				}
			}

			$_POST['menu'] = base64_encode(serialize($dadosModulosCategoria));
		}

		if((isset($idModuloCategoria) AND !empty($idModuloCategoria)) AND (isset($idModulo) AND !empty($idModulo))) {
			$ar = array(
				'idModuloCategoria' 	=> $idModuloCategoria, 
				'idModulo' 						=> $idModulo,
				'moduloCadastrar' 		=> $moduloCadastrar,
				'moduloEditar' 				=> $moduloEditar,
				'moduloSalvar' 				=> $moduloSalvar,
				'moduloExcluir' 			=> $moduloExcluir,
				'moduloLote' 					=> $moduloLote,
				'moduloDashboard'			=> $moduloDashboard
			);
			
			$_POST['permissoes'] = base64_encode(serialize($ar));
		}

		/*
		* Notificações
		*/

		$_POST['notificacoes'] = base64_encode(serialize($this->request->getPost('notificacoes')));

		/*
		* Remove index do $_POST
		*/

		unset($_POST['id_modulo_categoria']);
		unset($_POST['id_modulo']);
		
		unset($_POST['modulo_cadastrar']);
		unset($_POST['modulo_editar']);
		unset($_POST['modulo_salvar']);
		unset($_POST['modulo_excluir']);
		unset($_POST['modulo_lote']);
		unset($_POST['modulo_dashboard']);

		unset($_POST['repetir_senha']);

		$this->model_cms_usuario->alterando($id);
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cms_usuario', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		if(service('session')->get('usuario')->id == $id) {
			service('session')->set('usuario', $this->model_cms_usuario->alterar($id));
		}

		service('session')->set('msg', array('titulo' => 'Alteração realizada', 'descricao' => 'Suas alterações foram salvas com sucesso', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	/**
	* deletar
	* 
	* @version 1.0.0.0 - 2023-06-16
	* 
	* @param não definido ainda
	* 
	* @return não definido ainda
	*/ 

	public function deletar($id) {
		if($id == 1 || $id == 2) {
			service('session')->set('msg', array('titulo' => 'Remoção não realizada', 'descricao' => 'Este cadastro não pode ser removido', 'tipo' => 'error'));
			return redirect()->to(site_url(service('request')->uri->getSegment(1)));
		}
		else {
			$dados = $this->model_cms_usuario->alterar($id);
			
			$this->model_cms_usuario->deletar($id);
			$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'cms_usuario', 'item_' . $id);
			$this->dataHelper->DH_actionRecord($id);

			service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
			return redirect()->to(site_url(service('request')->uri->getSegment(1)));
		}
	}

	/**
	* gerar2FA
	* 
	* @version 1.0.0.0 - 2023-06-16
	* 
	* @param não definido ainda
	* 
	* @return não definido ainda
	*/ 

	public function gerar2FA() {
		$id 		= base64_decode(service('request')->getPost('dados'));
		$qrcode = $this->dataHelper->DH_geraToken2FA($id);

		if(!empty($qrcode)) {
			echo json_encode(array('error' => '0', 'qrcode' => $qrcode));
		}
		else {
			echo json_encode(array('error' => '1', 'mensagem' => 'Houve um erro ao gerar o qr code.'));
		}
	}

	/**
	* validar2FA
	* 
	* @version 1.0.0.0 - 2023-06-16
	* 
	* @param não definido ainda
	* 
	* @return não definido ainda
	*/ 

	public function validar2FA() {
		$id 			= base64_decode(service('request')->getPost('dados'));
		$codigo 	= service('request')->getPost('codigo');
		$resposta = $this->dataHelper->DH_validaToken2FA($id, $codigo);

		if($resposta) {
			echo json_encode(array('error' => '0', 'mensagem' => 'Google Authenticator configurado com sucesso!'));
		}
		else {
			echo json_encode(array('error' => '1', 'mensagem' => 'Codigo incorreto!'));
		}
	}

	/**
	* API
	* 
	* @version 1.0.0.0 - 2023-06-16
	* 
	* @param não definido ainda
	* 
	* @return não definido ainda
	*/ 

	public function api($idAPI, $idCadastro, $tipo) {
		$tipos_a = array(
			'grupos',
			'vendedores',
			'configuracoes'
		);
		
		if(in_array($tipo, $tipos_a)) {
			$function = 'cadastrarAPI_' . $idAPI;

			if(method_exists($this, $function)) {
				$this->dataHelper->DH_actionRecord($idCadastro, 'api', array('apiID' => $idAPI, 'function' => $tipo, 'action' => 'read'));
				return $this->$function($idCadastro, $idAPI, $tipo);
			} 
			else {
				service('session')->set('msg', array('titulo' => 'Ops!', 'descricao' => 'Não foi possível dar continuidade a sua solicitação', 'tipo' => 'error'));
				return redirect()->to(site_url(service('request')->uri->getSegment(1)));
			}
		}

		$tipos_b = array(
			'cadastrando'
		);

		if(in_array($tipo, $tipos_b)) {
			$function = 'cadastrandoAPI_' . $idAPI;

			if(method_exists($this, $function)) {
				return $this->$function($idCadastro, $idAPI, $tipo);
			} 
			else {
				service('session')->set('msg', array('titulo' => 'Ops!', 'descricao' => 'Não foi possível dar continuidade a sua solicitação', 'tipo' => 'error'));
				return redirect()->to(site_url(service('request')->uri->getSegment(1)));
			}
		}
	}

	/**
	* cadastrarAPI_1
	* 
	* @version 1.0.0.0 - 2023-06-16
	* 
	* @param não definido ainda
	* 
	* @return não definido ainda
	*/ 

	public function cadastrarAPI_1($idCadastro, $idAPI, $metodo) {
		if($idCadastro == 1 AND service('session')->get('usuario')->id != 1) {
			service('session')->set('msg', array('titulo' => 'Acesso negado!', 'descricao' => 'No momento você não possui permissão para acessar este módulo', 'tipo' => 'error'));
			return redirect()->to(site_url(service('request')->uri->getSegment(1)));
		}
		else {
			if(empty($metodo)) { 
				return redirect()->to(site_url('cadastro-de-usuarios'));
			}
			else {
				$dados['id']          = $idCadastro;
				$dados['id_api'] 			= $idAPI;
				$dados['cms_usuario'] = $this->model_cms_usuario->alterar($idCadastro);

				if(isset($dados['cms_usuario']) AND !empty($dados['cms_usuario'])) {
					$dados['logs']	 			= $this->dataHelper->DH_getLogFile('cms_usuario', 'item_' . $idCadastro);
					$dados['metodo'] 			= $metodo;
					$post['view_reload'] 	= 'view_cms_usuario_api_' . $idAPI . '_' . $metodo;

					if($metodo == 'vendedores') {
						$post['modulo_api']	= 'usuario';
						$post['indice']			= 'usuarios';

						$post['api_1_vendedor']	= $dados['cms_usuario']->api_1_vendedor;
						$dados['unset']					= base64_encode(serialize(array('tipo', 'ativo', 'id', 'nome', 'cpf_cnpj', 'metodo', 'api_id', 'api_1_grupos', 'api_1_configuracoes')));
					}

					if($metodo == 'grupos') {
						$post['modulo_api'] = 'grupo';
						$post['indice']			= 'grupos';
						
						$post['api_1_grupos']	= $dados['cms_usuario']->api_1_grupos;
						$dados['unset']				= base64_encode(serialize(array('tipo', 'ativo', 'id', 'nome', 'cpf_cnpj', 'metodo', 'api_id', 'api_1_vendedor', 'api_1_configuracoes')));
					}

					if($metodo == 'configuracoes') {
						$post['modulo_api']	= 'usuario';
						$post['indice']			= 'usuarios';

						$post['id_externo']	= $dados['cms_usuario']->api_1_vendedor;
						$dados['unset']			= base64_encode(serialize(array('tipo', 'ativo', 'id', 'nome', 'cpf_cnpj', 'metodo', 'api_id', 'api_1_vendedor', 'api_1_grupos')));

						if(isset($dados['cms_usuario']->api_1_configuracoes) AND !empty($dados['cms_usuario']->api_1_configuracoes)) {
							$dados['api_1_configuracoes'] = unserialize(service('encrypter')->decrypt(hex2bin($dados['cms_usuario']->api_1_configuracoes), ['key' => getenv('ENCRYPTKEY')]));
						}
					}

					$post['dir_view']						= '\Modules\Cms_usuario\Views\Api_1\\';
					$post['row']								= $dados['cms_usuario'];
					$post['unset']							= $dados['unset'];
					$post['api_id']							= '1';
					$post['retorno']						= 'array';
					$post['requisicao']					= 'get';
					$post['curl_']							= $this->apiHelper->API_curlStruct($post);

					$this->_cms('Modules\Cms_usuario\Views\Api_1\view_cms_usuario_api_' . $idAPI, $dados);
				}
				else {
					service('session')->set('msg', array('titulo' => 'Acesso negado!', 'descricao' => 'No momento você não possui permissão para acessar este módulo', 'tipo' => 'error'));
					return redirect()->to(site_url(service('request')->uri->getSegment(1)));
				}
			}
		}
	}

	/**
	* alterando_cadastro_api
	* 
	* @version 1.0.0.0 - 2023-06-16
	* 
	* @param não definido ainda
	* 
	* @return não definido ainda
	*/ 

	public function cadastrandoAPI_1($id) {
		$post			= service('request')->getPost();
		$api_id 	= service('request')->getPost('api_id');
		$metodo		= service('request')->getPost('metodo');

		/*
		* Grupos
		*/

		if(!empty($post['api_1_grupos'])) {
			$post['api_1_grupos'] = serialize($post['api_1_grupos']);
		}
		else {
			$post['api_1_grupos'] = "";	
		}

		/*
		* Configurações
		*/

		if(isset($post['api_1_configuracoes']) AND !empty($post['api_1_configuracoes'])) {
			$post['api_1_configuracoes'] = bin2hex(service('encrypter')->encrypt(serialize($post['api_1_configuracoes']), ['key' => getenv('ENCRYPTKEY')]));
		}

		if(isset($post['unset']) AND !empty($post['unset'])) {
			$unset = $this->dataHelper->DH_isBase64($post['unset']);

			if(!empty($unset)) {
				foreach ($unset as $key => $value) {
					unset($post[$value]);
				}
			}

			unset($post['unset']);
		}

		$this->model_cms_usuario->alterando($id, $post);
		$this->dataHelper->DH_actionRecord($id, 'api', array('apiID' => $api_id, 'function' => $metodo, 'action' => 'update'));
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cms_usuario', 'item_' . $id);

		if(service('session')->get('usuario')->id == $id) {
			service('session')->set('usuario', $this->model_cms_usuario->alterar($id));
		}

		service('session')->set('msg', array('titulo' => 'Alteração realizada', 'descricao' => 'Suas alterações foram salvas com sucesso', 'tipo' => 'success'));
		return redirect()->to(site_url('cadastro-de-usuarios/api-cadastrar/' . $api_id . '/' . $id.'/' . $metodo));
	}
}