<?php
namespace Modules\Cms_usuario\Models;

use App\Models\BaseModel;

class Model_cms_usuario extends BaseModel {
	public function getCadastros() {
		$table 		= "cms_usuario";
		$builder  = $this->db->table($table);

		if(service('session')->get('usuario')->id_categoria <= 2) {
			$select  = "";
			$select .= "cms_usuario.*, ";
			$select .= "cms_usuario_categorias.titulo AS categoria, ";

			$select .= "api_0.id AS api_0_id, ";
			$select .= "CONCAT('" . PUBLICURL . 'uploads/upload_cad_ancora/item_' . "', api_0.id, '/', api_0.imagem) AS api_0_icon, ";

			$builder->select($select);

			$builder->join("cad_ancora AS api_0", "api_0.atalho = 'api_icon_0'", "left");

			$builder->join('cms_usuario_categorias', 'cms_usuario_categorias.id = ' . $table . '.id_categoria', 'left');
			$builder->where('cms_usuario.id_categoria >=', service('session')->get('usuario')->id_categoria);
		}
		else {
			$builder->select('cms_usuario.*, cms_usuario_categorias.titulo AS categoria');
			$builder->join('cms_usuario_categorias', 'cms_usuario_categorias.id = ' . $table . '.id_categoria', 'left');
			$builder->where('cms_usuario.id =', service('session')->get('usuario')->id);
		}

		$query  = $builder->get();
		$result = $query->getResult();

		return $result;
	}

	public function cadastrando() {
		$table 		= "cms_usuario";
		$builder  = $this->db->table($table);
		$query    = $builder->insert($_POST);

		return $this->db->insertID();
	}

	public function alterar($id) {
		$table 		= "cms_usuario";
		$builder  = $this->db->table($table);

		if(service('session')->get('usuario')->id_categoria <= 2) {
			$builder->where('id', $id);
			$query = $builder->get();

			return $query->getRow();
		}
		else {
			if(service('session')->get('usuario')->id == $id) {
				$builder->where('id', $id);
				$query = $builder->get();

				return $query->getRow();
			}
			else {
				return 0;
			}
		}
	}

	public function alterando($id, $post = NULL) {
		$table 			= "cms_usuario";
		$builder  	= $this->db->table($table);

		if(!empty($post)) {
			$post = $post;
		}
		else {
			$post = $_POST;
		}
		
		$builder->set('data_alteracao', date("Y-m-d H:i:s"));
		$builder->where('id', $id);
		$builder->update($post);

		return $id;
	}

	public function deletar($id) {
		if($id == 1) {
			service('session')->set('msg', array('titulo' => 'Remoção negada', 'descricao' => 'Este cadastro não pode ser removido', 'tipo' => 'error'));
		}
		else {
			$table 		= "cms_usuario";
			$builder  = $this->db->table($table);
			
			$builder->where('id', $id);
			$builder->delete();
		}
	}

	public function getUsuariosCategorias() {
		if(service('session')->get('usuario')->id_categoria == 1) {
			$table 		= "cms_usuario_categorias";
			$builder  = $this->db->table($table)->where('ativo', 1);
			$query    = $builder->get();
		}
		elseif(service('session')->get('usuario')->id_categoria == 2) {
			$table 		= "cms_usuario_categorias";
			$builder  = $this->db->table($table)->where('ativo', 1)->where('id >=', 2);
			$query    = $builder->get();
		}
		else {
			$table 		= "cms_usuario_categorias";
			$builder  = $this->db->table($table)->where('ativo', 1)->where('id >=', 3);
			$query    = $builder->get();
		}

		return $query->getResult();
	}

	public function getModulosCategorias() {
		if(service('session')->get('usuario')->id_categoria == 1) {
			$table 		= "cms_modulos_categorias";
			$builder  = $this->db->table($table)->where('ativo', 1);
			$query    = $builder->get();
		}
		else {
			$table 		= "cms_modulos_categorias";
			$builder  = $this->db->table($table)->where('ativo', 1)->where('root', 0);
			$query    = $builder->get();
		}

		return $query->getResult();
	}

	public function getModulos() {
		if(service('session')->get('usuario')->id_categoria == 1) {
			$table 		= "cms_modulos";
			$builder  = $this->db->table($table)->where('ativo', 1);
			$query    = $builder->get();
		}
		else {
			$table 		= "cms_modulos";
			$builder  = $this->db->table($table)->where('ativo', 1)->where('root', 0);
			$query    = $builder->get();
		}

		return $query->getResult();
	}

	/*
	*
	*/

	public function getDadosModulosCategoria($id) {
		$table 		= "cms_modulos_categorias";
		$builder  = $this->db->table($table)->where('id', $id);
		$query    = $builder->get();
		$result 	= $query->getRow();

		$result->submenu = array();

		return $result;
	}

	public function getDadosModulos($id, $modulos) {
		$table 		= "cms_modulos";
		$builder  = $this->db->table($table)->where('id_categoria', $id)->whereIn('id', $modulos);
		$query    = $builder->get();
		$result 	= $query->getResult();

		return $result;
	}
}