<?php
namespace Modules\Cms_usuario_categorias\Controllers;

use App\Controllers\BaseController;
use Modules\Cms_usuario_categorias\Models\model_cms_usuario_categorias;

class Cms_usuario_categorias extends BaseController {
	public function __construct() {
		$this->model_cms_usuario_categorias = new Model_cms_usuario_categorias;
	}

	public function index() {
	}
	
	public function listagem() {
		$dados['cms_usuario_categorias'] = $this->model_cms_usuario_categorias->getCadastros();

		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cms_usuario_categorias\Views\view_cms_usuario_categorias_listar', $dados);
	}

	public function cadastrar() {
		$dados['cms_modulos_categorias'] = $this->model_cms_usuario_categorias->getModulosCategorias();
		$dados['cms_modulos']            = $this->model_cms_usuario_categorias->getModulos();

		$this->dataHelper->DH_actionRecord();
		$this->_cms('Modules\Cms_usuario_categorias\Views\view_cms_usuario_categorias_cadastrar', $dados);
	}

	public function cadastrando() {
		$idModuloCategoria  = service('request')->getPost('id_modulo_categoria');
		$idModulo           = service('request')->getPost('id_modulo');

		$_POST['permissoes'] = base64_encode(serialize(array('idModuloCategoria' => $idModuloCategoria, 'idModulo' => $idModulo)));

		unset($_POST['id_modulo_categoria']);
		unset($_POST['id_modulo']);

		$id = $this->model_cms_usuario_categorias->cadastrando();
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Novo cadastro', 'cms_usuario_categorias', 'item_' . $id);
		$this->dataHelper->DH_actionRecord($id);

		service('session')->set('msg', array('titulo' => 'Sucesso', 'descricao' => 'Seu cadastro foi realizado.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
	}

	public function alterar($id) {
		if($id < $this->globalData['MyUser']->id_categoria) {
			service('session')->set('msg', array('titulo' => 'Ops!', 'descricao' => 'Você não tem permissão para acessar este cadastro', 'tipo' => 'error'));
			return redirect()->to(site_url(service('request')->uri->getSegment(1)));
		}
		else {
			$dados['id']                     = $id;
			$dados['cms_usuario_categorias'] = $this->model_cms_usuario_categorias->alterar($id);
			$dados['cms_modulos_categorias'] = $this->model_cms_usuario_categorias->getModulosCategorias();
			$dados['cms_modulos']            = $this->model_cms_usuario_categorias->getModulos();
			$dados['logs']									 = $this->dataHelper->DH_getLogFile('cms_usuario_categorias', 'item_' . $id);

			$this->dataHelper->DH_actionRecord($id);
			$this->_cms('Modules\Cms_usuario_categorias\Views\view_cms_usuario_categorias_cadastrar', $dados);
		}
	}

	public function alterando($id) {
		if($id < $this->globalData['MyUser']->id_categoria) {
			service('session')->set('msg', array('titulo' => 'Ops!', 'descricao' => 'Você não tem permissão para acessar este cadastro', 'tipo' => 'error'));
			return redirect()->to(site_url(service('request')->uri->getSegment(1)));
		}
		else {
			$idModuloCategoria  	= service('request')->getPost('id_modulo_categoria');
			$idModulo           	= service('request')->getPost('id_modulo');

			$moduloCadastrar			= service('request')->getPost('modulo_cadastrar');
			$moduloEditar					= service('request')->getPost('modulo_editar');
			$moduloSalvar					= service('request')->getPost('modulo_salvar');
			$moduloExcluir				= service('request')->getPost('modulo_excluir');
			$moduloLote						= service('request')->getPost('modulo_lote');

			$ar = array(
				'idModuloCategoria' 	=> $idModuloCategoria, 
				'idModulo' 						=> $idModulo,
				'moduloCadastrar' 		=> $moduloCadastrar,
				'moduloEditar' 				=> $moduloEditar,
				'moduloSalvar' 				=> $moduloSalvar,
				'moduloExcluir' 			=> $moduloExcluir,
				'moduloLote' 					=> $moduloLote
			);

			$_POST['permissoes'] = base64_encode(serialize($ar));

			unset($_POST['id_modulo_categoria']);
			unset($_POST['id_modulo']);

			unset($_POST['modulo_cadastrar']);
			unset($_POST['modulo_editar']);
			unset($_POST['modulo_salvar']);
			unset($_POST['modulo_excluir']);
			unset($_POST['modulo_lote']);

			$this->model_cms_usuario_categorias->alterando($id);
			$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'cms_usuario_categorias', 'item_' . $id);
			$this->dataHelper->DH_actionRecord($id);

			service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
			return redirect()->to(site_url(service('request')->uri->getSegment(1) . '/alterando-cadastro/' . $id));
		}
	}

	public function deletar($id) {
		if($id <= 2) {
			service('session')->set('msg', array('titulo' => 'Ops!', 'descricao' => 'Você não tem permissão para acessar este cadastro', 'tipo' => 'error'));
			return redirect()->to(site_url(service('request')->uri->getSegment(1)));
		}
		else {
			$dados = $this->model_cms_usuario_categorias->alterar($id);
			
			$this->model_cms_usuario_categorias->deletar($id);
			$this->dataHelper->DH_createLogFile($id, $dados, 'Exclusão de cadastro', 'cms_usuario_categorias', 'item_' . $id);
			$this->dataHelper->DH_actionRecord($id);

			service('session')->set('msg', array('titulo' => 'Remoção realizada', 'descricao' => 'Cadastro foi removido com sucesso', 'tipo' => 'success'));
			return redirect()->to(site_url(service('request')->uri->getSegment(1)));
		}
	}
}