<?php
namespace Modules\Cms_usuario_categorias\Models;

use App\Models\BaseModel;

class Model_cms_usuario_categorias extends BaseModel {
	public function getCadastros() {
		$table 		= "cms_usuario_categorias";
		$builder  = $this->db->table($table);

		if($this->globalData['MyUser']->id_categoria > 1) {
			$builder->where('id >= ', $this->globalData['MyUser']->id_categoria);
		}

		$query = $builder->get();
		return $query->getResult();
	}

	public function cadastrando() {
		$table 		= "cms_usuario_categorias";
		$builder  = $this->db->table($table);
		$query    = $builder->insert($_POST);

		return $this->db->insertID();
	}

	public function alterar($id) {
		$table 		= "cms_usuario_categorias";
		$builder  = $this->db->table($table)->where('id', $id);
		$query    = $builder->get();

		return $query->getRow();
	}

	public function alterando($id) {
		$table 		= "cms_usuario_categorias";
		$builder  = $this->db->table($table);
		
		$builder->set('data_alteracao', date("Y-m-d H:i:s"));
		$builder->where('id', $id);
		$builder->update($_POST);

		return $id;
	}

	public function deletar($id) {
		$table 		= "cms_usuario_categorias";
		$builder  = $this->db->table($table);
		
		$builder->where('id', $id);
		$builder->delete();
	}

	public function getUsuarioCategorias() {
		if($this->globalData['MyUser']->id_categoria == 1) {
			$table 		= "cms_usuario_categorias";
			$builder  = $this->db->table($table);
			$query    = $builder->get();
		}
		else {
			$table 		= "cms_usuario_categorias";
			$builder  = $this->db->table($table)->where('id !=', 1)->where('id !=', 2);
			$query    = $builder->get();
		}

		return $query->getResult();
	}

	public function getModulosCategorias() {
		if($this->globalData['MyUser']->id_categoria == 1) {
			$table 		= "cms_modulos_categorias";
			$builder  = $this->db->table($table)->where('ativo', 1);
			$query    = $builder->get();
		}
		else {
			$table 		= "cms_modulos_categorias";
			$builder  = $this->db->table($table)->where('ativo', 1)->where('root', 0);
			$query    = $builder->get();
		}

		return $query->getResult();
	}

	public function getModulos() {
		if($this->globalData['MyUser']->id_categoria == 1) {
			$table 		= "cms_modulos";
			$builder  = $this->db->table($table)->where('ativo', 1);
			$query    = $builder->get();
		}
		else {
			$table 		= "cms_modulos";
			$builder  = $this->db->table($table)->where('ativo', 1)->where('root', 0);
			$query    = $builder->get();
		}

		return $query->getResult();
	}
}