<?php
namespace Modules\Conf_email\Controllers;

use App\Controllers\BaseController;
use Modules\Conf_email\Models\model_conf_email;
use Store\DataHelper;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

class Conf_email extends BaseController {
	public function __construct() {
		$this->dataHelper				= new DataHelper;
		$this->model_conf_email = new Model_conf_email;
	}

	public function index() {
		$dados['id']				 = 1;
		$dados['conf_email'] = $this->model_conf_email->alterar();
		$dados['logs']			 = $this->dataHelper->DH_getLogFile('conf_email', '');

		$this->dataHelper->DH_actionRecord(1);
		$this->_cms('Modules\Conf_email\Views\view_conf_email_cadastrar', $dados);
	}

	public function alterando($id) {
		$dados = $this->model_conf_email->alterar();

		if(isset($_FILES['imagem']) and $_FILES['imagem']['error'] == 0) {
			$this->uploadHelper->UPH_uploadImage('conf_email', $dados->imagem, 'upload_conf_email', '', 'imagem', $dados->id);
		}

		if(isset($_POST['rem_imagem']) AND $_POST['rem_imagem'] == 1) {
			$this->dataHelper->DH_deleteImage('conf_email', 'imagem', 'upload_conf_email', '', $dados->imagem, $id);
		}

		$this->model_conf_email->alterando($id);
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'conf_email', '');
		$this->dataHelper->DH_actionRecord(1);

		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1)));
	}

	public function validar() {
		require PUBLICFOL . 'assets/vendor/PHPMailer-6.6.3/src/Exception.php';
		require PUBLICFOL . 'assets/vendor/PHPMailer-6.6.3/src/PHPMailer.php';
		require PUBLICFOL . 'assets/vendor/PHPMailer-6.6.3/src/SMTP.php';

		$mailConfig = $this->model_conf_email->alterar();

		$data = array(
			"data_atual"    => date('d/m/Y H:i:s'),
			"email_cabec" 	=> (!empty($mailConfig->imagem)) ? $mailConfig->imagem : ""
		);

		$html = view('Modules\Conf_email\Views\view_email_validacao', $data);

		try {
			$mail = new PHPMailer(true);

			$mail->isSMTP();

			if(!empty($mailConfig->e_debug) AND $mailConfig->e_debug == 1) {
				$mail->SMTPDebug 	= SMTP::DEBUG_SERVER;
			}
			else {
				$mail->SMTPDebug 	= 0;
			}

			$mail->Host       	= $mailConfig->e_host;
			$mail->Port       	= $mailConfig->e_port;

			if(!empty($mailConfig->e_secure) AND $mailConfig->e_secure != 'none') {
				$mail->SMTPAuth   = true;
				$mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
			}

			$mail->Username   	= $mailConfig->e_username;
			$mail->Password   	= $mailConfig->e_password;

			$mail->setFrom($mailConfig->e_from, $mailConfig->e_from_name);
			$mail->addAddress($mailConfig->e_send_formulario);     

			if(!empty($mailConfig->e_send_formulario_copia)) {
				$mail->addAddress($mailConfig->e_send_formulario_copia);
			}

			$mail->isHTML(true);

			$mail->CharSet = 'utf-8';
			$mail->Subject = "Teste de configuração - " . date('d/m/Y H:i:s');
			$mail->Body    = $html;
			$mail->AltBody = 'Suas configurações de e-mail foram validadas com sucesso. Os formulários de contato estão funcionando.';

			if(!$mail->send()) {
				$consulta = 0;
				echo json_encode($consulta);
			}
			else {
				$this->model_conf_email->validar();
				$consulta = 1;
				echo json_encode($consulta);
			}
		}
		catch (Exception $e) {
			$consulta = 0;
			echo json_encode($consulta);
		}
	}
}