<?php
namespace Modules\Conf_gerais\Controllers;

use App\Controllers\BaseController;
use Modules\Conf_gerais\Models\model_conf_gerais;
use Store\DataHelper;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

class Conf_gerais extends BaseController {
	public function __construct() {
		$this->dataHelper				= new DataHelper;
		$this->model_conf_gerais = new Model_conf_gerais;
	}

	public function index() {
		$dados['id']				 	= 1;
		$dados['conf_gerais'] = $this->model_conf_gerais->alterar();
		$dados['logs']			 	= $this->dataHelper->DH_getLogFile('conf_gerais', '');

		$this->dataHelper->DH_actionRecord(1);
		$this->_cms('Modules\Conf_gerais\Views\view_conf_gerais_cadastrar', $dados);
	}

	public function alterando($id) {
		$dados = $this->model_conf_gerais->alterar();

		$this->model_conf_gerais->alterando($id);
		$this->dataHelper->DH_createLogFile($id, $_POST, 'Alteração de cadastro', 'conf_gerais', '');
		$this->dataHelper->DH_actionRecord(1);

		service('session')->set('msg', array('titulo' => 'Sucesso!', 'descricao' => 'Suas alterações foram salvas.', 'tipo' => 'success'));
		return redirect()->to(site_url(service('request')->uri->getSegment(1)));
	}
}