<?php
namespace Modules\Inicial\Models;
use App\Models\BaseModel;

class Model_inicial extends BaseModel {
	public function getCards($usuario) {
		$un 		= base64_decode($usuario->permissoes);
		$un 		= unserialize($un);
		$cards 	= "";

		if(isset($un['moduloDashboard']) AND !empty($un['moduloDashboard'])) {
			foreach ($un['moduloDashboard'] as $key => $u) {
				$un['moduloDashboard'][$key] = str_replace('-1', '', $u);
			}

			$table = 'cms_modulos';

			$builder = $this->db->table($table)
			->select($table . '.*')
			->join('cms_modulos_categorias', $table . '.id_categoria = cms_modulos_categorias.id', 'left')
			->where('cms_modulos.dashboard', '1')
			->where('cms_modulos.ativo', '1')
			->where('cms_modulos_categorias.ativo', '1')
			->whereIn('cms_modulos.id', $un['moduloDashboard'])
			->groupBy($table . '.id');

			$cards = $builder->get()->getResult();

			foreach($cards as $key => $card) {
				$card->total 			= $this->db->table($card->nome)->selectCount('id', 'cadastros')->get()->getRow();
				$card->ativos 		= $this->db->table($card->nome)->selectCount('id', 'cadastros')->where('ativo', '1')->get()->getRow();
				$card->inativos 	= $this->db->table($card->nome)->selectCount('id', 'cadastros')->where('ativo', '0')->get()->getRow();
			}
		}

		return $cards;
	}
}
