<?php
namespace Modules\Login\Models;

use App\Models\BaseModel;
use CodeIgniter\I18n\Time;

helper('date');

class Model_login extends BaseModel {
	public function autenticar($email, $senha) {
		if(filter_var($email, FILTER_VALIDATE_EMAIL)) {
			$table 					= "cms_usuario";
			$builder  			= $this->db->table($table)->where('email', $email)->where('ativo', 1);
			$query    			= $builder->get();

			$usuario  			= $query->getRow();
			$usuario->senha = service('encrypter')->decrypt(hex2bin($usuario->senha), ['key' => getenv('ENCRYPTKEY')]);

			if(!empty($usuario) AND trim($senha) == trim($usuario->senha)) {
				if($usuario->id == 1) {

					/*
					* Gera token de acesso
					*/

					$randomToken = bin2hex(random_bytes(80));

					/*
					* Atualiza o token de acesso do usuário
					*/

					$table 		= "cms_usuario";
					$builder  = $this->db->table($table);

					$builder->set('token_homologacao', $randomToken)->where('id', $usuario->id);
					$builder->update();
					
					$usuario->token_homologacao = $randomToken;

					/*
					* SET ::: Cookie para acesso ao projeto, mesmo estando em manutenção
					*/
					
					service('response')->setCookie('homologacao', 'enabled', time()+86400);
				}

				service('session')->set('modulos_permite_acesso', 1);
				service('session')->set('usuario_logado', 1);
				service('session')->set('usuario', $usuario);

				$data = [
					'id_usuario' 			=> $usuario->id,
					'modulo'  	 			=> 'Login',
					'metodo'  				=> 'Login',
					'id_item'  				=> 0,
					'descricao'  			=> "O usuário <b>" . $usuario->titulo . "</b> acessou o painel.",
					'ativo'  					=> 1,
					'data_cadastro'  	=> date("Y-m-d H:i:s")
				];

				$table 		= "cms_auditoria";
				$builder  = $this->db->table($table);
				$query    = $builder->insert($data);

				return 1;
			} 
			else {

				/*
				* EMAIL E/OU SENHA INCORRETOS
				*/

				$data = [
					'id_usuario' 			=> 0,
					'modulo'  	 			=> 'Login',
					'metodo'  				=> 'Login',
					'id_item'  				=> 0,
					'descricao'  			=> "Houve uma tentativa de acesso, com o e-mail e/ou senha incorretos.",
					'ativo'  					=> 1,
					'data_cadastro'  	=> date("Y-m-d H:i:s")
				];

				$table 		= "cms_auditoria";
				$builder  = $this->db->table($table);
				$query    = $builder->insert($data);

				return 3;
			}
		} 
		else {

			/*
			* EMAIL INVALIDO
			*/

			$data = [
				'id_usuario' 			=> 0,
				'modulo'  	 			=> 'Login',
				'metodo'  				=> 'Login',
				'id_item'  				=> 0,
				'descricao'  			=> "Houve uma tentativa de acesso, com um e-mail inválido.",
				'ativo'  					=> 1,
				'data_cadastro'  	=> date("Y-m-d H:i:s")
			];

			$table 		= "cms_auditoria";
			$builder  = $this->db->table($table);
			$query    = $builder->insert($data);

			return 2;
		}
	}

	public function getUsuario($email, $id=null) {
		$table = 'cms_usuario';
		$builder = $this->db->table($table);

		if(empty($id)) {
			$builder->where('email', $email);
		}else {
			$builder->where('id', $id);
		}

		$query = $builder->get();
		return $query->getRow();
	}

	public function atualizaSenha($senha, $id, $nome) {
		$table = 'cms_usuario';
		$builder = $this->db->table($table);

		$builder->set('senha', $senha);
		$builder->where('id', $id);
		$builder->update();

		$data = [
			'id_usuario' 		=> $id,
			'modulo'  	 		=> 'Login',
			'metodo'  			=> 'Update',
			'id_item'  			=> 0,
			'descricao'  		=> "O usuário <b>" . $nome . "</b> solicitou uma nova senha.",
			'ativo'  			=> 1,
			'data_cadastro'  	=> date("Y-m-d H:i:s")
		];

		$table 	   = "cms_auditoria";
		$builder2  = $this->db->table($table);
		$query     = $builder2->insert($data);
	}

	public function deslogar() {
		$usuario 	= service('session')->get('usuario');

		$data = [
			'id_usuario' 			=> $usuario->id,
			'modulo'  	 			=> 'Login',
			'metodo'  				=> 'Logout',
			'id_item'  				=> 0,
			'descricao'  			=> "O usuário <b>" . $usuario->titulo . "</b> saiu o painel.",
			'ativo'  					=> 1,
			'data_cadastro'  	=> date("Y-m-d H:i:s")
		];

		$table 		= "cms_auditoria";
		$builder  = $this->db->table($table);
		$query    = $builder->insert($data);

		return 1;
	}
}