// ---------------------------------------------------------------------------------------------]
// ---------------------------------------------------------------------------------------[ All ]
// ---------------------------------------------------------------------------------------------]

const COLORS = [
	'#4dc9f699',
	'#f5379499',
	'#537bc499',
	'#acc23699',
	'#166a8f99',
	'#00a95099',
	'#58595b99',
	'#8549ba99'
	];

/*
* All ::: Swal (2) - Warning
*/

function swal_padrao_warning(mensagem) {
	Swal.fire({
		title:  					"<hr>ERRO!",
		icon:   					"error",
		html:   					"<hr>" + mensagem,
		iconHtml: 				"!",
		showCloseButton: 		true,
		showConfirmButton: 	false,
		showCancelButton: 	false,
		focusConfirm: 			false,
		allowOutsideClick: 	false,
		allowEscapeKey: 		false,
		allowEnterKey: 			false,
		backdrop: 					true
	});
}

/*
* All ::: Swal (2) - Success
*/

function swal_padrao_success(mensagem) {
	Swal.fire({
		title:  						"<hr>SUCESSO!",
		icon:   						"success",
		html:   						"<hr>" + mensagem,
		iconHtml: 					"!",
		showCloseButton: 		true,
		showConfirmButton: 	false,
		showCancelButton: 	false,
		focusConfirm: 			false,
		allowOutsideClick: 	false,
		allowEscapeKey: 		false,
		allowEnterKey: 			false,
		backdrop: 					true
	});
}

/*
* All ::: JS_curlStruct
*/

function JS_curlStruct(param) {
	var row           = $(param).data('row');
	var metodo      	= $(param).data('metodo');
	var requisicao		= $(param).data('requisicao');
	var indice        = $(param).data('indice');
	var view_reload   = $(param).data('view-reload');
	var dir_view      = $(param).data('view-directory');
	var modulo_api    = $(param).data('api-modulo');
	var api_id 				= $(param).data('api-id');

	if($('.class_input').length) {
		var campos = new Array();

		$('.class_input').each(function () {
			var objeto  = {
				required: $(this).data('required'),
				valor: 		$(this).val(),
				name: 		$(this).attr("name")
			};

			campos.push(objeto);
		});
	}
	else {
		var campos = '';
	}

	if(campos == '') {
		swal_padrao_warning('Utilize um dos filtros para buscar');
	}
	else {
		var load = "";
		load  += "<div class='carrega_busca_alert col-12 text-center mt-3'></div>";
		load  += "	<div class='alert alert-info' role='alert'>";
		load  += "		<i class='fa fa-spinner fa-spin fa-1x fa-fw margin-bottom'></i><br/><b>Carregando...</b>";
		load  += "	</div>";
		load  += "</div>";

		var empty = "";
		empty += "<div class='carrega_busca_alert col-12 text-center mt-3'>";
		empty += "	<div class='alert alert-danger' role='alert'>";
		empty += "		<i class='fa fa-exclamation-triangle'></i><br/><b>Nenhum registro encontrado.</b>";
		empty += "	</div>";
		empty += "</div>";

		$(".carrega_busca").html("");
		$('#spiner').show();

		$.ajax({
			async: 		true,
			type: 		"POST",
			dataType: "json",
			url: 			BASE_URL + "API_curlStruct",
			data: {
				csrf_token: 	CSRF_TOKEN, 
				row: 					row,								
				metodo: 			metodo,										
				requisicao:		requisicao,										
				indice: 			indice,										
				view_reload: 	view_reload,												
				dir_view: 		dir_view,											
				modulo_api: 	modulo_api,												
				api_id: 			api_id,										
				campos: 			campos
			},
			success: function(data) {
				if(data.erro == 1) {   
					$(".carrega_busca").html(""); 
					swal_padrao_warning(data.msg);
				}
				else {
					$(".carrega_busca").append(data.html);
				}  
			},
			complete: function(data) {
				iChecks();
				$('#spiner').hide();
			}
		});
	}
}

// ---------------------------------------------------------------------------------------------]
// ---------------------------------------------------------------------------[ PEDIDOS - API 1 ]
// ---------------------------------------------------------------------------------------------]

var form 																				= $('#form_principal');

var selectPedidoClientes					 							= $('.form-select-pedido-clientes');
var selectPedidoTabelasPreco			 							= $('.form-select-pedido-tabelas-preco');
var selectPedidoGrupos 						 							= $('.form-select-pedido-grupos');
var selectPedidoProdutos 					 							= $('.form-select-pedido-produtos');
var selectPedidoSetorEstoque			 							= $('.form-select-pedido-setor-estoque');
var selectPedidoEndereco					 							= $('.form-select-pedido-endereco');
var selectProdutoPorcentagemDesconto 						= $('.form-select-porcentagem-desconto');

var inputProdutoEstoqueAtual 			 							= $('.form-input-estoque-atual');
var inputProdutoQuantidade 				 							= $('.form-input-quantidade');
var inputProdutoPrecoUnitario 		 							= $('.form-input-preco-unitario');
var inputProdutoPrecoTotal 				 							= $('.form-input-preco-total');

var inputProdutoPrecoTotalDesconto 							= $('.form-input-preco-total-desconto');
var inputProdutoPrecoTotalDescontoMax 					= $('.form-input-porcentagem-desconto-maxima');
var inputProdutoPrecoDesconto 									= $('.form-input-preco-desconto');

var btnPedidoCadastrarProduto			 							= $('.btn-pedido-cadastrar-produto');
var listPedidoProdutos						 							= $('.row-pedido-produtos-list');
var iboxPedidoProdutos						 							= $('.ibox-content-product-list');
var btnPedidoItemAcoes 						 							= $('.btn-info-acoes-remover');

var inputHiddenIdentificacaoInterna 						= $('.input-hidden-identificacao-interna');
var inputHiddenCodigoExterno 										= $('.input-hidden-codigo-externo');
var inputHiddenSituacao 												= $('.input-hidden-situacao');
var inputHiddenCancelado 												= $('.input-hidden-cancelado');
var inputHiddenContato 													= $('.input-hidden-contato');
var inputHiddenFrete 														= $('.input-hidden-frete');
var inputHiddenTabela 													= $('.input-hidden-tabela');
var inputHiddenDestacar 												= $('.input-hidden-destacar');
var inputHiddenSituacaoSeparacao 								= $('.input-hidden-situacao-separacao');
var inputHiddenTipoPedidoId 										= $('.input-hidden-tipo-pedido-id');
var inputHiddenStatusId 												= $('.input-hidden-status-id');
var inputHiddenFilialId 												= $('.input-hidden-filial-id');
var inputHiddenVendedorId 											= $('.input-hidden-vendedor-id');
var inputHiddenTransportadoraId 								= $('.input-hidden-transportadora-id');
var inputHiddenFormaPagamentoId 								= $('.input-hidden-forma-pagamento-id');
var inputHiddenSetorId 													= $('.input-hidden-setor-id');
var inputHiddenValorTotalServico 								= $('.input-hidden-valor-total-servico');
var inputHiddenValorDescontosServico 						= $('.input-hidden-valor-descontos-servico');
var inputHiddenValorTotalProduto 								= $('.input-hidden-valor-total-produto');
var inputHiddenValorDescontosProduto 						= $('.input-hidden-valor-descontos-produto');
var inputHiddenValorFrete 											= $('.input-hidden-valor-frete');
var inputHiddenValorOutraDespesas 							= $('.input-hidden-valor-outra-despesas');
var inputHiddenValorTotalGeral 									= $('.input-hidden-valor-total-geral');
var inputHiddenPesoBruto 												= $('.input-hidden-peso-bruto');
var inputHiddenPesoLiquido 											= $('.input-hidden-peso-liquido');
var inputHiddenQuantidadeVolumes 								= $('.input-hidden-quantidade-volumes');
var inputHiddenValorTotalPis 										= $('.input-hidden-valor-total-pis');
var inputHiddenValorTotalCofins 								= $('.input-hidden-valor-total-cofins');
var inputHiddenValorTotalFcp 										= $('.input-hidden-valor-total-fcp');
var inputHiddenValorTotalIcmsRecolhido 					= $('.input-hidden-valor-total-icms-recolhido');
var inputHiddenValorTotalIcmsSub 								= $('.input-hidden-valor-total-icms-sub');
var inputHiddenValorBaseIcmsSub 								= $('.input-hidden-valor-base-icms-sub');
var inputHiddenValorBaseFcp 										= $('.input-hidden-valor-base-fcp');
var inputHiddenTributos 												= $('.input-hidden-tributos');
var inputHiddenDataCadastro 										= $('.input-hidden-data-cadastro');
var inputHiddenHoraCadastro 										= $('.input-hidden-hora-cadastro');
var inputHiddenDataPedido 											= $('.input-hidden-data-pedido');
var inputHiddenHoraPedido 											= $('.input-hidden-hora-pedido');
var inputHiddenDataAprovacao 										= $('.input-hidden-data-aprovacao');
var inputHiddenHoraAprovacao 										= $('.input-hidden-hora-aprovacao');
var inputHiddenDataPrevisaoEntrega 							= $('.input-hidden-data-previsao-entrega');
var inputHiddenDataPrazoFaturamento 						= $('.input-hidden-data-prazo-faturamento');
var inputHiddenDataUltimaAtualizacao 						= $('.input-hidden-data-ultima-atualizacao');
var inputHiddenDataUltimaAtualizacaoIntegracao 	= $('.input-hidden-data-ultima-atualizacao-integracao');
var inputHiddenObservacoes 											= $('.input-hidden-observacoes');
var inputHiddenObservacoes2 										= $('.input-hidden-observacoes2');

var inputHiddenEndereco													= $('.input-hidden-endereco');
var inputHiddenCliente													= $('.input-hidden-cliente');
var inputHiddenParcelas													= $('.input-hidden-parcelas');

var btnAcoesPedidoEnviar												= $('.btn-acoes-pedido-enviar');

var rowPedidoClientes														= $('.row-pedido-clientes');
var rowPedidoGruposProdutos											= $('.row-pedido-grupos-produtos');
var rowPedidoEstoqueQuantidadePreco							= $('.row-pedido-estoque-quantidade-preco');
var rowPedidoEstoqueQuantidadeDesconto					= $('.row-pedido-estoque-quantidade-desconto');
var rowPedidoAcao																= $('.row-pedido-acao');
var rowPedidoProdutos														= $('.row-pedido-produtos');

var btnPedidoLocalizacaoPermissao								= $('.btn-pedido-localizacao-permissao');
var btnPedidoLocalizacaoEnviar									= $('.btn-pedido-localizacao-enviar');
var btnPedidoLocalizacaoPermitida								= $('.btn-pedido-localizacao-permitida');
var btnPedidoLocalizacaoBloqueado								= $('.btn-pedido-localizacao-bloqueado');

var spanPedidosLatitude 												= $('.span-pedidos-latitude');
var spanPedidosLongitude 												= $('.span-pedidos-longitude');
var spanPedidosPrecisao 												= $('.span-pedidos-precisao');
var spanPedidosEndereco 												= $('.span-pedidos-endereco');

var listLocalizacaoHistorico			 							= $('.ibox-content-historic');
var btnFooter																		= $('.btn-footer');

if(iboxPedidoProdutos.length > 0) {
	iboxPedidoProdutos.slimscroll({
		height: '500px'
	});
}

if(listLocalizacaoHistorico.length) {
	listLocalizacaoHistorico.slimscroll({
		height: '250px'
	});
}

if(selectPedidoClientes.length > 0) {
	selectPedidoClientes.on('change', function(event) {
		console.log("Log: Geo Localização - selectPedidoClientes");

		event.preventDefault();

		btnPedidoCadastrarProduto.prop( "disabled", true );
		
		var id_cliente 				= $(this).find(':selected').val();
		var dados 						= $(this).find(':selected').data('cliente');
		var tabelas_preco 		= $(this).find(':selected').data('tabelas-preco');
		var endereco 					= $(this).find(':selected').data('endereco');
		var endereco_cobranca = $(this).find(':selected').data('endereco-cobranca');
		var endereco_entrega 	= $(this).find(':selected').data('endereco-entrega');

		inputHiddenEndereco.val('');
		inputHiddenCliente.val( JSON.stringify(dados) );

		selectPedidoGrupos.prop( "disabled", true );

		selectPedidoGrupos.val('');
		selectPedidoProdutos.val('').prop( "disabled", true ).append( '<option disabled selected hidden value="">Selecione um dos grupos primeiro...</option>' );
		selectPedidoSetorEstoque.val('').prop( "disabled", true );

		inputProdutoEstoqueAtual.val('');
		inputProdutoQuantidade.val('').prop( "disabled", true );
		inputProdutoPrecoUnitario.val('');
		inputProdutoPrecoTotal.val('');

		inputProdutoPrecoTotalDescontoMax.val('').prop( "disabled", true );
		selectProdutoPorcentagemDesconto.val('').prop( "disabled", true );
		inputProdutoPrecoTotalDesconto.val('').prop( "disabled", true );
		
		selectPedidoTabelasPreco.html('').append( '<option disabled selected hidden value="">Selecione uma tabela de preços</option>' );

		$.each(tabelas_preco, function(index, val) {
			selectPedidoTabelasPreco.append( '<option value="' + val.id + '">' + val.descricao + '</option>' );
		});

		selectPedidoTabelasPreco.prop( "disabled", false );

		selectPedidoEndereco.html('').prop( "disabled", false );
		selectPedidoEndereco.append( '<option disabled selected hidden value="">Selecione um endereço</option>' );

		var attrEnd = "";
		attrEnd += "data-dados='" + JSON.stringify( endereco ) + "'";
		attrEnd += "data-logradouro='" + endereco.logradouro + "'";
		attrEnd += "data-cep='" + endereco.cep + "'";
		attrEnd += "data-numero='" + endereco.numero + "'";
		attrEnd += "data-bairro='" + endereco.bairro + "'";
		attrEnd += "data-cidade='" + endereco.cidade + "'";
		attrEnd += "data-estado='" + endereco.estado + "'";
		attrEnd += "data-complemento='" + endereco.complemento + "'";
		attrEnd += "data-codigo-ibge-cidade='" + endereco.codigo_ibge_cidade + "'";
		attrEnd += "data-codigo-ibge-pais='" + endereco.codigo_ibge_pais + "'";

		selectPedidoEndereco.append( '<option value="endereco" ' + attrEnd + '>' + endereco.logradouro + '</option>' );

		if(endereco_cobranca.logradouro !== '') {
			var attrEndCob = "";
			attrEndCob += "data-dados='" + JSON.stringify( endereco_cobranca ) + "'";
			attrEndCob += "data-logradouro='" + endereco_cobranca.logradouro + "'";
			attrEndCob += "data-cep='" + endereco_cobranca.cep + "'";
			attrEndCob += "data-numero='" + endereco_cobranca.numero + "'";
			attrEndCob += "data-bairro='" + endereco_cobranca.bairro + "'";
			attrEndCob += "data-cidade='" + endereco_cobranca.cidade + "'";
			attrEndCob += "data-estado='" + endereco_cobranca.estado + "'";
			attrEndCob += "data-complemento='" + endereco_cobranca.complemento + "'";
			attrEndCob += "data-codigo-ibge-cidade='" + endereco_cobranca.codigo_ibge_cidade + "'";
			attrEndCob += "data-codigo-ibge-pais='" + endereco_cobranca.codigo_ibge_pais + "'";

			selectPedidoEndereco.append( '<option value="endereco_cobranca" ' + attrEndCob + '>' + endereco_cobranca.logradouro + '</option>' );
		}

		if(endereco_entrega.logradouro !== '') {
			var attrEndEnt = "";
			attrEndEnt += "data-dados='" + JSON.stringify( endereco_cobranca ) + "'";
			attrEndEnt += "data-logradouro='" + endereco_cobranca.logradouro + "'";
			attrEndEnt += "data-cep='" + endereco_cobranca.cep + "'";
			attrEndEnt += "data-numero='" + endereco_cobranca.numero + "'";
			attrEndEnt += "data-bairro='" + endereco_cobranca.bairro + "'";
			attrEndEnt += "data-cidade='" + endereco_cobranca.cidade + "'";
			attrEndEnt += "data-estado='" + endereco_cobranca.estado + "'";
			attrEndEnt += "data-complemento='" + endereco_cobranca.complemento + "'";
			attrEndEnt += "data-codigo-ibge-cidade='" + endereco_cobranca.codigo_ibge_cidade + "'";
			attrEndEnt += "data-codigo-ibge-pais='" + endereco_cobranca.codigo_ibge_pais + "'";

			selectPedidoEndereco.append( '<option value="endereco_entrega" ' + attrEndEnt + '>' + endereco_entrega.logradouro + '</option>' );
		}

		$('.pedido-endereco-logradouro').html('');
		$('.pedido-endereco-cep').html('');
		$('.pedido-endereco-numero').html('');
		$('.pedido-endereco-bairro').html('');
		$('.pedido-endereco-cidade').html('');
		$('.pedido-endereco-estado').html('');
		$('.pedido-endereco-complemento').html('');
	});
}

if(selectPedidoTabelasPreco.length > 0) {
	selectPedidoTabelasPreco.on('change', function(event) {
		console.log("Log: Geo Localização - selectPedidoTabelasPreco");

		event.preventDefault();

		btnPedidoCadastrarProduto.prop( "disabled", true );

		selectPedidoGrupos.val('').append( '<option disabled selected hidden value="">Selecione um dos grupos</option>' ).prop( "disabled", false );
		selectPedidoProdutos.val('').prop( "disabled", true ).append( '<option disabled selected hidden value="">Selecione um dos grupos primeiro...</option>' );
		selectPedidoSetorEstoque.val('').prop( "disabled", true );

		inputProdutoEstoqueAtual.val('');
		inputProdutoQuantidade.val('').prop( "disabled", true );
		inputProdutoPrecoUnitario.val('');
		inputProdutoPrecoTotal.val('');

		inputProdutoPrecoTotalDescontoMax.val('').prop( "disabled", true );
		selectProdutoPorcentagemDesconto.val('').prop( "disabled", true );
		inputProdutoPrecoTotalDesconto.val('').prop( "disabled", true );
	});
}

if(selectPedidoGrupos.length > 0) {
	selectPedidoGrupos.on('change', function() {
		console.log("Log: Geo Localização - selectPedidoGrupos");


		btnPedidoCadastrarProduto.prop( "disabled", true );

		$('#spiner').show();

		selectPedidoGrupos.prop( "disabled", true );
		selectPedidoProdutos.prop( "disabled", true );
		selectPedidoProdutos.html('').append( '<option disabled selected hidden value="">Carregando produtos...</option>' );
		selectPedidoSetorEstoque.val('').prop( "disabled", true ).html('').append( '<option disabled selected hidden value="">Selecione um dos produtos primeiro...</option>' );;

		inputProdutoEstoqueAtual.val('');
		inputProdutoQuantidade.prop( "disabled", true ).val('');
		inputProdutoPrecoUnitario.val('');
		inputProdutoPrecoTotal.val('');

		inputProdutoPrecoTotalDescontoMax.val('').prop( "disabled", true );
		selectProdutoPorcentagemDesconto.val('').prop( "disabled", true );
		inputProdutoPrecoTotalDesconto.val('').prop( "disabled", true );

		var id_grupo = $(this).find(':selected').val();

		var jqXHR = $.ajax({
			type: 		'POST',
			dataType: "json",
			url: 			BASE_URL + CLASSE + "/ajaxPedidosGetProdutos",
			data: { 
				csrf_token: CSRF_TOKEN, 
				id_grupo: 	id_grupo
			}
		})
		
		jqXHR.done(function( result ) {
			selectPedidoProdutos.html('');
			selectPedidoGrupos.prop( "disabled", false );
			selectPedidoProdutos.prop( "disabled", false );

			selectPedidoProdutos.append( '<option disabled selected hidden value="">Selecione um produto...</option>' );

			$.each(result, function(index, val) {
				selectPedidoProdutos.append( '<option value="' + val.id + '">' + val.descricao + '</option>' );
			});
		});
		
		jqXHR.fail(function(jqXHR, textStatus, errorThrown) {
			console.log("Status da requisição: " + textStatus); 
			console.log("Erro lançado: " + errorThrown); 
			console.log("Resposta do servidor: " + jqXHR.responseText);
		});
		
		jqXHR.always(function() {
			$('#spiner').hide();
		});
	});
}

if(selectPedidoProdutos.length > 0) {
	selectPedidoProdutos.on('change', function(event) {
		console.log("Log: Geo Localização - selectPedidoProdutos");

		if(USER_CAT > 2) {
			if(API1_USER_ESTOQUE_LOCAL == 0) {
				console.log("Log: Geo Localização - selectPedidoProdutos ( Não, deixe apenas a Matriz como opção )");
			}

			if(API1_USER_ESTOQUE_LOCAL == 1) {
				console.log("Log: Geo Localização - selectPedidoProdutos ( Sim, pode selecionar o local )");
			}
		}
		else { 
			console.log("Log: Geo Localização - selectPedidoProdutos ( Acesso administrativo )");
		}

		event.preventDefault();

		btnPedidoCadastrarProduto.prop( "disabled", true );
		selectPedidoSetorEstoque.prop( "disabled", true );

		inputProdutoEstoqueAtual.val('');
		inputProdutoQuantidade.prop( "disabled", true ).val('');
		inputProdutoPrecoUnitario.val('');
		inputProdutoPrecoTotal.val('');

		inputProdutoPrecoTotalDescontoMax.val('').prop( "disabled", true );
		selectProdutoPorcentagemDesconto.val('').prop( "disabled", true );
		inputProdutoPrecoTotalDesconto.val('').prop( "disabled", true );

		var id_produto = $(this).find(':selected').val();

		$.ajax({
			type: 		'POST',
			dataType: "json",
			url: 			BASE_URL + CLASSE + "/ajaxPedidosGetProdutoEstoque",
			data: { 
				csrf_token: CSRF_TOKEN, 
				id_produto: id_produto
			}
		})
		.done(function( result ) {
			selectPedidoSetorEstoque.prop( "disabled", false ).html('').append( '<option disabled selected hidden value="">Selecione um setor</option>' );

			$.each(result, function(index, val) {

				var htmlOptionPedidoSetorEstoque = "";
				htmlOptionPedidoSetorEstoque += '<option value="' + val.setor_estoque_id + '" data-estoque-atual="' + val.estoque_atual + '">';
				htmlOptionPedidoSetorEstoque += 	val.descricao_setor_estoque
				htmlOptionPedidoSetorEstoque += '</option>';

				if(USER_CAT > 2) {
					if(API1_USER_ESTOQUE_LOCAL == 0 && val.setor_estoque_id == API1_USER_MATRIZ) {
						selectPedidoSetorEstoque.append( htmlOptionPedidoSetorEstoque );
					}

					if(API1_USER_ESTOQUE_LOCAL == 1) { 
						selectPedidoSetorEstoque.append( htmlOptionPedidoSetorEstoque );
					}
				}
				else {
					selectPedidoSetorEstoque.append( htmlOptionPedidoSetorEstoque );
				}
			});
		})
		.fail(function() {
		})
		.always(function() {
		});
	});
}

if(selectPedidoSetorEstoque.length > 0) {
	selectPedidoSetorEstoque.on('change', function(event) {
		console.log("Log: Geo Localização - selectPedidoSetorEstoque");

		if(API1_CONFIG_ESTOQUE == 0) {
			console.log("Log: Geo Localização - selectPedidoSetorEstoque ( Não, não quero levar em consideração o estoque do produto )");
		}

		if(API1_CONFIG_ESTOQUE == 1) {
			console.log("Log: Geo Localização - selectPedidoSetorEstoque ( Sim, levar em consideração o estoque do produto )");
		}

		event.preventDefault();

		btnPedidoCadastrarProduto.prop( "disabled", true );

		inputProdutoPrecoTotalDescontoMax.val('').prop( "disabled", true );
		selectProdutoPorcentagemDesconto.val('').prop( "disabled", true );
		inputProdutoPrecoTotalDesconto.val('').prop( "disabled", true );

		var id_setor_estoque 	= $(this).find(':selected').val();
		var estoque_atual 		= $(this).find(':selected').data('estoque-atual');

		inputProdutoEstoqueAtual.val( estoque_atual );

		if(API1_CONFIG_ESTOQUE == 1 && estoque_atual <= 0) {
			inputProdutoQuantidade.prop( "disabled", true ).val('');

			var toastIcon			= '<i class="fa-light fa-triangle-exclamation me-1"></i>';
			var toastTitle		= 'Ops!';
			var toastMessage	= 'O estoque deste produto é menor ou igual a zero no setor selecionado.';
			var toastType			= 'toast-danger';
			var toastDelay		= 5000;
			var toastAutohide	= true;

			toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);
		}
		else {
			inputProdutoQuantidade.prop( "disabled", false ).val('');
		}

		inputProdutoPrecoUnitario.val('');
		inputProdutoPrecoTotal.val('');
	});
}

if(inputProdutoQuantidade.length > 0) {
	var typingTimer;               
	var doneTypingInterval = 1000;  

	inputProdutoQuantidade.on('keyup', function(event) {
		console.log("Log: Geo Localização - inputProdutoQuantidade (keyup)");

		event.preventDefault();

		btnPedidoCadastrarProduto.prop( "disabled", true );

		inputProdutoPrecoTotalDescontoMax.val('').prop( "disabled", true );
		selectProdutoPorcentagemDesconto.val('').prop( "disabled", true );
		inputProdutoPrecoTotalDesconto.val('').prop( "disabled", true );

		clearTimeout(typingTimer);

		typingTimer = setTimeout(function() { 
			var id_produto	= selectPedidoProdutos.find(':selected').val();
			var id_tabela		= selectPedidoTabelasPreco.find(':selected').val();
			var estoque 		= parseInt(inputProdutoEstoqueAtual.val());
			var qntd 				= parseInt(inputProdutoQuantidade.val());

			if(API1_CONFIG_ESTOQUE == 1 && qntd > estoque || qntd <= 0) {
				var toastIcon			= '<i class="fa-light fa-triangle-exclamation me-1"></i>';
				var toastTitle		= 'Ops!';
				var toastMessage	= 'A quantidade informada é inválida.';
				var toastType			= 'toast-danger';
				var toastDelay		= 5000;
				var toastAutohide	= true;

				toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);
				inputProdutoQuantidade.val('');
				inputProdutoPrecoUnitario.val('');
				inputProdutoPrecoTotal.val('');
			}
			else {
				inputProdutoPrecoUnitario.val('').val('Calculando...');
				inputProdutoPrecoTotal.val('').val('Calculando...');

				$.ajax({
					type: 		'POST',
					dataType: "json",
					url: 			BASE_URL + CLASSE + "/ajaxPedidosGetProdutoPreco",
					data: { 
						csrf_token: CSRF_TOKEN, 
						id_produto: id_produto,
						id_tabela: 	id_tabela,
						estoque: 		estoque,
						qntd: 			qntd
					}
				})
				.done(function( result ) {
					result = result[0];
					var preco_unitario = result.preco_venda;

					if(preco_unitario > 0) {
						var preco_total = ( parseFloat( preco_unitario ) * parseInt( qntd ) );

						inputProdutoPrecoUnitario.val('').val(numberToReal(preco_unitario));
						inputProdutoPrecoTotal.val('').val(numberToReal(preco_total));
					}
					else {
						inputProdutoPrecoUnitario.val('').val('R$ 0,00');
						inputProdutoPrecoTotal.val('').val('R$ 0,00');
					}

					/*
					* Teste de desconto
					*/

					// result.percentual_desconto_maximo = 5.0;
					// result.percentual_desconto_maximo_promocao = 5.0;

					/*
					* Teste de desconto - End
					*/

					inputProdutoPrecoTotalDescontoMax.val('').val(result.percentual_desconto_maximo + "% de desconto");

					if(result.promocao_ativa == "S") {
						console.log("Log: Geo Localização - inputProdutoQuantidade ( Promoção habilitada )");

						if(result.percentual_desconto_maximo_promocao > 0) {
							console.log("Log: Geo Localização - inputProdutoQuantidade ( Promoção habilitada, com porcentagem máxima definida )");

							selectProdutoPorcentagemDesconto.html('');

							for (var i = 0; i <= result.percentual_desconto_maximo_promocao; i++) {
								selectProdutoPorcentagemDesconto.append( '<option value="' + i + '">' + i + '%</option>' );
							}

							selectProdutoPorcentagemDesconto.prop( "disabled", false );
							inputProdutoPrecoTotalDesconto.prop( "disabled", true );
						}
						else {
							console.log("Log: Geo Localização - inputProdutoQuantidade ( Promoção habilitada, com porcentagem máxima definida )");
						}
					}
					else {
						console.log("Log: Geo Localização - inputProdutoQuantidade ( Promoção desabilitada )");

						selectProdutoPorcentagemDesconto.append( '<option value="">Sem desconto disponível</option>' );
						inputProdutoPrecoTotalDescontoMax.val('Sem desconto disponível');
						inputProdutoPrecoTotalDesconto.val('Sem desconto disponível');
						inputProdutoPrecoDesconto.val('Sem desconto disponível');
					}
				})
				.fail(function() {
				})
				.always(function() {
					btnPedidoCadastrarProduto.prop( "disabled", false );
				});
			}
		}, doneTypingInterval);
	});

	inputProdutoQuantidade.on('keydown', function () {
		console.log("Log: Geo Localização - inputProdutoQuantidade (keydown)");
		clearTimeout(typingTimer);
	});
}

if(selectProdutoPorcentagemDesconto.length > 0) {
	selectProdutoPorcentagemDesconto.on('change', function(event) {
		console.log("Log: Geo Localização - selectProdutoPorcentagemDesconto");

		event.preventDefault();
		
		var valDesc 			= $(this).find(':selected').val();
		var valTotal 			= inputProdutoPrecoTotal.val();

		valTotal = parseFloat(valTotal.replace('R$ ', '').replace('.', '').replace(',', '.'));
		var disc = parseFloat(valDesc / 100) * parseFloat(valTotal) ;

		valTotalDesc = ( valTotal - disc );

		inputProdutoPrecoDesconto.val('').val(numberToReal(disc));
		inputProdutoPrecoTotalDesconto.val('').val(numberToReal(valTotalDesc));
	});
}

if(btnPedidoCadastrarProduto.length > 0) {
	btnPedidoCadastrarProduto.on('click', function(event) {
		console.log("Log: Geo Localização - btnPedidoCadastrarProduto");

		var numItems = $('.row-pedido-produtos-item').length;

		var obj = {
			id_tabela: 						selectPedidoTabelasPreco.find(':selected').val(),
			desc_tabela: 					selectPedidoTabelasPreco.find(':selected').html(),
			id_grupo: 						selectPedidoGrupos.find(':selected').val(),
			desc_grupo: 					selectPedidoGrupos.find(':selected').html(),
			id_produto: 					selectPedidoProdutos.find(':selected').val(),
			desc_produto: 				selectPedidoProdutos.find(':selected').html(),
			id_setor_estoque: 		selectPedidoSetorEstoque.find(':selected').val(),
			desc_setor_estoque: 	selectPedidoSetorEstoque.find(':selected').html(),
			estoque_atual: 				inputProdutoEstoqueAtual.val(),
			quantidade: 					inputProdutoQuantidade.val(),
			preco_unitario: 			inputProdutoPrecoUnitario.val(),
			preco_total: 					inputProdutoPrecoTotal.val(),
			desc_porcentam: 			selectProdutoPorcentagemDesconto.find(':selected').val(),
			desc_preco_total: 		inputProdutoPrecoTotalDesconto.val(),
			desc_preco: 					inputProdutoPrecoDesconto.val(),
			total_items:					numItems
		};

		var json = JSON.stringify( obj );

		$.ajax({
			type: 		'POST',
			dataType: "json",
			url: 			BASE_URL + CLASSE + "/ajaxPedidosInsItem",
			data: { 
				csrf_token: CSRF_TOKEN, 
				json: json
			}
		})
		.done(function( result ) {
			iboxPedidoProdutos.prepend( result );
			getValorTotalPedido();
		})
		.fail(function() {
		})
		.always(function() {
		});
	});
}

if(selectPedidoEndereco.length > 0) {
	selectPedidoEndereco.on('change', function(event) {
		console.log("Log: Geo Localização - selectPedidoEndereco");

		event.preventDefault();
		
		var dados				= $(this).find(':selected').data('dados');
		var logradouro	= $(this).find(':selected').data('logradouro');
		var cep 				= $(this).find(':selected').data('cep');
		var numero 			= $(this).find(':selected').data('numero');
		var bairro 			= $(this).find(':selected').data('bairro');
		var cidade 			= $(this).find(':selected').data('cidade');
		var estado 			= $(this).find(':selected').data('estado');
		var complemento = $(this).find(':selected').data('complemento');

		inputHiddenEndereco.val( JSON.stringify(dados) );

		$('.pedido-endereco-logradouro').html('').html( logradouro );
		$('.pedido-endereco-cep').html('').html( cep );
		$('.pedido-endereco-numero').html('').html( numero );
		$('.pedido-endereco-bairro').html('').html( bairro );
		$('.pedido-endereco-cidade').html('').html( cidade );
		$('.pedido-endereco-estado').html('').html( estado );
		$('.pedido-endereco-complemento').html('').html( complemento );
	});
}

if(navigator.geolocation) {
	console.log("Log: Geo Localização - Navegador com suporte a Geo Localização.");

	/*
	* Cadastrar
	*/

	if(MODULO == "cadastro-de-pedidos" && METODO == "cadastrar" && API1_STATUS_CMS == 1 && API1_STATUS_CON == 1) {
		btnFooter.prop("disabled", true);

		console.log("Log: Geo Localização - Cadastrando um pedido.");

		btnPedidoLocalizacaoPermissao.html('').html('<i class="fa-duotone fa-spinner-third fa-spin-pulse"></i> Carregando...');

		navigator.permissions.query({ name: "geolocation" }).then((result) => {
			if (result.state === "granted") {
				console.log("Log: Geo Localização - Status = granted");
				getGeoPosition('release', '');
			} 
			else if (result.state === "prompt") {
				console.log("Log: Geo Localização - Status = prompt");
				getGeoPosition('release', '');
			} 
			else if (result.state === "denied") {
				console.log("Log: Geo Localização - Status = denied");

				spanPedidosLatitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
				spanPedidosLongitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
				spanPedidosPrecisao.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
				spanPedidosEndereco.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');

				btnPedidoLocalizacaoPermissao.hide();
				btnPedidoLocalizacaoBloqueado.show();
			}
		});

		btnPedidoLocalizacaoPermissao.on('click', function(event) {
			event.preventDefault();

			console.log("Log: Geo Localização - Cadastrando um pedido.");

			$(this).html('').html('<i class="fa-duotone fa-spinner-third fa-spin-pulse"></i> Carregando...');

			navigator.permissions.query({ name: "geolocation" }).then((result) => {
				if (result.state === "granted") {
					console.log("Log: Geo Localização - Status = granted");
					getGeoPosition('release', '');
				} 
				else if (result.state === "prompt") {
					console.log("Log: Geo Localização - Status = prompt");
					getGeoPosition('release', '');
				} 
				else if (result.state === "denied") {
					console.log("Log: Geo Localização - Status = denied");

					spanPedidosLatitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
					spanPedidosLongitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
					spanPedidosPrecisao.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
					spanPedidosEndereco.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');

					btnPedidoLocalizacaoPermissao.hide();
					btnPedidoLocalizacaoBloqueado.show();
				}
			});
		});

		btnFooter.on('click', function(event) {
			event.preventDefault();

			btnPedidoLocalizacaoPermissao.show();
			btnPedidoLocalizacaoEnviar.hide();
			btnPedidoLocalizacaoPermitida.hide();
			btnPedidoLocalizacaoBloqueado.hide();
			btnPedidoLocalizacaoPermissao.hide();

			btnPedidoLocalizacaoPermissao.html('').html('<i class="fa-duotone fa-spinner-third fa-spin-pulse"></i> Carregando...');

			navigator.permissions.query({ name: "geolocation" }).then((result) => {
				if (result.state === "granted") {
					console.log("Log: Geo Localização - Status = granted");
					getGeoPosition('record', '');
				} 
				else if (result.state === "prompt") {
					console.log("Log: Geo Localização - Status = prompt");
					getGeoPosition('record', '');
				} 
				else if (result.state === "denied") {
					console.log("Log: Geo Localização - Status = denied");

					spanPedidosLatitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
					spanPedidosLongitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
					spanPedidosPrecisao.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
					spanPedidosEndereco.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');

					btnPedidoLocalizacaoPermissao.hide();
					btnPedidoLocalizacaoBloqueado.show();

					$('#spiner').hide();
				}
			});
		});
	}

	/*
	* Alterar
	*/

	if(MODULO == "cadastro-de-pedidos" && METODO == "alterar" && API1_STATUS_CMS == 1 && API1_STATUS_CON == 1) {
		btnFooter.prop("disabled", true);

		console.log("Log: Geo Localização - Alterando um pedido.");

		btnPedidoLocalizacaoPermissao.html('').html('<i class="fa-duotone fa-spinner-third fa-spin-pulse"></i> Carregando...');

		navigator.permissions.query({ name: "geolocation" }).then((result) => {
			if (result.state === "granted") {
				console.log("Log: Geo Localização - Status = granted");
				getGeoPosition('release-change');
			} 
			else if (result.state === "prompt") {
				console.log("Log: Geo Localização - Status = prompt");
				getGeoPosition('release-change');
			} 
			else if (result.state === "denied") {
				console.log("Log: Geo Localização - Status = denied");

				spanPedidosLatitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
				spanPedidosLongitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
				spanPedidosPrecisao.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
				spanPedidosEndereco.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');

				btnPedidoLocalizacaoPermissao.hide();
				btnPedidoLocalizacaoBloqueado.show();
			}
		});

		btnPedidoLocalizacaoPermissao.on('click', function(event) {
			event.preventDefault();

			console.log("Log: Geo Localização - Alterando um pedido.");

			$(this).html('').html('<i class="fa-duotone fa-spinner-third fa-spin-pulse"></i> Carregando...');

			navigator.permissions.query({ name: "geolocation" }).then((result) => {
				if (result.state === "granted") {
					console.log("Log: Geo Localização - Status = granted");
					getGeoPosition('release-change');
				} 
				else if (result.state === "prompt") {
					console.log("Log: Geo Localização - Status = prompt");
					getGeoPosition('release-change');
				} 
				else if (result.state === "denied") {
					console.log("Log: Geo Localização - Status = denied");

					spanPedidosLatitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
					spanPedidosLongitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
					spanPedidosPrecisao.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
					spanPedidosEndereco.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');

					btnPedidoLocalizacaoPermissao.hide();
					btnPedidoLocalizacaoBloqueado.show();
				}
			});
		});

		btnFooter.on('click', function(event) {
			event.preventDefault();

			btnPedidoLocalizacaoPermissao.show();
			btnPedidoLocalizacaoEnviar.hide();
			btnPedidoLocalizacaoPermitida.hide();
			btnPedidoLocalizacaoBloqueado.hide();
			btnPedidoLocalizacaoPermissao.hide();

			btnPedidoLocalizacaoPermissao.html('').html('<i class="fa-duotone fa-spinner-third fa-spin-pulse"></i> Carregando...');

			navigator.permissions.query({ name: "geolocation" }).then((result) => {
				if (result.state === "granted") {
					console.log("Log: Geo Localização - Status = granted");
					getGeoPosition('change');
				} 
				else if (result.state === "prompt") {
					console.log("Log: Geo Localização - Status = prompt");
					getGeoPosition('change');
				} 
				else if (result.state === "denied") {
					console.log("Log: Geo Localização - Status = denied");

					spanPedidosLatitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
					spanPedidosLongitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
					spanPedidosPrecisao.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
					spanPedidosEndereco.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');

					btnPedidoLocalizacaoPermissao.hide();
					btnPedidoLocalizacaoBloqueado.show();

					$('#spiner').hide();
				}
			});
		});
	}
}
else {
	var swalHtml = "";
	swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
	swalHtml += '<h1>Acesso negado!</h1>';
	swalHtml += '<p class="mb-0 text-lowercase">O navegador que está sendo utilizado, não possui suporte a Geo Localização.</p>';

	var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
	var swalCancelButtonText 	= ''
	var swalIsConfirmed 			= 0;
	var swalResult 						= '';

	sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);

	rowPedidoClientes.hide();
	rowPedidoGruposProdutos.hide();
	rowPedidoEstoqueQuantidadePreco.hide();
	rowPedidoEstoqueQuantidadeDesconto.hide();
	rowPedidoAcao.hide();
	rowPedidoProdutos.hide();
}

function funBtnAcoesPedidoEnviar(btn) {
	console.log("Log: Geo Localização - btnAcoesPedidoEnviar");

	var idPedido = btn.data('id');

	var btnActionsByOrderSuccess 	= $('.btn-actions-by-order-success-' + idPedido);
	var btnActionsByOrderPrompt 	= $('.btn-actions-by-order-prompt-' + idPedido);
	var btnActionsByOrderSyncing 	= $('.btn-actions-by-order-syncing-' + idPedido);
	var btnActionsByOrderGroup 		= $('.btn-actions-by-order-group-' + idPedido);

	var btnActionsByOrderSync 		= $('.btn-actions-by-order-sync-' + idPedido);
	var btnActionsByOrderEdit 		= $('.btn-actions-by-order-edit-' + idPedido);
	var btnActionsByOrderDelete 	= $('.btn-actions-by-order-delete-' + idPedido);

	var btnsActions = {
		'id': 			idPedido,
		'success': 	btnActionsByOrderSuccess,
		'prompt': 	btnActionsByOrderPrompt,
		'syncing': 	btnActionsByOrderSyncing,
		'group': 		btnActionsByOrderGroup,
		'sync': 		btnActionsByOrderSync,
		'edit': 		btnActionsByOrderEdit,
		'delete': 	btnActionsByOrderDelete
	};

	btnsActions.success.hide();
	btnsActions.group.hide();
	btnsActions.prompt.hide();
	btnsActions.syncing.show();

	btnsActions.sync.hide();
	btnsActions.edit.hide();
	btnsActions.delete.hide();

	getGeoPosition('synchronize', btnsActions);
	return false;
}

function getGeoPosition(action, btns) {
	console.log("Log: Geo Localização - Ação realizada na função getGeoPosition() -> " + action);

	if( action == "release" || action == "record" || action == "release-change" || action == "change" ) {
		spanPedidosLatitude.html('').html('<i class="fa-duotone fa-spinner-third fa-spin-pulse"></i> Carregando...');
		spanPedidosLongitude.html('').html('<i class="fa-duotone fa-spinner-third fa-spin-pulse"></i> Carregando...');
		spanPedidosPrecisao.html('').html('<i class="fa-duotone fa-spinner-third fa-spin-pulse"></i> Carregando...');
		spanPedidosEndereco.html('').html('<i class="fa-duotone fa-spinner-third fa-spin-pulse"></i> Carregando...');
	}

	const options = {
		enableHighAccuracy: true,
		timeout: 100000,
		maximumAge: 0
	};

	function onSuccess(position) {
		console.log("Log: Geo Localização - onSuccess()");

		var lt, lg, ac, ad;

		const crd = position.coords;

		lt = crd.latitude;
		lg = crd.longitude;
		ac = crd.accuracy;

		if( action == "release" || action == "record" || action == "release-change" || action == "change" ) {
			spanPedidosLatitude.html('').html( crd.latitude );
			spanPedidosLongitude.html('').html( crd.longitude );
			spanPedidosPrecisao.html('').html( crd.accuracy + ' metros');
		}

		if(crd.latitude != "" && crd.longitude != "") {
			geocoder = new google.maps.Geocoder();

			const latlng = {
				lat: parseFloat( crd.latitude ),
				lng: parseFloat( crd.longitude ),
			};

			const returnGeoAddress = geocoder.geocode({ 
				location: latlng 
			}).then(function(response) {
				if (response.results[0]) {
					var d  = new Date();
					var dt = (('0' + d.getDate()).slice(-2)) + '/' + (('0' + (d.getMonth()+1)).slice(-2)) + '/' + d.getFullYear() + ' ' + ('0' + d.getHours()).slice(-2) + ':' + ('0' + d.getMinutes()).slice(-2) + ":" + ('0' + d.getSeconds()).slice(-2);
					
					ad = response.results[0].formatted_address

					if( action == "release" || action == "record" || action == "release-change" || action == "change" ) {
						spanPedidosEndereco.html('').html( ad );
						btnPedidoLocalizacaoPermissao.html('').html('<i class="fa-light fa-location-dot"></i> Verificar localização');

						rowPedidoClientes.show();
						rowPedidoGruposProdutos.show();
						rowPedidoEstoqueQuantidadePreco.show();
						rowPedidoEstoqueQuantidadeDesconto.show();
						rowPedidoAcao.show();
						rowPedidoProdutos.show();

						btnPedidoLocalizacaoPermissao.hide();
						btnPedidoLocalizacaoPermitida.show();

						btnFooter.prop("disabled", false);
					}

					if( action == "release" ) {
						$('.input-hidden-localizacao-liberacao-lt').val( lt );
						$('.input-hidden-localizacao-liberacao-lg').val( lg );
						$('.input-hidden-localizacao-liberacao-ac').val( ac );
						$('.input-hidden-localizacao-liberacao-ad').val( ad );
						$('.input-hidden-localizacao-liberacao-dt').val( dt );

						var toastIcon			= '<i class="fa-light fa-check me-1"></i>';
						var toastTitle		= 'Tudo certo!';
						var toastMessage	= 'A função [Salvar] foi habilitada.';
						var toastType			= 'toast-success';
						var toastDelay		= 2500;
						var toastAutohide	= true;

						toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);
					}

					if( action == "record" ) {
						$('.input-hidden-localizacao-cadastro-lt').val( lt );
						$('.input-hidden-localizacao-cadastro-lg').val( lg );
						$('.input-hidden-localizacao-cadastro-ac').val( ac );
						$('.input-hidden-localizacao-cadastro-ad').val( ad );
						$('.input-hidden-localizacao-cadastro-dt').val( dt );

						form.submit();
					}

					if( action == "release-change" ) {
						$('.input-hidden-localizacao-liberacao-alteracao-lt').val( lt );
						$('.input-hidden-localizacao-liberacao-alteracao-lg').val( lg );
						$('.input-hidden-localizacao-liberacao-alteracao-ac').val( ac );
						$('.input-hidden-localizacao-liberacao-alteracao-ad').val( ad );
						$('.input-hidden-localizacao-liberacao-alteracao-dt').val( dt );

						var toastIcon			= '<i class="fa-light fa-check me-1"></i>';
						var toastTitle		= 'Tudo certo!';
						var toastMessage	= 'A função [Salvar] foi habilitada.';
						var toastType			= 'toast-success';
						var toastDelay		= 2500;
						var toastAutohide	= true;

						toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);
					}

					if( action == "change" ) {
						$('.input-hidden-localizacao-alteracao-lt').val( lt );
						$('.input-hidden-localizacao-alteracao-lg').val( lg );
						$('.input-hidden-localizacao-alteracao-ac').val( ac );
						$('.input-hidden-localizacao-alteracao-ad').val( ad );
						$('.input-hidden-localizacao-alteracao-dt').val( dt );

						form.submit();
					}

					if( action == "synchronize" ) {
						var jqXHR = $.ajax({
							type: 		'POST',
							dataType: "json",
							url: 			BASE_URL + CLASSE + "/ajaxPedidosGetDados",
							data: { 
								csrf_token: CSRF_TOKEN, 
								table: 			'cad_pedidos', 
								idPedido: 	btns.id,
								lt: lt,
								lg: lg,
								ac: ac,
								ad: ad
							}
						});

						jqXHR.done(function( result ) {
							console.log("Log: Geo Localização - A função ajaxPedidosGetDados() foi realizada.");

							if(!$.isNumeric(result)) {
								var swalHtml = "";
								swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
								swalHtml += '<h1>Ops!</h1>';
								swalHtml += '<p class="mb-0 text-lowercase">' + result + '</p>';

								var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
								var swalCancelButtonText 	= ''
								var swalIsConfirmed 			= 0;
								var swalResult 						= '';

								sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);

								btns.success.hide();
								btns.group.show();
								btns.prompt.show();
								btns.syncing.hide();
								
								btns.sync.show();
								btns.edit.show();
								btns.delete.show();

								$('#spiner').hide();
							}
							else {
								var d 				= new Date();
								var dateTime 	=  (('0' + d.getDate()).slice(-2)) + '/' + (('0' + (d.getMonth()+1)).slice(-2)) + '/' + d.getFullYear() + ' ' + ('0' + d.getHours()).slice(-2) + ':' + ('0' + d.getMinutes()).slice(-2) + ":" + ('0' + d.getSeconds()).slice(-2);

								var htmlListpedidosStatus = '';
								htmlListpedidosStatus += '<i class="fa-light fa-check me-1 text-primary"></i>';
								htmlListpedidosStatus += '<label class="form-check-label" for="thirdCheckbox">';
								htmlListpedidosStatus += '	4. Pedido sincronizado';
								htmlListpedidosStatus += '</label>';

								$('.border-pedidos-status-' + btns.id).removeClass('border-danger').addClass('border-navy');
								$('.list-pedidos-status-' + btns.id).html('').html(htmlListpedidosStatus);
								$('.span-pedidos-id-' + btns.id).html('').html(result);
								$('.span-pedidos-status-' + btns.id).html('').html('Pedido sincronizado');
								$('.span-pedidos-status-date-time-' + btns.id).html('').html(dateTime);

								btns.success.show();
								btns.group.show();
								btns.prompt.hide();
								btns.syncing.hide();
								
								btns.sync.hide();
								btns.edit.hide();
								btns.delete.hide();
							}
						});

						jqXHR.fail(function() {
							console.log("Log: Geo Localização - A função ajaxPedidosGetDados() gerou um ou mais erros.");

							var swalHtml = "";
							swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
							swalHtml += '<h1>Ops!</h1>';
							swalHtml += '<p class="mb-0 text-lowercase">Houve um erro na sincronização revise os dados e tente novamente.</p>';

							var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
							var swalCancelButtonText 	= ''
							var swalIsConfirmed 			= 0;
							var swalResult 						= '';

							sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);

							btns.success.hide();
							btns.group.hide();
							btns.prompt.show();
							btns.syncing.hide();
							
							btns.sync.hide();
							btns.edit.hide();
							btns.delete.hide();

							btn.html('').html('<i class="fa-light fa-rotate"></i> Sincronizar pedido');
							btn.prop('disabled', false);
						})

						jqXHR.always(function() {
							$('#spiner').hide();
							console.log("Log: Geo Localização - A função ajaxPedidosGetDados() foi finalizada.");
						});
					}
				} 
				else {
					return 0;
				}
			}).catch((e) => {
			});
		}
	}

	function onError(error) {
		console.log("Log: Geo Localização - onError()");

		switch (error.code) {
		case error.PERMISSION_DENIED:
			console.log("Log: Geo Localização - Não foi data a permissão para capturar os dados da sua localização.");

			spanPedidosLatitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
			spanPedidosLongitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
			spanPedidosPrecisao.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');
			spanPedidosEndereco.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Permissões negadas');

			btnPedidoLocalizacaoPermissao.hide();
			btnPedidoLocalizacaoBloqueado.show();

			var swalHtml = "";
			swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
			swalHtml += '<h1>Acesso negado!</h1>';
			swalHtml += '<p class="mb-0 text-lowercase">Não foi dada a permissão para capturar os dados da sua localização.</p>';

			var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
			var swalCancelButtonText 	= ''
			var swalIsConfirmed 			= 0;
			var swalResult 						= '';

			sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
			break;

		case error.POSITION_UNAVAILABLE:
			console.log("Log: Geo Localização - Sua posição é incerta, tente novamente.");

			spanPedidosLatitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Localização incerta');
			spanPedidosLongitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Localização incerta');
			spanPedidosPrecisao.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Localização incerta');
			spanPedidosEndereco.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Localização incerta');

			btnPedidoLocalizacaoPermissao.hide();
			btnPedidoLocalizacaoBloqueado.show();

			var swalHtml = "";
			swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
			swalHtml += '<h1>Ops!</h1>';
			swalHtml += '<p class="mb-0 text-lowercase">Não foi possível obter os dados de sua localização, tente novamente.</p>';

			var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
			var swalCancelButtonText 	= ''
			var swalIsConfirmed 			= 0;
			var swalResult 						= '';

			sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
			break;

		case error.TIMEOUT:
			console.log("Log: Geo Localização - Tempo de requisição expirado.");

			spanPedidosLatitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Tente novamente');
			spanPedidosLongitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Tente novamente');
			spanPedidosPrecisao.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Tente novamente');
			spanPedidosEndereco.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Tente novamente');

			btnPedidoLocalizacaoPermissao.hide();
			btnPedidoLocalizacaoBloqueado.show();

			var swalHtml = "";
			swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
			swalHtml += '<h1>Ops!</h1>';
			swalHtml += '<p class="mb-0 text-lowercase">Não foi possível obter os dados de sua localização, tente novamente.</p>';

			var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
			var swalCancelButtonText 	= ''
			var swalIsConfirmed 			= 0;
			var swalResult 						= '';

			sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
			break;

		case error.UNKNOWN_ERROR:
			console.log("Log: Geo Localização - Erro desconhecido.");

			spanPedidosLatitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Erro desconhecido');
			spanPedidosLongitude.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Erro desconhecido');
			spanPedidosPrecisao.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Erro desconhecido');
			spanPedidosEndereco.addClass('text-danger').html('').html('<i class="fa-light fa-x"></i> Erro desconhecido');

			btnPedidoLocalizacaoPermissao.hide();
			btnPedidoLocalizacaoBloqueado.show();

			var swalHtml = "";
			swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
			swalHtml += '<h1>Ops!</h1>';
			swalHtml += '<p class="mb-0 text-lowercase">Um erro desconhecido foi gerado, tente novamente.</p>';

			var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
			var swalCancelButtonText 	= ''
			var swalIsConfirmed 			= 0;
			var swalResult 						= '';

			sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
			break;
		}
	}

	navigator.geolocation.getCurrentPosition(onSuccess, onError, options);
}

function ajaxSaveGeoLocation(lt, lg, ac, ad) {
	$.ajax({
		type: 		'POST',
		dataType: "json",
		url: 			BASE_URL + CLASSE + "/ajaxPedidoGeoLocation",
		data: { 
			csrf_token: CSRF_TOKEN,
			latitude: 	lt,
			longitude: 	lg,
			precisao: 	ac,
			endereco: 	ad
		}
	})
	.done(function( result ) {
	})
	.fail(function() {
	})
	.always(function() {
	});
}

function getValorTotalPedido() {
	var total = 0;
	$('.item-info-valor').each(function() {
		var valor = parseFloat($(this).val().replace('R$ ', '').replace('.', '').replace(',', '.'));
		total += valor;
	});

	inputHiddenValorTotalGeral.val(total);
	$('.pedido-produtos-resumo-total').html('').html(numberToReal(total));
}

function btnInfoAcoesRemover(id) {
	$(".hr-item-" + id).remove();
	$(".item-" + id).remove();

	var toastIcon			= '<i class="fa-light fa-check me-1"></i>';
	var toastTitle		= 'Tudo certo!';
	var toastMessage	= 'O item [' + $('.id-desc-item-' + id).html()  + '] foi removido do pedido.';
	var toastType			= 'toast-success';
	var toastDelay		= 99999;
	var toastAutohide	= false;

	toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);
	getValorTotalPedido();
}

// ---------------------------------------------------------------------------------------------]
// --------------------------------------------------------------------------[ GRAFICOS - API 1 ]
// ---------------------------------------------------------------------------------------------]

/*
* Graph 1
* Mostra os pedidos cadastrados por mês de acordo com o ano informado.
*/

if($("#chartAmountPerMonth").length > 0) {
	console.log("Log: chartAmountPerMonth encontrado e iniciado.");

	var chartAmountPerMonthData = {
		labels: API1_CHART_MONTHS,
		datasets: [{
			label: 								"Pedidos",
			backgroundColor: 			"rgba(26,179,148,0.5)",
			borderColor: 					"rgba(26,179,148,0.7)",
			pointBackgroundColor: "rgba(26,179,148,1)",
			pointBorderColor: 		"#fff",
			data: API1_CHART_AMOUNT
		}]
	};

	var chartAmountPerMonthOptions = {
		responsive: true
	};

	var ctx = $("#chartAmountPerMonth");
	var chartAmountPerMonth = new Chart(ctx, {type: 'line', data: chartAmountPerMonthData, options:chartAmountPerMonthOptions});

	var chartAmountPerMonthButton = $('.btn-graph-update');

	if(chartAmountPerMonthButton.length > 0) {
		chartAmountPerMonthButton.on('click', function(event) {
			event.preventDefault();

			var filterStatus = $(this).data('filter-status');
			var filterClass  = $(this).data('filter-class');

			if(filterStatus == 1) {
				var filterInputs = new Array();
				var obj 				 = {};

				$( '.' + filterClass ).each(function(index, e) {
					if($(this).val() != "") {
						obj[$(this).attr("name")] = $(this).val();
					}
				});

				filterInputs = obj;
			}
			else {
				filterInputs = null;
			}

			var table		= "cad_pedidos";
			var id			= ID_USUARIO;
			var column	= "id_usuario";

			var jqXHR = $.ajax({
				type: 		'POST',
				dataType: "json",
				url: 			BASE_URL + "/API_getAPI1ChartAmountPerMonth",
				data: { 
					csrf_token: 	CSRF_TOKEN,
					table: 				table,
					id: 					id,
					column: 			column,
					filterInputs: filterInputs
				}
			});

			jqXHR.done(function( result ) {
				chartAmountPerMonth.data.labels = result.months;
				chartAmountPerMonth.data.datasets[0].data = result.amount;
				chartAmountPerMonth.update();

				$.each(result.months, function(index, val) {
					$('.month-list-' + val.toLowerCase()).html('').html(numberToReal(result.total[index]));
					$('.month-list-amount-' + val.toLowerCase()).html('').html(result.amount[index] + ' pedidos');
				});
			});

			jqXHR.fail(function() {
			});

			jqXHR.always(function() {
			});
		});
	}
}

/*
* Graph 2
* Mostra a quantidade total de pedidos sincronizados com o XKEY e os não sincronizados.
*/

if($('#chartInvoiceSync').length > 0) {
	console.log("Log: chartInvoiceSync encontrado e iniciado.");

	var chartInvoiceSyncData = {
		labels: ['Pedidos'],
		datasets: [{
			label: 								"Sincronizados",
			backgroundColor: 			'#00a95099',
			data: 								API1_CHART_INVOICE_SINC
		}, {
			label: 								"Não sincronizados",
			backgroundColor: 			"#f5379499",
			data: 								API1_CHART_INVOICE_NOTSINC
		}]
	};

	var chartInvoiceSyncConfig = {
		type: 'bar',
		data: chartInvoiceSyncData,
		options: {
			maintainAspectRatio: false,
			aspectRatio: 1,
			responsive: true,
			indexAxis: 'y',
			scales: {
				x: {
					stacked: true
				},
				y: {
					stacked: true,
					ticks: {
						callback: function(value) {
							return API1_CHART_INVOICE_PERCENT + '% sincronizados';
						}	
					}
				}
			},
			plugins: {
				legend: {
					display: false,
				},
				title: {
					display: true,
					text: 'Pedidos'
				},
				tooltip: {
					callbacks: {
						title: function(context) {
							return context[0].label;
						}
					}
				}
			}
		}
	};

	var chartInvoiceSync = new Chart($('#chartInvoiceSync'), chartInvoiceSyncConfig);

	chartInvoiceSync.canvas.parentNode.style.height = '150px';
}

/*
* Graph 3
* Mostra a quantidade total de pedidos realizados por vendedor.
*/

if($('#chartInvoiceBySeller').length) {
	var colors = [];

	$.each(API1_CHART_INVBYSELLER_SELLERS, function(index, val) {
		colors.push(COLORS[index]);
	});

	var chartInvoiceBySellerData = {
		labels: API1_CHART_INVBYSELLER_SELLERS,
		datasets: [{
			label: 								"Pedidos",
			backgroundColor: 			colors,
			pointBorderColor: 		"#fff",
			data: 								API1_CHART_INVBYSELLER_AMOUNT
		}]
	};

	var chartInvoiceBySellerOptions = {
		type: 'bar',
		data: chartInvoiceBySellerData,
		options: {
			indexAxis: 'x',
			scales: {
				y: {
					beginAtZero: true
				},
				x: {
					ticks: {
						callback: function(value) {
							const maxLength = 10;
							var lab = this.getLabelForValue(value);
							return lab.length > maxLength ? lab.substring(0, maxLength) + '...' : lab;
						}	
					}
				}
			},
			plugins: {
				legend: {
					display: false,
				},
				title: {
					display: false,
					text: ''
				},
				tooltip: {
					callbacks: {
						title: function(context) {
							return context[0].label;
						}
					}
				}
			}
		}
	};

	var chartInvoiceBySeller = new Chart($('#chartInvoiceBySeller'), chartInvoiceBySellerOptions);
}

var chartInvoiceBySellerButton = $('.btn-graph-update-invoices-by-seller');

if(chartInvoiceBySellerButton.length > 0) {
	chartInvoiceBySellerButton.on('click', function(event) {
		event.preventDefault();

		var filterStatus = $(this).data('filter-status');
		var filterClass  = $(this).data('filter-class');

		if(filterStatus == 1) {
			var filterInputs = new Array();
			var obj 				 = {};

			$( '.' + filterClass ).each(function(index, e) {
				if($(this).val() != "") {
					obj[$(this).attr("name")] = $(this).val();
				}
			});

			filterInputs = obj;
		}
		else {
			filterInputs = null;
		}

		var table		= "cad_pedidos";
		var id			= ID_USUARIO;
		var column	= "id_usuario";

		var jqXHR = $.ajax({
			type: 		'POST',
			dataType: "json",
			url: 			BASE_URL + "/API_getAPI1ChartInvoiceBySeller",
			data: { 
				csrf_token: 	CSRF_TOKEN,
				table: 				table,
				id: 					id,
				column: 			column,
				filterInputs: filterInputs
			}
		});

		jqXHR.done(function( result ) {
			chartInvoiceBySeller.data.labels = result.sellers;
			chartInvoiceBySeller.data.datasets[0].data = result.amount;

			$('.span-invoice-by-seller-date-start').html('').html(result.dateStart)
			$('.span-invoice-by-seller-date-end').html('').html(result.dateEnd)

			chartInvoiceBySeller.update();

			$.each(result.sellers, function(index, val) {
				$('.seller-list-' + result.ids[index]).html('').html(numberToReal(result.total[index]));
				$('.seller-list-amount-' + result.ids[index]).html('').html(result.amount[index] + ' pedidos');
			});
		});

		jqXHR.fail(function() {
		});

		jqXHR.always(function() {
		});
	});
}

/*
* Graph 4
* Mostra a quantidade total de pedidos realizados por cliente.
*/

if($('#chartInvoiceByClient').length) {
	var colors = [];
	$.each(API1_CHART_INVBYCLIENT_CLIENTS, function(index, val) {
		colors.push(COLORS[index]);
	});

	var chartInvoiceByClientData = {
		labels: API1_CHART_INVBYCLIENT_CLIENTS,
		datasets: [{
			label: 								"Pedidos",
			backgroundColor: 			colors,
			pointBorderColor: 		"#fff",
			data: 								API1_CHART_INVBYCLIENT_QUANTITY
		}]
	};

	var chartInvoiceByClientOptions = {
		type: 'bar',
		data: chartInvoiceByClientData,
		options: {
			indexAxis: 'x',
			scales: {
				y: {
					beginAtZero: true
				},
				x: {
					ticks: {
						callback: function(value) {
							const maxLength = 10;
							var lab = this.getLabelForValue(value);
							return lab.length > maxLength ? lab.substring(0, maxLength) + '...' : lab;
						}	
					}
				}
			},
			plugins: {
				legend: {
					display: false,
				},
				title: {
					display: false,
					text: ''
				},
				tooltip: {
					callbacks: {
						title: function(context) {
							return context[0].label;
						}
					}
				}
			}
		}
	};

	var chartInvoiceByClient = new Chart($('#chartInvoiceByClient'), chartInvoiceByClientOptions);
}

var chartInvoiceByClientButton = $('.btn-graph-update-invoices-by-client');

if(chartInvoiceByClientButton.length > 0) {
	chartInvoiceByClientButton.on('click', function(event) {
		event.preventDefault();

		var filterStatus = $(this).data('filter-status');
		var filterClass  = $(this).data('filter-class');

		if(filterStatus == 1) {
			var filterInputs = new Array();
			var obj 				 = {};

			$( '.' + filterClass ).each(function(index, e) {
				if($(this).val() != "") {
					obj[$(this).attr("name")] = $(this).val();
				}
			});

			filterInputs = obj;
		}
		else {
			filterInputs = null;
		}

		var table		= "cad_pedidos";
		var id			= ID_USUARIO;
		var column	= "id_usuario";

		var jqXHR = $.ajax({
			type: 		'POST',
			dataType: "json",
			url: 			BASE_URL + "/API_getAPI1ChartInvoiceByClient",
			data: { 
				csrf_token: 	CSRF_TOKEN,
				table: 				table,
				id: 					id,
				column: 			column,
				filterInputs: filterInputs
			}
		});

		jqXHR.done(function( result ) {
			chartInvoiceByClient.data.labels = result.clients;
			chartInvoiceByClient.data.datasets[0].data = result.quantity;

			$('.span-invoice-by-client-date-start').html('').html(result.dateStart)
			$('.span-invoice-by-client-date-end').html('').html(result.dateEnd)

			chartInvoiceByClient.update();

			$.each(result.clients, function(index, val) {
				$('.client-list-' + result.ids[index]).html('').html(numberToReal(result.total[index]));
				$('.client-list-quantity-' + result.ids[index]).html('').html(result.quantity[index] + ' pedidos');
			});
		});

		jqXHR.fail(function() {
		});

		jqXHR.always(function() {
		});
	});
}

// ---------------------------------------------------------------------------------------------]
// ----------------------------------------------------------------------------[ API 3 - Twitch ]
// ---------------------------------------------------------------------------------------------]

/*
* Subs
*/

var btnTwitchGetSubscriptions = $('.btn-twitch-get-subscriptions');
var twitchSavedSubscriptions = []; 

if(btnTwitchGetSubscriptions.length > 0) {
	btnTwitchGetSubscriptions.on('click', function(event) {
		event.preventDefault();
		
		var swalHtml = "";
		swalHtml += '<i class="fal fa-question-circle text-danger text-12 mb-3"></i><br/>';
		swalHtml += '<h1>Confirmar importação?</h1>';
		swalHtml += '<p class="mb-0 text-lowercase">Deseja importar os cadastros da Twitch?</p>';

		Swal.fire({ 
			title:              '',
			html:               swalHtml,
			confirmButtonText:  'Sim, desejo importar',
			cancelButtonText:   'Não, cancelar ação',
			allowOutsideClick:  true,
			allowEscapeKey:     true,
			showCancelButton: 	true,
			customClass: {
				popup: 		'w-100',
				actions: 	'p-2 pt-3 m-0',
			},
			showClass: {
				popup: 'animated bounceInUp faster'
			},
			hideClass: {
				popup: 'animated bounceOutDown faster'
			},
			position: 'bottom'
		})
		.then((result) => { 
			if (result.isConfirmed) {
				$('#spiner').show();
				twitchGetSubscriptions('');
			}
		});
	});
}

function twitchGetSubscriptions(pagination) {
	var view_reload	= '';
	var modulo_api	= 'getSubscriptions';
	var indice			= '';
	var requisicao	= 'get';
	var dir_view		= '';
	var row					= '';
	var unset				= '';
	var api_id			= '3';
	var retorno			= 'array';

	var jqXHR = $.ajax({
		type: 					'POST',
		dataType: 			'json',
		url: BASE_URL + '/API_curlStruct',
		data: {
			csrf_token: 		CSRF_TOKEN,
			view_reload: 		view_reload,
			modulo_api: 		modulo_api,
			indice: 				indice,
			requisicao: 		requisicao,
			dir_view: 			dir_view,
			row: 						row,
			unset: 					unset,
			api_id: 				api_id,
			retorno: 				retorno,
			pagination: 		pagination
		}
	});

	jqXHR.done(function(result) {
		twitchSavedSubscriptions = twitchSavedSubscriptions.concat(result.registros.data);

		if (result.registros.pagination.cursor) {
			setTimeout(function() {
				console.log("Log: Função twitchGetFollowers() executada.")
				twitchGetSubscriptions(result.registros.pagination.cursor);
			}, 10000); 
		} 
		else {
			location.reload();
		}
	});

	jqXHR.fail(function(jqXHR, textStatus, errorThrown) {
	});

	jqXHR.always(function() {
	});
}

/*
* Goals
*/

var btnTwitchGetGoals = $('.btn-twitch-get-goals');

if(btnTwitchGetGoals.length > 0) {
	btnTwitchGetGoals.on('click', function(event) {
		event.preventDefault();

		var swalHtml = "";
		swalHtml += '<i class="fal fa-question-circle text-danger text-12 mb-3"></i><br/>';
		swalHtml += '<h1>Confirmar importação?</h1>';
		swalHtml += '<p class="mb-0 text-lowercase">Deseja importar os cadastros da Twitch?</p>';

		Swal.fire({ 
			title:              '',
			html:               swalHtml,
			confirmButtonText:  'Sim, desejo importar',
			cancelButtonText:   'Não, cancelar ação',
			allowOutsideClick:  true,
			allowEscapeKey:     true,
			showCancelButton: 	true,
			customClass: {
				popup: 		'w-100',
				actions: 	'p-2 pt-3 m-0',
			},
			showClass: {
				popup: 'animated bounceInUp faster'
			},
			hideClass: {
				popup: 'animated bounceOutDown faster'
			},
			position: 'bottom'
		})
		.then((result) => { 
			if (result.isConfirmed) {
				$('#spiner').show();

				var view_reload	= '';
				var modulo_api	= 'getGoals';
				var indice			= 'data';
				var requisicao	= 'get';
				var dir_view		= '';
				var row					= '';
				var unset				= '';
				var api_id			= '3';
				var retorno			= 'array';

				var jqXHR = $.ajax({
					type: 					'POST',
					dataType: 			'json',
					url: BASE_URL + '/API_curlStruct',
					data: {
						csrf_token: 		CSRF_TOKEN,
						view_reload: 		view_reload,
						modulo_api: 		modulo_api,
						indice: 				indice,
						requisicao: 		requisicao,
						dir_view: 			dir_view,
						row: 						row,
						unset: 					unset,
						api_id: 				api_id,
						retorno: 				retorno
					}
				});

				jqXHR.done(function(result) {
					location.reload();
				});

				jqXHR.fail(function(jqXHR, textStatus, errorThrown) {
				});

				jqXHR.always(function() {
				});
			}
		});
	});
}

/*
* Followers
*/

var btnTwitchGetFollowers = $('.btn-twitch-get-followers');
var twitchSavedFollowers = []; 

if(btnTwitchGetFollowers.length > 0) {
	btnTwitchGetFollowers.on('click', function(event) {
		event.preventDefault();
		
		var swalHtml = "";
		swalHtml += '<i class="fal fa-question-circle text-danger text-12 mb-3"></i><br/>';
		swalHtml += '<h1>Confirmar importação?</h1>';
		swalHtml += '<p class="mb-0 text-lowercase">Deseja importar os cadastros da Twitch?</p>';

		Swal.fire({ 
			title:              '',
			html:               swalHtml,
			confirmButtonText:  'Sim, desejo importar',
			cancelButtonText:   'Não, cancelar ação',
			allowOutsideClick:  true,
			allowEscapeKey:     true,
			showCancelButton: 	true,
			customClass: {
				popup: 		'w-100',
				actions: 	'p-2 pt-3 m-0',
			},
			showClass: {
				popup: 'animated bounceInUp faster'
			},
			hideClass: {
				popup: 'animated bounceOutDown faster'
			},
			position: 'bottom'
		})
		.then((result) => { 
			if (result.isConfirmed) {
				$('#spiner').show();
				twitchGetFollowers('');
			}
		});
	});
}

function twitchGetFollowers(pagination) {
	var view_reload	= '';
	var modulo_api	= 'getFollowers';
	var indice			= '';
	var requisicao	= 'get';
	var dir_view		= '';
	var row					= '';
	var unset				= '';
	var api_id			= '3';
	var retorno			= 'array';

	var jqXHR = $.ajax({
		type: 					'POST',
		dataType: 			'json',
		url: BASE_URL + '/API_curlStruct',
		data: {
			csrf_token: 		CSRF_TOKEN,
			view_reload: 		view_reload,
			modulo_api: 		modulo_api,
			indice: 				indice,
			requisicao: 		requisicao,
			dir_view: 			dir_view,
			row: 						row,
			unset: 					unset,
			api_id: 				api_id,
			retorno: 				retorno,
			pagination: 		pagination
		}
	});

	jqXHR.done(function(result) {
		twitchSavedFollowers = twitchSavedFollowers.concat(result.registros.data);

		if (result.registros.pagination.cursor) {
			setTimeout(function() {
				console.log("Log: Função twitchGetFollowers() executada.")
				twitchGetFollowers(result.registros.pagination.cursor);
			}, 10000); 
		} 
		else {
			location.reload();
		}
	});

	jqXHR.fail(function(jqXHR, textStatus, errorThrown) {
	});

	jqXHR.always(function() {
	});
}

/*
* Bits
*/

var btnTwitchGetBits = $('.btn-twitch-get-bits');

if(btnTwitchGetBits.length > 0) {
	btnTwitchGetBits.on('click', function(event) {
		event.preventDefault();

		var swalHtml = "";
		swalHtml += '<i class="fal fa-question-circle text-danger text-12 mb-3"></i><br/>';
		swalHtml += '<h1>Confirmar importação?</h1>';
		swalHtml += '<p class="mb-0 text-lowercase">Deseja importar os cadastros da Twitch?</p>';

		Swal.fire({ 
			title:              '',
			html:               swalHtml,
			confirmButtonText:  'Sim, desejo importar',
			cancelButtonText:   'Não, cancelar ação',
			allowOutsideClick:  true,
			allowEscapeKey:     true,
			showCancelButton: 	true,
			customClass: {
				popup: 		'w-100',
				actions: 	'p-2 pt-3 m-0',
			},
			showClass: {
				popup: 'animated bounceInUp faster'
			},
			hideClass: {
				popup: 'animated bounceOutDown faster'
			},
			position: 'bottom'
		})
		.then((result) => { 
			if (result.isConfirmed) {
				$('#spiner').show();
				
				var view_reload	= '';
				var modulo_api	= 'getBits';
				var indice			= 'data';
				var requisicao	= 'get';
				var dir_view		= '';
				var row					= '';
				var unset				= '';
				var api_id			= '3';
				var retorno			= 'array';

				var jqXHR = $.ajax({
					type: 					'POST',
					dataType: 			'json',
					url: BASE_URL + '/API_curlStruct',
					data: {
						csrf_token: 		CSRF_TOKEN,
						view_reload: 		view_reload,
						modulo_api: 		modulo_api,
						indice: 				indice,
						requisicao: 		requisicao,
						dir_view: 			dir_view,
						row: 						row,
						unset: 					unset,
						api_id: 				api_id,
						retorno: 				retorno
					}
				});

				jqXHR.done(function(result) {
					location.reload();
				});

				jqXHR.fail(function(jqXHR, textStatus, errorThrown) {
				});

				jqXHR.always(function() {
				});
			}
		});
	});
}

// ---------------------------------------------------------------------------------------------]
// ---------------------------------------------------------------------------[ API 4 - YouTube ]
// ---------------------------------------------------------------------------------------------]

var btnYouTubeGetVideos = $('.btn-youtube-get-videos');
var savedItems = []; 

if (btnYouTubeGetVideos.length > 0) {
	btnYouTubeGetVideos.on('click', function(event) {
		event.preventDefault();

		var swalHtml = "";
		swalHtml += '<i class="fal fa-question-circle text-danger text-12 mb-3"></i><br/>';
		swalHtml += '<h1>Confirmar importação?</h1>';
		swalHtml += '<p class="mb-0 text-lowercase">Deseja importar os cadastros da Twitch?</p>';

		Swal.fire({ 
			title:              '',
			html:               swalHtml,
			confirmButtonText:  'Sim, desejo importar',
			cancelButtonText:   'Não, cancelar ação',
			allowOutsideClick:  true,
			allowEscapeKey:     true,
			showCancelButton: 	true,
			customClass: {
				popup: 		'w-100',
				actions: 	'p-2 pt-3 m-0',
			},
			showClass: {
				popup: 'animated bounceInUp faster'
			},
			hideClass: {
				popup: 'animated bounceOutDown faster'
			},
			position: 'bottom'
		})
		.then((result) => { 
			if (result.isConfirmed) {
				$('#spiner').show();
				realizarChamadaAjax('');
			}
		});
	});
}

function realizarChamadaAjax(nextpagetoken) {
	var view_reload	= '';
	var modulo_api	= 'search';
	var indice			= 'items';
	var requisicao	= 'get';
	var dir_view		= '';
	var row					= '';
	var unset				= '';
	var api_id			= '4';
	var retorno			= 'array';

	var jqXHR = $.ajax({
		type: 					'POST',
		dataType: 			'json',
		url: BASE_URL + '/API_curlStruct',
		data: {
			csrf_token: 		CSRF_TOKEN,
			view_reload: 		view_reload,
			modulo_api: 		modulo_api,
			indice: 				indice,
			requisicao: 		requisicao,
			dir_view: 			dir_view,
			row: 						row,
			unset: 					unset,
			api_id: 				api_id,
			retorno: 				retorno,
			nextpagetoken: 	nextpagetoken
		}
	});

	jqXHR.done(function(result) {
		savedItems = savedItems.concat(result.registros);

		if (result.nextpagetoken) {
			realizarChamadaAjax(result.nextpagetoken);
		} 
		else {
			location.reload();
		}
	});

	jqXHR.fail(function(jqXHR, textStatus, errorThrown) {
	});

	jqXHR.always(function() {
	});
}

// ---------------------------------------------------------------------------------------------]
// ---------------------------------------------------------------------------------------[ END ]
// ---------------------------------------------------------------------------------------------]
