// Sumário
// ------ [ ALL ]
// ------ [ NOTIFICAÇÕES ]
// ------ [ MENU ]
// ------ [ WHATS APP ]
// ------ [ DATA TABLE ]
// ------ [ EMAIL ]
// ------ [ SUBMIT ]
// ------ [ SELECT ]
// ------ [ CAROUSEL ]
// ------ [ TOOLS ]
// ------ [ INPUTS ]
// ------ [ BUTTONS ]
// ------ [ OTHERS ]
// ------ [ WEBMAIL ]
// ------ [ 2FA ]
// ------ [ PAGINATION ]
// ------ [ END ]

// ---------------------------------------------------------------------------------------------]
// ---------------------------------------------------------------------------------------[ ALL ]
// ---------------------------------------------------------------------------------------------]

/*
* ALL ::: Loading
*/

$('.loading').click(function(e) {
	$('#spiner').show();
});

$(window).on('load', function() { 
	$('#spiner').hide();
});

/*
* ALL ::: Tooltips
*/

if($('[data-toggle="tooltip"]').length) {
	$('[data-toggle="tooltip"]').tooltip();
	console.log("Log: Tooltips carregado.");
}

/*
* ALL ::: Tocar som de alerta
*/

function playAlert() {
	var audio = new Audio(PUBLICURL + 'assets/cms/audio/alert.mp3');
	audio.play();
}

/*
* ALL ::: Download de multiplos arquivos
*/

$('.download-all-files').on('click', function(event) {
	event.preventDefault();

	var temporaryDownloadLink = document.createElement("a");
	temporaryDownloadLink.style.display = 'none';

	document.body.appendChild( temporaryDownloadLink );

	var i = 0;
	var interval = setInterval(() => {
		if(i < filesForDownload.length) {
			var download = filesForDownload[i];
			temporaryDownloadLink.setAttribute('href', download.path);
			temporaryDownloadLink.setAttribute('download', download.name);

			temporaryDownloadLink.click();
		}else {
			clearInterval(interval);
		}
		i += 1;
	}, 500);

	document.body.removeChild(temporaryDownloadLink);
});

/*
* ALL ::: Scroll to elemento
*/

function scrollToElement(selector, time, verticalOffset) {
	time 						= typeof(time) != 'undefined' ? time : 1000;
	verticalOffset 	= typeof(verticalOffset) != 'undefined' ? verticalOffset : 0;
	element 				= $(selector);
	offset 					= element.offset();
	offsetTop 			= offset.top + verticalOffset;

	$('#wrapper').animate({
		scrollTop: offsetTop
	}, time);
}

/*
* ALL ::: SlimScroll
*/

if($('.scroll_log_content').length) {
	$('.scroll_log_content').slimscroll({
		height: '350px'
	});
}

/*
* ALL ::: SlimScroll 
*/

var tableSlimScroll = $('.table-slim-scroll');

if(tableSlimScroll.length) {
	tableSlimScroll.slimscroll({
		height: '250px'
	});
}

/*
* ALL ::: Diff
*/

if($( '.ibox-content-diff' ).length) {
	$( '.ibox-content-diff' ).prettyTextDiff({
		originalContainer: '.diff-original',
		changedContainer: '.diff-changed',
		diffContainer: '.diff-result'
	});
}

// ---------------------------------------------------------------------------------------------]
// -------------------------------------------------------------------------------------[ FILES ]
// ---------------------------------------------------------------------------------------------]

/*
* FILES ::: Alterar nome do arquivo selecionado no input
*/

$('.arquivo-replace').on('change', function(event) {
	event.preventDefault();

	var files = event.target.files;
	var filenames = [];

	for (var i = 0; i < files.length; i++) {
		filenames.push(files[i].name);
	}

	$('#'+$(this).data('key')).html(filenames.join(', '));
});

// ---------------------------------------------------------------------------------------------]
// ------------------------------------------------------------------------------[ NOTIFICAÇÕES ]
// ---------------------------------------------------------------------------------------------]

/*
* NOTIFY ::: Notificação ( Toastr )
*/

function toastShow(icon, title, message, type, delay, hide) {
	var toastKey 				= Math.floor((Math.random() * 10000) + 1);
	var toastIcon  	  	= icon;
	var toastTitle 	  	= title;
	var toastMessage  	= message;
	var toastType 			= type;
	var toastDelay 			= delay;
	var toastAutohide 	= hide;

	var html = "";

	html += '<div class="toast ' + toastType + ' toast-key-' + toastKey + ' shadow" role="alert" aria-live="assertive" aria-atomic="true" data-bs-delay="' + toastDelay + '" data-bs-autohide="' + toastAutohide + '" data-key="' + toastKey + '">';
	html += '	<div class="toast-header">';
	html += 		toastIcon;
	html += '		<strong class="me-auto">';
	html += 			toastTitle;
	html += '		</strong>';
	html += '		<button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close">';
	html += '			<i class="fa-light fa-xmark"></i>';
	html += '		</button>';
	html += '	</div>';
	html += '	<div class="toast-body">';
	html += 		toastMessage;
	html += '	</div>';
	html += '</div>';

	$( '.toast-container' ).append( html );

	var toastCollection = $(".toast");

	toastCollection.each(function() {
		var toastItem = new bootstrap.Toast( $(this) ).show();

		$(this).on('hidden.bs.toast', function(event) {
			event.preventDefault();

			$('.toast-key-' + $(this).data('key')).remove();
		});
	});
}

/*
*  NOTIFY ::: Notificação ( Sweet Alert 2 )
*/

function sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult) {
	if(swalCancelButtonText != "") {
		swalShowCancelButton = true;
	}
	else {
		swalShowCancelButton = false;
	}

	Swal.fire({ 
		title: 							'',
		html: 							swalHtml,
		confirmButtonText:  swalConfirmButtonText,
		cancelButtonText:   swalCancelButtonText,
		allowOutsideClick:  false,
		allowEscapeKey:     false,
		showCancelButton: 	swalShowCancelButton,
		customClass: {
			popup: 		'w-100',
			actions: 	'p-2 pt-3 m-0',
		},
		showClass: {
			popup: 'animated bounceInUp faster'
		},
		hideClass: {
			popup: 'animated bounceOutDown faster'
		},
		position: 'bottom'
	})
	.then((result) => { 
		if(swalIsConfirmed == 1) {
			if(swalResult != "") {
				if (result.isConfirmed) { 
					eval(swalResult);
				} 
				else {
					console.log("Condição ainda não criada, código: #SWAL-0001");
				}
			}
			else {
				console.log("Condição ainda não criada, código: #SWAL-0002");
			} 
		}
		else {			
			if(swalResult != "") {
				eval(swalResult);
			}
			else {
				console.log("Condição ainda não criada, código: #SWAL-0003");
			}
		}
	});
}

// ---------------------------------------------------------------------------------------------]
// --------------------------------------------------------------------------------------[ MENU ]
// ---------------------------------------------------------------------------------------------]

/*
* MENU ::: Menu Mobile
*/

var overlayNav  = $('.cd-overlay-nav'),
overlayContent  = $('.cd-overlay-content'),
navigation      = $('.cd-primary-nav'),
toggleNav       = $('.cd-nav-trigger');

layerInit();

$(window).on('resize', function(){
	window.requestAnimationFrame(layerInit);
});

toggleNav.on('click', function(){
	if(!toggleNav.hasClass('close-nav')) {
		toggleNav.addClass('close-nav');
		$('html').css('overflow', 'hidden');  

		overlayNav.children('span').velocity({
			translateZ: 0,
			scaleX: 1,
			scaleY: 1,
		}, 500, 'easeInCubic', function(){
			navigation.addClass('fade-in');
		});

	} 
	else {
		toggleNav.removeClass('close-nav');
		$('html').css('overflow', 'unset');

		overlayContent.children('span').velocity({
			translateZ: 0,
			scaleX: 1,
			scaleY: 1,
		}, 500, 'easeInCubic', function(){
			navigation.removeClass('fade-in');

			overlayNav.children('span').velocity({
				translateZ: 0,
				scaleX: 0,
				scaleY: 0,
			}, 0);

			overlayContent.addClass('is-hidden').one('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', function(){
				overlayContent.children('span').velocity({
					translateZ: 0,
					scaleX: 0,
					scaleY: 0,
				}, 0, function(){overlayContent.removeClass('is-hidden')});
			});

			if($('html').hasClass('no-csstransitions')) {
				overlayContent.children('span').velocity({
					translateZ: 0,
					scaleX: 0,
					scaleY: 0,
				}, 0, function() {
					overlayContent.removeClass('is-hidden')
				});
			}
		});
	}
});

function layerInit(){
	var diameterValue = (Math.sqrt( Math.pow($(window).height(), 2) + Math.pow($(window).width(), 2))*2);
	overlayNav.children('span').velocity({
		scaleX: 0,
		scaleY: 0,
		translateZ: 0,
	}, 50).velocity({
		height : diameterValue+'px',
		width : diameterValue+'px',
		top : -(diameterValue/2)+'px',
		left : -(diameterValue/2)+'px',
	}, 0);

	overlayContent.children('span').velocity({
		scaleX: 0,
		scaleY: 0,
		translateZ: 0,
	}, 50).velocity({
		height : diameterValue+'px',
		width : diameterValue+'px',
		top : -(diameterValue/2)+'px',
		left : -(diameterValue/2)+'px',
	}, 0);
}

/*
* ALL ::: Menu Open/Close
*/

function setNavigation() {
	var origin   	= window.location.origin;
	var path 			= origin + window.location.pathname;
	
	var pathname 	= window.location.pathname;
	pathname = pathname.replace("/cms/", "");

	if(pathname != "") {
		$("ul.metismenu a").each(function() {
			var href 	= $(this).attr('href');
			var cls 	= $(this).attr('class');

			if(cls != 'no-active') {
				if (path === href) {
					$(this).closest('li').addClass('active');
				} 
			}
		});

		$("ul.metismenu .nav-second-level a").each(function() {
			var href 			= $(this).attr('href');
			var cls 			= $(this).attr('class');
			var n 				= path.indexOf(href);

			var str 			= path;

			var nC 				= str.search("/novo-cadastro");
			var nA				= str.search("/alterando-cadastro");
			var nV 				= str.search("/visualizar");
			var nR 				= str.search("/responder");
			var nP 				= str.search("/pasta");
			var nD 				= str.search("/detalhes");
			var nM 				= str.search("/menu");
			var nL 				= str.search("/localizacao");
			var nU 				= str.search("/api-cadastrar");

			if(nC !== -1) { 
				strArray 	= path.split('/novo-cadastro'); 
			} 
			else if(nA !== -1) { 
				strArray 	= path.split('/alterando-cadastro'); 	
			} 
			else if(nV !== -1) { 
				strArray 	= path.split('/visualizar'); 		
			} 
			else if(nR !== -1) { 
				strArray 	= path.split('/responder'); 		
			} 
			else if(nP !== -1) { 
				strArray 	= path.split('/pasta'); 		
			}
			else if(nD !== -1) { 
				strArray 	= path.split('/detalhes'); 		
			} 
			else if(nM !== -1) { 
				strArray 	= path.split('/menu'); 		
			} 
			else if(nL !== -1) { 
				strArray 	= path.split('/localizacao'); 		
			} 
			else if(nU !== -1) { 
				strArray 	= path.split('/api-cadastrar'); 		
			} 
			else {
				strArray 	= 'undefined';
			}

			if(cls != 'no-active') {
				if(String(strArray) == 'undefined') { 
					if(String(href) === String(path)) {
						$(this).prepend('<i class="fa-light fa-arrow-right"></i>');
						$(this).parent().parent().parent().parent().closest('li').addClass('active');
						$(this).parent().parent().closest('li').addClass('active');
						$(this).closest('ul').addClass('in');
					}
				} 
				else {
					if(String(href) === String(strArray[0])) {
						$(this).prepend('<i class="fa-light fa-arrow-right"></i>');
						$(this).parent().parent().parent().parent().closest('li').addClass('active');
						$(this).parent().parent().closest('li').addClass('active');
						$(this).closest('ul').addClass('in');
					}
				} 
			}
		});
	}
}

setNavigation();

// ---------------------------------------------------------------------------------------------]
// ---------------------------------------------------------------------------------[ WHATS APP ]
// ---------------------------------------------------------------------------------------------]

function btnAddWhatsApp() {
	$('.btn-add-whatsapp').on('click', function(event) {
		event.preventDefault();

		var numItems  = $('.row-whatsapp').length;
		numItems      = numItems + 1;

		$.ajax({
			type: "POST",
			url: BASE_URL + "DH_ajaxAddWhatsApp",
			data: {
				csrf_token: CSRF_TOKEN,
				num:        numItems
			}
		})
		.done(function( result ) {
			$('.ibox-content-whatsapp').append(result);
			btnRemWhatsApp();
			mask();
		});
	});
}

if($('.btn-add-whatsapp').length) {
	btnAddWhatsApp();
	console.log("Log: A função btnAddWhatsApp() foi carregada.");
}

function btnRemWhatsApp() {
	$('.btn-rem-whatsapp').on('click', function(event) {
		event.preventDefault();

		var key  = $(this).data('key');
		$('.row-whatsapp-' + key).remove();
	});
}

if($('.btn-rem-whatsapp').length) {
	btnRemWhatsApp();
	console.log("Log: A função btnRemWhatsApp() foi carregada.");
}

// ---------------------------------------------------------------------------------------------]
// --------------------------------------------------------------------------------[ DATA TABLE ]
// ---------------------------------------------------------------------------------------------]

/*
* DATA TABLE ::: Init
*/

var table = $('.dataTables');

if(table.hasClass('datatables-with-filter')) {
	var col = $('.dataTables').data('col');

	table.DataTable({
		dom: '<"row"<"col-10 mb-3"f><"col-2 mb-3 pr-0 select-filter"><"col-6 p-0"l><"col-6"p>>" + "<"row"<"col-12"tr>>" + "<"row"<"col-6"i><"col-6"p>>',
		"language": {
			"lengthMenu": 	"Mostrando _MENU_ registros por página.",
			"zeroRecords": 	"Nenhum registro encontrado.",
			"info": 				"Apresentado página _PAGE_ de _PAGES_",
			"infoEmpty": 		"Sem registros para serem apresentados.",
			"infoFiltered": "(Filtrado de _MAX_ registros)",
			"search":       "Pesquisar por:",
			"paginate": {
				"first":      "Primero",
				"last":       "Último",
				"next":       "Próximo",
				"previous":   "Anterior"
			},
		},
		stateSave: 'true',
		lengthMenu: [ 50, 100, 150, 200 ],
		rowReorder: {
			enable: 	true,
			selector: '.reorder',
			dataSrc: 	3
		},
		columnDefs: [{ 
			targets: 0, 
			visible: false 
		}],
		"drawCallback": function(settings, json) {
			changeRegisterStatus();
			btnExcluir();
			iChecks();
			checkAllMail();
		},
		initComplete: function () {
			this.api().columns( col ).every( function () {
				var column = this;

				var select = $('<select class="form-control m-b"><option value=""></option></select>').appendTo($('.select-filter').empty()).on( 'change', function () {
					var val = $.fn.dataTable.util.escapeRegex($(this).val());
					column.search( val ? '^'+val+'$' : '', true, false ).draw();
				});

				column.data().unique().sort().each( function ( d, j ) {
					select.append( '<option value="'+d+'">'+d+'</option>' )
				});
			});
		}
	});

	var table = $('.dataTables').DataTable();
}
else {
	table.DataTable({
		dom: 				'<"row"<"col-12 mb-3"f><"col-6 p-0"l><"col-6"p>>" + "<"row"<"col-12"tr>>" + "<"row"<"col-6"i><"col-6"p>>',
		stateSave: 	'true',
		lengthMenu: [ 50, 100, 150, 200 ],
		"drawCallback": function(settings, json) {
			changeRegisterStatus();
			btnExcluir();
			iChecks();
			checkAllMail();
		},
		"language": {
			"lengthMenu": 	"Mostrando _MENU_ registros por página.",
			"zeroRecords": 	"Nenhum registro encontrado.",
			"info": 				"Apresentado página _PAGE_ de _PAGES_",
			"infoEmpty": 		"Sem registros para serem apresentados.",
			"infoFiltered": "(Filtrado de _MAX_ registros)",
			"search":       "Pesquisar por:",
			"paginate": {
				"first":      "Primero",
				"last":       "Último",
				"next":       "Próximo",
				"previous":   "Anterior"
			},
		}
	});
}

/*
* DATA TABLE ::: Child
*/

var tdControl = $('.dt-control');

function btnDataTableChilds() {
	$('tbody td.dt-control').on('click', '.btn-child', function() {
		var table = $('.dataTables').DataTable();

		var tr  	= $(this).closest('tr');
		var row 	= table.row( tr );

		var id  			= $(this).data('id');
		var mod  			= $(this).data('mod');
		var table  		= $(this).data('table');
		var where  		= $(this).data('where');
		var type  		= $(this).data('type');
		var type  		= $(this).data('type');
		var variable  = $(this).data('variable');
		var view  		= $(this).data('view');
		var functions = $(this).data('functions');
		var input 		= $(this).data('inputs');
		var cla 			= $(this).data('class');
		var api 			= $(this).data('api');

		if(input != "") {
			var inputs = input.split(';');
			var inp 	= [];

			$.each(inputs, function(index, val) {
				if(val != "none") {
					var i = val.split(',');
					var o = [];

					var l = i.length;
					var k = 0;

					$.each(i, function(x, v) {
						if($(v).val() != "" && $(v).val() != 0 && $(v).val() != "0") {
							o.push($(v).val());
						}
						else {
							k += 1;
						}
					});

					if(k == l) {
						inp.push('none');	 
					}
					else {
						inp.push(o);	 
					}
				}
				else {
					inp.push('none');	 
				}
			});
		}
		
		var jqXHR = $.ajax({
			type: "POST",
			url: BASE_URL + "DH_ajaxDataTableGetChilds",
			data: { 
				csrf_token: CSRF_TOKEN,
				id:					id,
				mod:				mod,
				table:			table,
				where:			where,
				type:				type,
				variable:		variable,
				inp:				inp,
				view:				view,
				cla: 				cla,
				api: 				api
			},
			beforeSend: function( xhr ) {
				$('.btn-child-' + id).html('').html('<i class="fa-duotone fa-spinner-third fa-spin-pulse"></i>');
			}
		});
		
		jqXHR.done(function( msg ) {				
			if (row.child.isShown()) {
				$('.btn-child-' + id).removeClass('btn-danger').addClass('btn-primary').html('').html('<i class="fa-light fa-plus"></i>');
				row.child( msg ).hide();
			}
			else {
				$('.btn-child-' + id).removeClass('btn-primary').addClass('btn-danger').html('').html('<i class="fa-light fa-xmark"></i>');
				row.child( msg ).show();

				if(functions) {
					var fun = functions.split(';');

					$.each(fun, function(index, f) {
						if(f == "changeRegisterStatus") {
							changeRegisterStatus();
							console.log("Função changeRegisterStatus() carregada.");
						}
					});
				}
			}
		});

		jqXHR.always(function() {
			btnExcluir();
		})
	});
}

if(tdControl.length > 0) {
	btnDataTableChilds();
}

function criarChildRow(dataTable, btn) {
	var table = $(dataTable).DataTable();

	var tr  	= $(btn).closest('tr');
	var row 	= table.row( tr );

	var id  			= $(btn).data('id');
	var mod  			= $(btn).data('mod');
	var table  		= $(btn).data('table');
	var where  		= $(btn).data('where');
	var type  		= $(btn).data('type');
	var type  		= $(btn).data('type');
	var variable  = $(btn).data('variable');
	var view  		= $(btn).data('view');
	var functions = $(btn).data('functions');
	var input 		= $(btn).data('inputs');

	if(input != "") {
		var inputs = input.split(';');
		var inp 	= [];

		$.each(inputs, function(index, val) {
			if(val != "none") {
				var i = val.split(',');
				var o = [];

				var l = i.length;
				var k = 0;

				$.each(i, function(x, v) {
					if($(v).val() != "" && $(v).val() != 0 && $(v).val() != "0") {
						o.push($(v).val());
					}
					else {
						k += 1;
					}
				});

				if(k == l) {
					inp.push('none');	 
				}
				else {
					inp.push(o);	 
				}
			}
			else {
				inp.push('none');	 
			}
		});
	}

	$.ajax({
		type: "POST",
		url: BASE_URL + "DH_ajaxDataTableGetChilds",
		data: { 
			csrf_token: CSRF_TOKEN,
			id:					id,
			mod:				mod,
			table:			table,
			where:			where,
			type:				type,
			variable:		variable,
			inp:				inp,
			view:				view
		},
		beforeSend: function( xhr ) {
			$('.btn-child-m-' + id).html('').html('<i class="fa-duotone fa-spinner-third fa-spin fa-fw mr-1"></i>');
		}
	})
	.done(function( msg ) {	

		if (row.child.isShown()) {
			$('.btn-child-m-' + id).removeClass('btn-danger').addClass('btn-primary').html('').html('<i class="fal fa-plus-circle"></i>');
			row.child( msg ).hide();
		}
		else {
			$('.btn-child-m-' + id).removeClass('btn-primary').addClass('btn-danger').html('').html('<i class="fal fa-minus-circle"></i>');
			row.child( msg ).show();
		}
	});
}

/*
* DATA TABLE ::: Callback de quando troca de página
*/

$('.dataTables').on( 'page.dt', function () {
});

// ---------------------------------------------------------------------------------------------]
// ------------------------------------------------------------------------------------[ EMAIL ]
// ---------------------------------------------------------------------------------------------]

/*
* EMAIL ::: Validate
*/

$('.btn-validate').on('click', function(event) {
	event.preventDefault();

	$('.btn-validate').html('');
	$('.btn-validate').html("<i class='fa-duotone fa-spinner-third fa-spin'></i> Verificando...");

	$.ajax({
		type: 			"POST",
		dataType: 	"json",
		url: 				BASE_URL + "cms-configuracoes-de-email/validar",
		data: {
			csrf_token: CSRF_TOKEN
		}
	}).done(function( msg ) {
		if(msg == 1) {
			$('.btn-validate').html('');
			$('.btn-validate').html('<i class="fa-light fa-check"></i>');

			var swalHtml = "";
			swalHtml += '<i class="fa-light fa-check text-navy text-12 mb-3"></i><br/>';
			swalHtml += '<h1>Tudo certo!</h1>';
			swalHtml += '<p class="mb-0 text-lowercase">as configurações de e-mail foram validadas com sucesso</p>';

			var swalConfirmButtonText = 'Obrigado <i class="fa-light fa-arrow-right ml-1"></i>';
			var swalCancelButtonText 	= ''
			var swalIsConfirmed 			= 0;
			var swalResult 						= 'location.reload()';

			sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
		} 
		else {
			$('.btn-validate').html('');
			$('.btn-validate').html('<i class="fa-light fa-check"></i> VALIDAR');

			var swalHtml = "";
			swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
			swalHtml += '<h1>Ops!</h1>';
			swalHtml += '<p class="mb-0 text-lowercase">Verifique os dados informados e tente novamente</p>';

			var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
			var swalCancelButtonText 	= ''
			var swalIsConfirmed 			= 0;
			var swalResult 						= '';

			sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
		}
	});
});

// ---------------------------------------------------------------------------------------------]
// ------------------------------------------------------------------------------------[ SUBMIT ]
// ---------------------------------------------------------------------------------------------]

/*
* SUBMIT ::: Validate
*/

$(".validate").validate({
	invalidHandler: function(event, validator) {
		var errors = validator.numberOfInvalids();

		if (errors) {
			var toastIcon			= '<i class="fa-light fa-triangle-exclamation me-1"></i>';
			var toastTitle		= 'Ops!';
			var toastMessage	= errors == 1 ? 'Um campo obrigatório não foi preenchido.' : errors + ' campos obrigatórios não preenchidos.';
			var toastType			= 'toast-danger';
			var toastDelay		= 2500;
			var toastAutohide	= true;

			toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);
			$('#spiner').hide();
		}
	},
	focusInvalid: false
});

$(".validate-with-pass").validate({
	rules: {
		senha: "required",
		repetir_senha: {
			equalTo: "#senha"
		}
	},
	messages: {
		senha: {
			required: "A senha deve ser informada.",
			minlength: "A senha precisa ter 6 ou mais dígitos."
		},
		repetir_senha: {
			required: "Confirme sua senha.",
			minlength: "A senha precisa ter 6 ou mais dígitos.",
			equalTo: "A confirmação de senha, não confere com a senha informada."
		}
	},
	invalidHandler: function(event, validator) {
		var errors = validator.numberOfInvalids();

		if (errors) {
			var toastIcon			= '<i class="fa-light fa-triangle-exclamation me-1"></i>';
			var toastTitle		= 'Ops!';
			var toastMessage	= errors == 1 ? 'Um campo obrigatório não foi preenchido.' : errors + ' campos obrigatórios não preenchidos.';
			var toastType			= 'toast-danger';
			var toastDelay		= 2500;
			var toastAutohide	= true;

			toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);
			$('#spiner').hide();
		}
	},
	focusInvalid: false
});

$('#senha').on('keyup', function(event) {
	var conteudo = $(this).val();

	if(conteudo.length > 0) {
		$('#senha').attr('data-rule-required', 'true').attr('data-msg-required', 'A senha deve ser informada.').attr('data-rule-minlength', '6').attr('data-msg-minlength', 'A senha precisa ter 6 ou mais dígitos.');
		$('#repetir_senha').attr('data-rule-required', 'true').attr('data-msg-required', 'Confirme sua senha.').attr('data-rule-minlength', '6').attr('data-msg-minlength', 'A senha precisa ter 6 ou mais dígitos.').attr('data-rule-equalto', '#senha').attr('data-msg-equalto', 'A confirmação de senha, não confere com a senha informada.');
	} 
	else {
		$('#senha').attr('data-rule-required', false).attr('data-msg-required', false).attr('data-rule-minlength', false).attr('data-msg-minlength', false);
		$('#repetir_senha').attr('data-rule-required', false).attr('data-msg-required', false).attr('data-rule-minlength', false).attr('data-msg-minlength', false).attr('data-rule-equalto', false).attr('data-msg-equalto', false);
	}
});

/*
* SUBMIT ::: jQuery Validator
*/

$.validator.addMethod("noSpace", function(value, element) {
	if( $(element).attr('required') ) {
		return value.search(/[a-zA-Z0-9À-žа-яА-ЯёЁα-ωΑ-Ω\s\u0621-\u064A\u0660-\u0669 ]/i) == 0;
	}

	return true;
}, 'Esta campo não pode ser vazio.');

$.validator.addClassRules({
	'form-group': {
		noSpace: true
	},
	'form-control': {
		noSpace: true
	},
	'mask-cnpj': {
		noSpace: true
	},
	'mask-cep': {
		noSpace: true
	},
	'mask-phone': {
		noSpace: false
	},
	'cpfOuCnpj': {
		noSpace: false
	}
});

$.validator.addMethod('phoneBR', function (value, element) {
	value = value.replace("(","");
	value = value.replace(")", "");
	value = value.replace("-", "");
	value = value.replace(" ", "").trim();

	if (value == '0000000000') {
		return (this.optional(element) || false);
	} 
	else if (value == '00000000000') {
		return (this.optional(element) || false);
	}

	if (["00", "01", "02", "03", , "04", , "05", , "06", , "07", , "08", "09", "10"].indexOf(value.substring(0, 2)) != -1) {
		return (this.optional(element) || false);
	}

	if (value.length < 10 || value.length > 11) {
		return (this.optional(element) || false);
	}

	return (this.optional(element) || true);
}, 'Informe um contato válido.');

$.validator.addMethod( "cpfBR", function( value, element ) {
	"use strict";

	if ( this.optional( element ) ) {
		return true;
	}

	value = value.replace( /([~!@#$%^&*()_+=`{}\[\]\-|\\:;'<>,.\/? ])+/g, "" );

	if ( value.length !== 11 ) {
		return false;
	}

	var sum = 0, firstCN, secondCN, checkResult, i;

	firstCN 	= parseInt( value.substring( 9, 10 ), 10 );
	secondCN 	= parseInt( value.substring( 10, 11 ), 10 );

	checkResult = function( sum, cn ) {
		var result = ( sum * 10 ) % 11;

		if ( ( result === 10 ) || ( result === 11 ) ) {
			result = 0;
		}

		return ( result === cn );
	};

	if ( value === "" || value === "00000000000" || value === "11111111111" || value === "22222222222" || value === "33333333333" || value === "44444444444" || value === "55555555555" || value === "66666666666" || value === "77777777777" || value === "88888888888" || value === "99999999999" ) {
		return false;
	}

	for ( i = 1; i <= 9; i++ ) {
		sum = sum + parseInt( value.substring( i - 1, i ), 10 ) * ( 11 - i );
	}

	if ( checkResult( sum, firstCN ) ) {
		sum = 0;

		for ( i = 1; i <= 10; i++ ) {
			sum = sum + parseInt( value.substring( i - 1, i ), 10 ) * ( 12 - i );
		}

		return checkResult( sum, secondCN );
	}

	return false;
}, "Informe um CPF válido." );

$.validator.addMethod( "cnpjBR", function( value, element ) {
	"use strict";

	if ( this.optional( element ) ) {
		return true;
	}

	value = value.replace( /[^\d]+/g, "" );

	if ( value.length !== 14 ) {
		return false;
	}

	if ( value === "00000000000000" || value === "11111111111111" || value === "22222222222222" || value === "33333333333333" || value === "44444444444444" || value === "55555555555555" || value === "66666666666666" || value === "77777777777777" || value === "88888888888888" || value === "99999999999999" ) {
		return false;
	}

	var tamanho = ( value.length - 2 );
	var numeros = value.substring( 0, tamanho );
	var digitos = value.substring( tamanho );
	var soma 		= 0;
	var pos 		= tamanho - 7;

	for ( var i = tamanho; i >= 1; i-- ) {
		soma += numeros.charAt( tamanho - i ) * pos--;

		if ( pos < 2 ) {
			pos = 9;
		}
	}

	var resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;

	if ( resultado !== parseInt( digitos.charAt( 0 ), 10 ) ) {
		return false;
	}

	tamanho = tamanho + 1;
	numeros = value.substring( 0, tamanho );
	soma 		= 0;
	pos 		= tamanho - 7;

	for ( var il = tamanho; il >= 1; il-- ) {
		soma += numeros.charAt( tamanho - il ) * pos--;
		if ( pos < 2 ) {
			pos = 9;
		}
	}

	resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;

	if ( resultado !== parseInt( digitos.charAt( 1 ), 10 ) ) {
		return false;
	}

	return true;
}, "Informe um CNPJ válido." );

$.validator.addMethod( "postalcodeBR", function( value, element ) {
	return this.optional( element ) || /^\d{2}.\d{3}-\d{3}?$|^\d{5}-?\d{3}?$/.test( value );
}, "Informe um CEP válido." );

function validateEmail(email) {
	var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;

	if( !emailReg.test( email ) ) {
		return false;
	} 
	else {
		return true;
	}
}

/*
* SUBMIT ::: Form
*/

$( '.btn-submit-login' ).on('click', function() {
	var $form 				= $( '#formLogin' ),
	$submitButton 		= $form.find('.btn-submit-login'),
	submitButtonText 	= $submitButton.html();

	if( GOOGLERECAPTCHA == 1 ) {
		console.log( "Google reCaptcha ativado." );

		$form.addClass( 'login-form-recaptcha-v3' );
		$submitButton.removeAttr("type").attr("type", "submit");

		$('.login-form-recaptcha-v3').each(function() {
			$(this).validate({ 
				submitHandler: function(form) {
					$submitButton.html("<i class='fa-duotone fa-spinner-third fa-spin'></i> Verificando...").prop('disabled', true);
					var site_key = $('#google-recaptcha-v3').attr('src').split("render=")[1];

					grecaptcha.execute(site_key, {action: 'login'}).then(function(token) {
						var formData 	= $form.serializeArray(),
						data 					= {};

						$(formData).each(function(index, obj){
							data[obj.name] = obj.value;
						});

						data["g-recaptcha-response"] = token;

						$.ajax({
							type: 		'POST',
							data: 		data,
							dataType: 'json',
							url: 		$form.attr('action')
						})
						.always(function(data, textStatus, jqXHR) {
							if(data.twofa == 'active') {
								$('.cont-form-login').css('transform', 'translateX(-100%)');
								$('.cont-form-login-2fa').css('transform', 'translate(0, -100%)');

								setTimeout(() => { $('.input-2fa-1').focus() }, 300 );
								
								$('#data_twofa').val(data.data);
							}
							else if (data.response == 'success') {
								$form.find('.form-control').val('').blur().parent().removeClass('has-success').removeClass('has-danger').find('label.error').remove();

								$form.find('.form-control').removeClass('error');
								$form.find('.form-control').removeClass('is-valid');
								$form.find('.form-control').removeClass('is-invalid');

								$submitButton.html('<i class="fa-light fa-arrow-right-to-arc"></i> Acessar').prop('disabled', false);

								var swalHtml = "";
								swalHtml += '<i class="fa-light fa-check text-navy text-12 mb-3"></i><br/>';
								swalHtml += data.successMessage;

								var swalConfirmButtonText = 'Acessar painel <i class="fa-light fa-arrow-right ml-1"></i>';
								var swalCancelButtonText 	= ''
								var swalIsConfirmed 			= 1;
								var swalResult 						= 'window.location.href = BASE_URL + "pagina-inicial"';

								sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);

								return;
							} 
							else if (data.response == 'error') {
								var swalHtml = "";
								swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
								swalHtml += data.errorMessage + "<br/>";
								swalHtml += data.log;

								var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
								var swalCancelButtonText 	= ''
								var swalIsConfirmed 			= 0;
								var swalResult 						= '';

								sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
							} 
							else {
								var swalHtml = "";
								swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
								swalHtml += data.errorMessage + "<br/>";

								var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
								var swalCancelButtonText 	= ''
								var swalIsConfirmed 			= 0;
								var swalResult 						= '';

								sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
							}

							$form.find('.has-success').removeClass('has-success');
							$submitButton.html('<i class="fa-light fa-arrow-right-to-arc"></i> Acessar').prop('disabled', false);
						});
					});
				} 
			}); 
		}); 
	} 
	else {
		console.log( "Google reCaptcha desativado." );

		$form.removeClass( 'login-form-recaptcha-v3' );
		$submitButton.removeAttr("type").attr("type", "button");

		var v = validateEmail( $( '#email' ).val() );

		if( v ) {
			$.ajax({
				method: 	"POST",
				dataType: "json",
				url: 			BASE_URL + "login/autenticar",
				data: { 
					csrf_token: CSRF_TOKEN,
					email: 			$( '#email' ).val(),
					senha: 			$( '#senha' ).val()
				},
				beforeSend: function( xhr ) {
					$( this ).html("<i class='fa-duotone fa-spinner-third fa-spin'></i> Verificando...");
				}
			})
			.done(function( result ) {
				if(result.twofa == 'active') {
					$('.cont-form-login').css('transform', 'translateX(-100%)');
					$('.cont-form-login-2fa').css('transform', 'translate(0, -100%)');

					setTimeout(() => { $('.input-2fa-1').focus() }, 300 );

					$('#data_twofa').val(result.data);
				}
				else if (result.response == 'success') {
					$form.find('.form-control').val('').blur().parent().removeClass('has-success').removeClass('has-danger').find('label.error').remove();

					$form.find('.form-control').removeClass('error');
					$form.find('.form-control').removeClass('is-valid');
					$form.find('.form-control').removeClass('is-invalid');

					$submitButton.html('<i class="fa-light fa-arrow-right-to-arc"></i> Acessar').prop('disabled', false);

					var swalHtml = "";
					swalHtml += '<i class="fa-light fa-check text-navy text-12 mb-3"></i><br/>';
					swalHtml += result.successMessage;

					var swalConfirmButtonText = 'Acessar painel <i class="fas fa-angle-right"></i>';
					var swalCancelButtonText 	= ''
					var swalIsConfirmed 			= 0;
					var swalResult 						= 'window.location.href = BASE_URL + "pagina-inicial"';

					sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, 1, swalResult);
					return;
				} 
				else if (result.response == 'error') {
					var swalHtml = "";
					swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
					swalHtml += result.errorMessage + "<br/>";
					swalHtml += result.log;

					var swalConfirmButtonText = 'Vou verificar <i class="fas fa-angle-right"></i>';
					var swalCancelButtonText 	= ''
					var swalIsConfirmed 			= 0;
					var swalResult 						= '';

					sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, 0, swalResult);
					return;
				} 
				else {
					var swalHtml = "";
					swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
					swalHtml += data.errorMessage + "<br/>";

					var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
					var swalCancelButtonText 	= ''
					var swalIsConfirmed 			= 0;
					var swalResult 						= '';

					sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
					return;
				}
			});
		}
		else {
			var swalHtml = "";
			swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
			swalHtml += '<h1>Acesso negado!</h1>';
			swalHtml += '<p class="mb-0 text-lowercase">Dados inválidos</p>';

			var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
			var swalCancelButtonText 	= ''
			var swalIsConfirmed 			= 0;
			var swalResult 						= '';

			sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
		}
	}
});

// ---------------------------------------------------------------------------------------------]
// ------------------------------------------------------------------------------------[ SELECT ]
// ---------------------------------------------------------------------------------------------]

/*
* SELECT ::: Estados without Maps
*/

$('.select-estado').on('change', function(event) {
	event.preventDefault();

	var idEstado = $(this).val();

	$.ajax({
		method: "POST",
		url: 		BASE_URL + "/DH_getCidades",
		data: { 
			csrf_token: CSRF_TOKEN,
			idEstado:		idEstado
		},
		beforeSend: function( xhr ) {
			$('.select-cidade').html('').append('<option>Carregando cidades...</option>');
		}
	})
	.done(function( result ) {
		var data = $.parseJSON(result);

		$('.select-cidade').html('');

		if(data != "") {
			$('.select-cidade').append('<option value="" selected>Selecione a cidade</option>');
			$('.select-cidade').append('<option value="todas">Todas as cidades</option>');

			$.each(data, function(index, val) {
				$('.select-cidade').append('<option value="'+val.id+'">'+val.titulo+'</option>')
			});
		}
		else {
			$('.select-cidade').append('<option value="">Sem cidades encontradas</option>');
		}
	});
});

/*
* SELECT ::: Dimensões dos banners
*/

$('.select-banner-modulos').on('change', function(e) {
	e.preventDefault();

	var optionSelected = $(this).find("option:selected");

	var wd = optionSelected.data('width');
	var hd = optionSelected.data('height');

	$('.dimension-desktop').html('').html("Largura <b>" + wd + "</b> e altura <b>" + hd + "</b>");

	var wm = optionSelected.data('width-mobile');
	var hm = optionSelected.data('height-mobile');

	$('.dimension-mobile').html('').html("Largura <b>" + wm + "</b> e altura <b>" + hm + "</b>");
});

/*
* SELECT ::: Permissão de usuário
*/

$('.select-user-category').on('change', function(event) {
	event.preventDefault();

	var idCategoria = $(this).val();

	$('.input-module-category').iCheck('uncheck');
	$('.input-module').iCheck('uncheck');

	$.ajax({
		type: "POST",
		url: 	BASE_URL + "usuario/ajaxGetPermission",
		data: {
			csrf_token: CSRF_TOKEN, 
			idCategoria: 					idCategoria, 
		}
	})
	.done(function( result ) {
		result = JSON.parse(result);
		
		$('.input-module-category').each(function(index, e) {
			if(result.idMmoduloCategoria.indexOf($(this).val()) > -1) {
				$(this).iCheck('check');
			}
			else {
				$(this).iCheck('uncheck');
			}
		});

		$('.input-module').each(function(index, e) {
			if(result.idMmodulo.indexOf($(this).val()) > -1) {
				$(this).iCheck('check');
			}
			else {
				$(this).iCheck('uncheck');
			}
		});
	});

	if(idCategoria == 1) {

		/*
		* Root
		*/

		$('.row-dados-de-acesso').show();
		$('.row-franquias').hide();
		$('.row-permissoes-de-acesso').show();
		$('.row-permissoes-de-acesso-apps').hide();
	}

	if(idCategoria == 2) {

		/*
		* Franqueadora
		*/

		$('.row-dados-de-acesso').show();
		$('.row-franquias').hide();
		$('.row-permissoes-de-acesso').show();
		$('.row-permissoes-de-acesso-apps').hide();
	}

	if(idCategoria == 3) {

		/*
		* Franquias
		*/

		$('.row-dados-de-acesso').show();
		$('.row-franquias').show();
		$('.row-permissoes-de-acesso').hide();
		$('.row-permissoes-de-acesso-apps').show();
	}

	if(idCategoria == 4) {

		/*
		* Usuários
		*/

		$('.row-dados-de-acesso').show();
		$('.row-franquias').show();
		$('.row-permissoes-de-acesso').hide();
		$('.row-permissoes-de-acesso-apps').show();
	}
});

/*
* SELECT ::: Permissão de usuário
*/

$('.select-user-apps').on('change', function(event) {
	event.preventDefault();
	
	var apps = $(this).val();

	if(apps == 1) {
		$('.row-apps').removeClass('d-none');
		$('.row-permissoes').addClass('d-none');
	}
	else {
		$('.row-apps').addClass('d-none');
		$('.row-permissoes').removeClass('d-none');
	}
});

/*
* SELECT ::: Show/Hide inputs by choice
*/

$('.select-mod-app').on('click', function(event) {
	event.preventDefault();
	
	var v = $(this).val();

	if(v == 1) {
		$('.row-app').removeClass('d-none');
	}
	else {
		$('.row-app').addClass('d-none');
	}
});

/*
* SELECT ::: Chosen Select
*/

$('.chosen-select').chosen({
	width: "calc(100% - 45px)",
	height: "42px"
});

/*
* SELECT ::: Select2
*/

if($('.form-select-2').length > 0) {
	$('.form-select-2').select2();
}

/*
* SELECT ::: Soluções
*/

var selectSolucoesTipos 					= $('.select-solucoes-tipos');
var selectSolucoesCategorias 			= $('.select-solucoes-categorias');
var selectSolucoesSubcategorias 	= $('.select-solucoes-subcategorias');

selectSolucoesTipos.on('change', function(event) {
	event.preventDefault();
	
	var idTipo = $(this).find(":selected").val();
	var modulo = $(this).data('modulo');

	var jqXHR = $.ajax({
		type: 		'POST',
		dataType: "json",
		url: 			BASE_URL + modulo + "/XHR_getCategorias",
		data: { 
			csrf_token: 	CSRF_TOKEN,
			idTipo:				idTipo
		},
		beforeSend: function() {
			selectSolucoesCategorias.html('').append('<option>Carregando dados...</option>');
		}
	});

	jqXHR.done(function( rst ) {
		if(rst != "") {
			selectSolucoesCategorias.html('').append('<option selected>Selecione uma das opções.</option>');

			selectSolucoesCategorias.append('<option value="0">Nenhuma opção</option>')

			$.each(rst, function(index, categoria) {
				selectSolucoesCategorias.append('<option value="' + categoria.id + '">' + categoria.titulo + '</option>')
			});
		}
		else {
			selectSolucoesCategorias.html('').append('<option>Dados não encontrados...</option>');
		}
	});

	jqXHR.fail(function() {
	});

	jqXHR.always(function() {
	});
});

selectSolucoesCategorias.on('change', function(event) {
	event.preventDefault();
	
	var idCategoria = $(this).find(":selected").val();
	var modulo 			= $(this).data('modulo');

	var jqXHR = $.ajax({
		type: 		'POST',
		dataType: "json",
		url: 			BASE_URL + modulo + "/XHR_getSubcategorias",
		data: { 
			csrf_token: 	CSRF_TOKEN,
			idCategoria:	idCategoria
		},
		beforeSend: function() {
			selectSolucoesSubcategorias.html('').append('<option>Carregando dados...</option>');
		}
	});

	jqXHR.done(function( rst ) {
		if(rst != "") {
			selectSolucoesSubcategorias.html('').append('<option selected>Selecione uma das opções.</option>');

			$.each(rst, function(index, subcategoria) {
				selectSolucoesSubcategorias.append('<option value="' + subcategoria.id + '">' + subcategoria.titulo + '</option>')
			});
		}
		else {
			selectSolucoesSubcategorias.html('').append('<option>Dados não encontrados...</option>');
		}
	});

	jqXHR.fail(function() {
	});

	jqXHR.always(function() {
	});
});

// ---------------------------------------------------------------------------------------------]
// ----------------------------------------------------------------------------------[ CAROUSEL ]
// ---------------------------------------------------------------------------------------------]

/*
* CAROUSEL ::: Slick
*/

$('.slick').slick({
	infinite: true,
	slidesToShow: 8,
	slidesToScroll: 1,
	centerMode: true,
});

/*
* CAROUSEL ::: Owl
*/

$('.owl-carousel').owlCarousel({
	loop: true,
	margin: 10,
	nav: true,
	dots: false,
	responsive:{
		0:{
			items:1
		},
		600:{
			items:3
		},
		1000:{
			items:5
		}
	}
});

// ---------------------------------------------------------------------------------------------]
// -------------------------------------------------------------------------------------[ TOOLS ]
// ---------------------------------------------------------------------------------------------]

/*
* TOOLS :::  Caixa de ferramentas
*/

$('#btn-upd-user-permissions').on('click', function(event) {
	event.preventDefault();
	
	$.ajax({
		type: "POST",
		url: BASE_URL + "fer_ferramentas/ajaxUpdAllAccountsPermissions",
		data: {
			csrf_token: CSRF_TOKEN
		},
		beforeSend: function( xhr ) {
			$('#btn-upd-user-permissions').html('').html('<i class="fa-duotone fa-spinner-third fa-spin fa-fw mr-1"></i> Atualizando...');
		}
	})
	.done(function( result ) {
		json = JSON.parse(result);

		$('.result').html('').append(json);
		$('#btn-upd-user-permissions').html('').html('Atualizar permissões de usuários');
	});
});

// ---------------------------------------------------------------------------------------------]
// ------------------------------------------------------------------------------------[ INPUTS ]
// ---------------------------------------------------------------------------------------------]

/*
* INPUT ::: iChecks
*/

function iChecks() {
	$('.i-checks').iCheck({
		checkboxClass:  'icheckbox_square-green',
		radioClass:     'iradio_square-green',
	});

	$('.i-checks.green').iCheck({
		checkboxClass:  'icheckbox_square-green',
		radioClass:     'iradio_square-green',
	});

	$('.i-checks.red').iCheck({
		checkboxClass:  'icheckbox_square-red',
		radioClass:     'iradio_square-red',
	});
}

iChecks();

/*
* INPUT ::: TinyMCE
*/

function initTinymce() {
	tinymce.init({
		selector:                       '.tinymce',
		language:                       'pt_BR',
		language_url:                   BASE_URL+'assets/js/plugins/tinymce/langs/pt_BR.js',

		forced_root_block: 							'',
		force_br_newlines: 							true,
		force_p_newlines: 							false,

		height:                         250,

		menubar:                        false,
		keep_styles:                    false,
		convert_fonts_to_spans:         false,
		paste_as_text:                  true,
		paste_auto_cleanup_on_paste:    true,
		paste_remove_styles:            true,
		paste_remove_styles_if_webkit:  true,
		paste_strip_class_attributes:   true,
		paste_enable_default_filters:   true,
		relative_urls:                  false,
		image_advtab:                   true,

		protect:                        [ /\<\/?(if|endif)\>/g, /\<xsl\:[^>]+\>/g, /<\?php.*?\?>/g ],
		image_class_list:               [{title: 'img-fluid', value: 'img-fluid'}, {title: 'Largura 100%', value: 'w-100'}],

		plugins:                        'paste image code imagetools link lists code',
		toolbar:                        'undo redo | bold italic | removeformat | link ', 
		imagetools_toolbar:             'rotateleft rotateright | flipv fliph | editimage imageoptions',

		images_upload_url:              BASE_URL + 'assets/php/upload_tinymce.php',
		images_upload_base_path:        BASE_URL + 'assets/uploads/upload_tinymce/',

		images_upload_handler: function (blobInfo, success, failure) {
			var xhr, formData;

			xhr = new XMLHttpRequest();

			xhr.withCredentials = false;
			xhr.open('POST', BASE_URL + 'assets/php/upload_tinymce.php');

			xhr.onload = function() {
				var json;

				if (xhr.status != 200) {
					failure('HTTP Error: ' + xhr.status);
					return;
				}

				json = JSON.parse(xhr.responseText);

				if (!json || typeof json.location != 'string') {
					failure('Invalid JSON: ' + xhr.responseText);
					return;
				}

				success(json.location);
			};

			formData = new FormData();
			formData.append('file', blobInfo.blob(), blobInfo.filename());
			formData.append('mudulo', window.location.pathname);

			xhr.send(formData);
		}
	});
}

if($('.tinymce').length) {
	initTinymce();
}

/*
* INPUT ::: Real
*/

function numberToReal(numero) {
	numero = parseFloat(numero);

	if (isNaN(numero) || numero <= 0) {
		return "R$ 0,00";
	} 
	else {
		numero = numero.toFixed(2).split('.');
		numero[0] = "R$ " + numero[0].split(/(?=(?:...)*$)/).join('.');

		return numero.join(',');
	}
}

/*
* INPUT ::: Mask
*/

$(document).on('keydown', '.cpfOuCnpj', function (e) {
	var digit = e.key.replace(/\D/g, '');
	var value = $(this).val().replace(/\D/g, '');
	var size 	= value.concat(digit).length;

	$(this).mask((size <= 11) ? '000.000.000-00' : '00.000.000/0000-00');
});

function mask() {
	$('.mask-phone').mask("(99) 99999-9999");

	$('.mask-phone').focusout(function() {
		var phone, element;
		element = $(this);

		element.unmask();
		phone = element.val().replace(/\D/g, '');

		if(phone.length > 10) {
			element.mask("(99) 99999-9999");
		} 
		else {
			element.mask("(99) 9999-99999");
		}
	}).trigger('focusout');

	$('.mask-money').mask("#.###.##0,00", {reverse: true});
	$('.mask-calendar-default').mask("0000-00-00");
	$('.mask-calendar').mask("00/00/0000");
	$('.mask-calendar-year').mask("0000");
	$('.mask-calendar-time-seconds').mask('00/00/0000 00:00:00');
	$('.mask-calendar-time').mask('00/00/0000 00:00');
	$('.mask-time').mask('00:00');
	$('.mask-cep').mask("99999-999");
	$('.mask-cpf').mask("999.999.999-99");
	$('.mask-cnpj').mask("99.999.999/9999-99");
}

mask();

/*
* INPUT ::: Calendar
*/

function celendarJS() {
	var d         = new Date();
	var strDate   = d.getDate();
	var strMonth  = d.getMonth()+1;
	var strYear   = d.getFullYear();

	var weekday   = [
		"Domingo",
		"Segunda-feira",
		"Terça-feira",
		"Quarta-feira",
		"Quinta-feira",
		"Sexta-feira",
		"Sábado"
		];

	var htmlDatePicker = "" +
	"<table id='datePickerHeader'>" +
	"		<tr class='primary'>" +
	"			<td>" + weekday[d.getDay()]+ "</td>" +
	"		</tr>" +
	"		<tr class='secondary'>" +
	"			<td>" + strDate + "</td>" +
	"		</tr>" +
	"</table>";

	var mem = $('.input-calendar .input-group.date').datepicker({
		todayBtn:           "linked",
		keyboardNavigation: false,
		forceParse:         false,
		calendarWeeks:      false,
		autoclose:          true,
		format:             'dd/mm/yyyy',                
	})
	.on('show', function(e) {
		$('#datePickerHeader').remove();
		$('.datepicker').prepend(htmlDatePicker);
		$('.datepicker-overlay').fadeIn('fast');
	})
	.on('hide', function(e){
		$('.datepicker-overlay').fadeOut('fast');
	})
	.on('changeDate', function(e){
	});
}

celendarJS();

/*
* INPUT ::: PWD
*/

var optionsPWD = {};

optionsPWD.ui = {
	verdicts: 											["Fraca", "Normal", "Média", "Forte", "Muito Forte"],
	container: 											".pwd-container",
	showVerdictsInsideProgressBar: 	true,
	viewports: {
		progress: ".input-password-progress"
	},
	onKeyUp: function (evt, data) {
		var checkScore = $(evt.target).val().length;

		if (checkScore <= 80) {
			console.log("DEIXA DISABLED");
		} 
		else {
			console.log("TIRA O DISABLED");
		}
	},
};

optionsPWD.common = {
	debug: false,
};

if($('.input-password').length) {
	$('.input-password').pwstrength( optionsPWD );
	console.log("Log: PW Strength carregado.");
}

/*
* INPUT ::: Switchery
*/

function changeRegisterStatus() {
	var elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));

	elems.forEach(function(html) {
		if(typeof $(html).data('switchery') === 'undefined') {
			var switchery = new Switchery( html, { 
				size: 							'small', 
				color: 							'#1ab394', 
				secondaryColor: 		'#ed5666', 
				jackColor: 					'#ffffff', 
				jackSecondaryColor: '#ffffff' 
			});

			$( html ).on('change', function( event ) {
				event.preventDefault();

				var table  	= $(this).data('table');
				var column  = $(this).data('column');
				var id     	= $(this).data('id');
				var status 	= html.checked ? 1 : 0;

				$.ajax({
					type: 		'POST',
					url: 			BASE_URL + "DH_ajaxChangeRegisterStatus",
					data: { 
						csrf_token: CSRF_TOKEN, 
						table: 			table,
						column: 		column,
						id: 				id,
						status: 		status,
					},
					beforeSend: function( xhr ) {
						$('#spiner').show();
					}
				})
				.done(function( result ) {
					$('#spiner').hide();

					if(status == 0) {
						var swalHtml = "";
						swalHtml += '<i class="fa-light fa-check text-navy text-12 mb-3"></i><br/>';
						swalHtml += '<h1>Tudo certo!</h1>';
						swalHtml += '<p class="mb-0 text-lowercase">O cadastro foi <strong class="text-danger">desativado</strong></p>';

						var swalConfirmButtonText = 'Obrigado <i class="fa-light fa-arrow-right ml-1"></i>';
						var swalCancelButtonText 	= ''
						var swalIsConfirmed 			= 0;
						var swalResult 						= '';

						sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
					}

					if(status == 1) {
						var swalHtml = "";
						swalHtml += '<i class="fa-light fa-check text-navy text-12 mb-3"></i><br/>';
						swalHtml += '<h1>Tudo certo!</h1>';
						swalHtml += '<p class="mb-0 text-lowercase">O cadastro foi <strong class="text-navy">ativado</strong></p>';

						var swalConfirmButtonText = 'Obrigado <i class="fa-light fa-arrow-right ml-1"></i>';
						var swalCancelButtonText 	= ''
						var swalIsConfirmed 			= 0;
						var swalResult 						= '';

						sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
					}
				});
			});
		}
	});
}

changeRegisterStatus();

/*
* INPUT ::: charCounter
*/

$(".character-count").simpleTxtCounter({
	maxLength: 140,
	countText:'Contador: ',
	countElem:'<div class="character-counter"></div>'
});

/*
* INPUT ::: CodeMirror
*/

if($('.codemirror').length) {
	var editor = CodeMirror.fromTextArea($('.codemirror')[0], {
		lineNumbers: 			true,
		styleActiveLine: 	true,
		matchBrackets: 		true
	});
}

// ---------------------------------------------------------------------------------------------]
// -----------------------------------------------------------------------------------[ BUTTONS ]
// ---------------------------------------------------------------------------------------------]

/*
* BTN ::: Add extra content
*/

function btnExtraContent() {
	$('.btn-extra').on('click', function(event) {
		event.preventDefault();

		var mod       = $(this).data('mod');
		var view      = $(this).data('view');
		var index     = $(this).data('index');

		var numItems  = $('.row-extra-content').length;
		numItems      = numItems + 1;

		$('#totalExtraContent').val(numItems);

		$.ajax({
			type: "POST",
			url: BASE_URL + "DH_ajaxExtraContent",
			data: {
				csrf_token: CSRF_TOKEN,
				mod:        mod,
				view:       view,
				index:      index,
				num:        numItems
			}
		})
		.done(function( result ) {
			$('.div-extra-content').append(result);
			btnImagePreview();
		});
	});
}

btnExtraContent();

/*
* BTN ::: Remove extra content
*/

function delExtraContent(key) {
	$('.row-extra-content-' + key).remove();
	return true;
}

delExtraContent();

/*
* BTN ::: Add extra content with keys
*/

function btnExtraWithKeys(key, mod, view, index) {
	var numItemsKey   = $('.div-extra-content-with-keys-' + key + ' .row-with-keys').length;
	numItemsKey       = numItemsKey + 1;

	$.ajax({
		type: "POST",
		url: BASE_URL + "inicial/MYC_ajaxExtraContent",
		data: {
			csrf_token: CSRF_TOKEN,
			mod:                  mod,
			view:                 view,
			index:                index,
			num:                  key,
			numKey:               numItemsKey
		}
	})
	.done(function( result ) {
		$('.div-extra-content-with-keys-' + key).append(result);
		btnImagePreview();
	});
}

function delExtraWithKeys(key) {
	$('.row-extra-content-' + key).remove();
}

/*
* BTN ::: Excluir
*/

function btnExcluir() {
	$(".btn-excluir").click(function(e) {
		e.preventDefault();
		url = $(this).attr('href');

		var swalHtml = "";
		swalHtml += '<i class="fa-light fa-triangle-exclamation text-danger text-12 mb-3"></i><br/>';
		swalHtml += '<h1>Confirmar exclusão?</h1>';
		swalHtml += '<p class="mb-0 text-lowercase">não será possível restaurar os dados depois</p>';

		var swalConfirmButtonText = 'Confirmar exclusão';
		var swalCancelButtonText 	= 'Cancelar ação';
		var swalIsConfirmed 			= 1;
		var swalResult 						= 'location = url;';

		sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
	});
}

btnExcluir();

function funBtnDelete(a) {
	var url = $(a).data('href');

	var swalHtml = "";
	swalHtml += '<i class="fa-light fa-triangle-exclamation text-danger text-12 mb-3"></i><br/>';
	swalHtml += '<h1>Confirmar exclusão?</h1>';
	swalHtml += '<p class="mb-0 text-lowercase">não será possível restaurar os dados depois</p>';

	var swalConfirmButtonText = 'Confirmar exclusão';
	var swalCancelButtonText 	= 'Cancelar ação';

	Swal.fire({ 
		title:              '',
		html:               swalHtml,
		confirmButtonText:  swalConfirmButtonText,
		cancelButtonText:   swalCancelButtonText,
		backdrop:  					true,
		allowOutsideClick:  true,
		allowEscapeKey:     true,
		showCancelButton: 	true,
		customClass: {
			popup: 		'w-100',
			actions: 	'p-2 pt-3 m-0',
		},
		showClass: {
			popup: 'animated bounceInUp faster'
		},
		hideClass: {
			popup: 'animated bounceOutDown faster'
		},
		position: 'bottom'
	})
	.then((result) => { 
		if (result.isConfirmed) { 
			window.location.href = url;
		}
		else {
		}
	});
}

/*
* BTN ::: Com confirmação
*/

function btnWithConfirm() {
	$(".btn-with-confirm").click(function(e) {
		e.preventDefault();
		
		url = $(this).attr('href');
		
		var text 	= $(this).data('text'); 
		var icon 	= $(this).data('icon'); 

		var swalHtml = "";
		swalHtml += '<i class="' + icon + '"></i><br/>';
		swalHtml += '<h1>' + text + '</h1>';

		var swalConfirmButtonText = 'Confirmar';
		var swalCancelButtonText 	= 'Cancelar ação';
		var swalIsConfirmed 			= 1;
		var swalResult 						= 'location = url;';

		sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
	});
}

btnWithConfirm();

/*
* BTN ::: Recuperar senha
*/

$('.btn-recupera-senha').on('click', function(event) {
	Swal.fire({
		title: 	'',
		html: 	'<p class="text-center mb-0">Informe seu e-mail</p>',
		input: 	'email',
		inputAttributes: {
			autocapitalize: 'off'
		},
		showCancelButton: 	true,
		confirmButtonText: 	'Solicitar senha',
		cancelButtonText: 	'Cancelar',
		validationMessage: 	'Endereço de e-mail invalido',
		customClass: {
			popup: 		'w-100',
			actions: 	'p-2 pt-3 m-0',
			input: 		'col-6 input-recupera-senha',
		},
		showClass: {
			popup: 'animated bounceInUp faster'
		},
		hideClass: {
			popup: 'animated bounceOutDown faster'
		},
		position: 'bottom'
	})
	.then((result) => {
		if (result.isConfirmed) {
			var email = result.value;

			$.ajax({
				dataType: 'json',
				type: 		"POST",
				url: 			BASE_URL + "login/recuperaSenha",
				data: {
					csrf_token: CSRF_TOKEN,
					email: 			email
				}
			})
			.done(function( result ) {
				if(result.error == '0') {
					Swal.fire({ 
						icon: 'success',
						title:              '',
						html:               'Tudo certo, em breve entraremos em contato pelo e-mail informado.',
						confirmButtonText:  'Ok',
						allowOutsideClick:  true,
						allowEscapeKey:     true,
						customClass: {
							popup: 					'w-100',
							actions: 				'p-2 pt-3 m-0'
						},
						showClass: {
							popup: 'animated bounceInUp faster'
						},
						hideClass: {
							popup: 'animated bounceOutDown faster'
						},
						position: 'bottom'
					})
				}
				else {
					Swal.fire({ 
						icon: 'warning',
						title:              '',
						html:               result.message,
						confirmButtonText:  'Ok',
						allowOutsideClick:  true,
						allowEscapeKey:     true,
						customClass: {
							popup: 					'w-100',
							actions: 				'p-2 pt-3 m-0'
						},
						showClass: {
							popup: 'animated bounceInUp faster'
						},
						hideClass: {
							popup: 'animated bounceOutDown faster'
						},
						position: 'bottom'
					})
				}
			});
		}
	})
})

/*
* BTN ::: Deletar arquivo
*/

$('.delete-file').on('click', function(event) {
	event.preventDefault();
	var swalHtml = "";
	swalHtml += '<i class="fal fa-question-circle text-danger text-12 mb-3"></i><br/>';
	swalHtml += '<h1>Confirmar exclusão?</h1>';
	swalHtml += '<p class="mb-0 text-lowercase">não será possível restaurar o arquivo depois</p>';

	var arquivo = $(this).data('arquivo');

	Swal.fire({ 
		title:              '',
		html:               swalHtml,
		confirmButtonText:  'Sim, desejo excluir',
		cancelButtonText:   'Não, cancelar ação',
		allowOutsideClick:  true,
		allowEscapeKey:     true,
		showCancelButton: 	true,
		customClass: {
			popup: 		'w-100',
			actions: 	'p-2 pt-3 m-0',
		},
		showClass: {
			popup: 'animated bounceInUp faster'
		},
		hideClass: {
			popup: 'animated bounceOutDown faster'
		},
		position: 'bottom'
	})
	.then((result) => { 
		if (result.isConfirmed) {
			$.ajax({
				dataType: 'json',
				type: "POST",
				url: BASE_URL + "arquivos/deletar",
				data: {
					csrf_token: CSRF_TOKEN,
					arquivo: arquivo,
				}
			})
			.done(function( result ) {
				if(result.response == 'success') {
					var swalHtml = "";
					swalHtml += '<i class="fa-light fa-check-circle text-navy text-12 mb-3"></i><br/>';
					swalHtml += result.successMessage

					var swalConfirmButtonText = 'Obrigado <i class="fa-light fa-arrow-right ml-1"></i>';
					var swalCancelButtonText 	= ''
					var swalIsConfirmed 			= 0;
					var swalResult 						= 'document.location.reload(true)';

					sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
				}
				else {
					var swalHtml = "";
					swalHtml += '<i class="fa-light fa-xmark-circle text-navy text-12 mb-3"></i><br/>';
					swalHtml += result.errorMessage

					var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
					var swalCancelButtonText 	= ''
					var swalIsConfirmed 			= 0;
					var swalResult 						= '';

					sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
				}
			})
		}
	});
});

/*
* BTN ::: Batch actions
*/

var btnBatchActions = $('.btn-batch-actions');

if(btnBatchActions.length) {
	btnBatchActions.on('click', function(event) {
		event.preventDefault();
		
		var action 	= $(this).data('action');
		var table 	= $(this).data('table');
		var upload 	= $(this).data('upload');
		var ids 		= [];

		var swalHtml = "";
		swalHtml += '<i class="fa-light fa-triangle-exclamation text-danger text-12 mb-3"></i><br/>';
		swalHtml += '<h1>Confirmar exclusão?</h1>';
		swalHtml += '<p class="mb-0 text-lowercase">não será possível restaurar os dados depois</p>';

		Swal.fire({ 
			title:              '',
			html:               swalHtml,
			confirmButtonText:  'Sim, desejo excluir',
			cancelButtonText:   'Não, cancelar ação',
			allowOutsideClick:  true,
			allowEscapeKey:     true,
			showCancelButton: 	true,
			customClass: {
				popup: 		'w-100',
				actions: 	'p-2 pt-3 m-0',
			},
			showClass: {
				popup: 'animated bounceInUp faster'
			},
			hideClass: {
				popup: 'animated bounceOutDown faster'
			},
			position: 'bottom'
		})
		.then((result) => { 
			if (result.isConfirmed) {
				$.each($('.check-for-actions'), function(index, val) {
					if(val.checked == true) {
						ids.push(val.value);
					}
				});

				$.ajax({
					url: 			BASE_URL + "DH_ajaxBatchAction",
					type: 		'POST',
					dataType: 'json',
					data: {
						csrf_token: CSRF_TOKEN,
						table: 			table,
						ids: 				ids,
						upload:			upload
					},
					beforeSend: function() {
						console.log("DH_ajaxBatchAction: Iniciada.");
						$('#spiner').show();
					}
				})
				.done(function() {
					console.log("DH_ajaxBatchAction: Realizada.");
				})
				.fail(function() {
					console.log("DH_ajaxBatchAction: Erro.");
				})
				.always(function() {
					console.log("DH_ajaxBatchAction: Finalizada.");
					location.reload();
				});
			} 
			else if (result.isDenied) {
			}
			else {
			}
		});
	});
}

/*
* BTN ::: Batch check all
*/

var inputBatchCheckall = $('.check-all-for-actions');

if(inputBatchCheckall.length) {
	inputBatchCheckall.on('click', function(event) {
		event.preventDefault();

		$.each($('.check-for-actions'), function(index, val) {
			if(val.checked == true) {
				$(this).prop('checked', false);
			}
			else {
				$(this).prop('checked', true);
			}
		});
	});
}

/*
* BTN ::: Send CMS access data
*/

var btnUserSendAccess 		 = $('.btn-user-send-access');
var btnUserSendAccessClass = '.btn-user-send-access-';

if(btnUserSendAccess.length > 0) {

	var btnCurrentHTML = btnUserSendAccess.html();
	var btnLoadingHTML = "<i class='fa-duotone fa-spinner-third fa-spin'></i> Enviando...";

	btnUserSendAccess.on('click', function(event) {
		event.preventDefault();
		
		var userID = $(this).data('id');

		var jqXHR = $.ajax({
			type: 		'POST',
			dataType: "json",
			url: 			BASE_URL + "/DH_ajaxSendUserAccessData",
			data: { 
				csrf_token: 	CSRF_TOKEN,
				id: 					userID
			},
			beforeSend: function() {
				$(btnUserSendAccessClass + userID).html('').html(btnLoadingHTML);
			}
		});

		jqXHR.done(function( rst ) {
			var swalHtml = "";
			swalHtml += '<i class="fa-light fa-check text-navy text-12 mb-3"></i><br/>';
			swalHtml += '<h1>Tudo certo!</h1>';
			swalHtml += rst.successMessage;

			var swalConfirmButtonText = 'Obrigado <i class="fa-light fa-arrow-right ml-1"></i>';
			var swalCancelButtonText 	= ''
			var swalIsConfirmed 			= 0;
			var swalResult 						= '';

			sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
		});

		jqXHR.fail(function() {
		});

		jqXHR.always(function() {
			$(btnUserSendAccessClass + userID).html('').html(btnCurrentHTML);
		});

	});
}

/*
* BTN ::: Copy/Paste
*/

function funBtnCopyLink(btn) {
	var link 			= btn.data('link');
	var tempInput = $('<input>');

	tempInput.val(link);

	$('body').append(tempInput);

	tempInput.select();

	document.execCommand('copy');

	tempInput.remove();

	var toastIcon			= '<i class="fa-light fa-check me-1"></i>';
	var toastTitle		= 'Tudo certo!';
	var toastMessage	= 'O link foi copiado para a área de transferência!';
	var toastType			= 'toast-success';
	var toastDelay		= 2500;
	var toastAutohide	= true;

	toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);
}

/*
* BTN  ::: Ajusta os botões de ações do rodape
*/

if($('.bgk-btn-root').length) {
	var size = $('.bgk-btn-root').width();
	$('.bkg-btn').css('right', 'calc(64px + '+size+'px)');
};

/*
* BTN ::: Limpa registros da auditoria
*/

$('.btn-limpa-auditoria').on('click', function(event) {
	$.ajax({
		dataType: 'json',
		type: "POST",
		url: BASE_URL + "DH_ajaxDeletaAuditoria",
		data: {
			csrf_token: CSRF_TOKEN,
			modulo: 		CLASSE,
			item: 			ID_ITEM
		}
	})
	.done(function( result ) {
		$('#spiner').hide();

		var swalHtml = "";
		swalHtml += '<i class="fa-light fa-check text-navy text-12 mb-3"></i><br/>';
		swalHtml += '<h1>Tudo certo!</h1>';
		swalHtml += '<p class="mb-0 text-lowercase">Os registros de ações deste módulo, foram deletados</p>';

		var swalConfirmButtonText = 'Obrigado <i class="fa-light fa-arrow-right ml-1"></i>';
		var swalCancelButtonText 	= ''
		var swalIsConfirmed 			= 1;
		var swalResult 						= 'document.location.reload(true)';

		sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
	})
});

// ---------------------------------------------------------------------------------------------]
// ------------------------------------------------------------------------------------[ OTHERS ]
// ---------------------------------------------------------------------------------------------]

/*
* HACK ::: Fecha o carregamento ao clicar com o botão direito do mouse
*/

$(document).on("contextmenu", "#spiner", function(e) {
	$('#spiner').hide();
	return false;
});

// ---------------------------------------------------------------------------------------------]
// -----------------------------------------------------------------------------------[ WEBMAIL ]
// ---------------------------------------------------------------------------------------------]

/*
* WEBMAIL ::: Atualizar e-mails
*/

function atualizaEmails() {
	$('#verificaEmails').removeClass('d-none');
	$('.atualizaEmails').addClass('fa-spin');
	var currentMailbox = $('#currentMailbox').val();
	$.ajax({
		dataType: 'json',
		type: "POST",
		url: BASE_URL + "webmail/imapVerifyNewMail",
		data: {
			csrf_token: CSRF_TOKEN,
			currentMailbox: currentMailbox
		}
	})
	.done(function( result ) {
		$('#verificaEmails').addClass('d-none');
		$('.atualizaEmails').removeClass('fa-spin');
		if(result != '') {
			var dataTable = $('.dataTables-email').DataTable();
			$.each(result, function(key, valor) {
				dataTable.row.add([
					'<input type="checkbox" class="i-checks mail-change-seen" value="'+valor.uid+'">',
					'<a href="'+BASE_URL+'webmail/ver-email/'+valor.msgno+'" class="text-black mail-list-style fw-bold"><i class="fa-solid fa-circle-small text-warning pe-2" title="Não lido"></i>'+valor.from+'</a>',
					'<a href="'+BASE_URL+'webmail/ver-email/'+valor.msgno+'" class="text-black mail-list-style fw-bold">'+valor.subject+'</a>',
					'<span class="fw-bold">'+valor.date+'</spam>',
					]).draw(true);
			});
			playAlert();
		}
	});
}

/*
* WEBMAIL ::: Atualizar e-mails automaticamente apos 5 minutos
*/

if($('#verificaEmails').length) {
	setInterval(() => { atualizaEmails() }, 300000);
}

/*
* WEBMAIL ::: Marcar e-mails como lido/não lido
*/

function changeSeenWebmail() {
	var uids = '';
	$.each($('.mail-change-seen'), function(key, value) {
		if($(value).prop('checked')) {
			uids = uids + value.value + ',';
		}
	});

	var currentMailbox = $('#currentMailbox').val();

	$.ajax({
		dataType: 'json',
		type: "POST",
		url: BASE_URL + "webmail/imapChangeReadStatus",
		data: {
			csrf_token: CSRF_TOKEN,
			uids: uids,
			currentMailbox: currentMailbox
		}
	}).done(function( result ) {
		window.location.reload(true);
	});
}

/*
* WEBMAIL ::: Selecionar todos os checkbox do webmail
*/

function checkAllMail() {
	$('.check-all-mails').on('ifChecked', function(event){
		$('.mail-change-seen').iCheck('check');
	});

	$('.check-all-mails').on('ifUnchecked', function(event){
		$('.mail-change-seen').iCheck('uncheck');
	});
}

/*
* WEBMAIL ::: Alterar status de sinalizado webmail
*/

function changeFlagged() {
	var uids = '';
	$.each($('.mail-change-seen'), function(key, value) {
		if($(value).prop('checked')) {
			uids = uids + value.value + ',';
		}
	});

	var currentMailbox = $('#currentMailbox').val();

	$.ajax({
		dataType: 'json',
		type: "POST",
		url: BASE_URL + "webmail/imapChangeFlagged",
		data: {
			csrf_token: CSRF_TOKEN,
			uids: uids,
			currentMailbox: currentMailbox
		}
	}).done(function( result ) {
		window.location.reload(true);
	});
}

/*
* WEBMAIL ::: Mover arquivos
*/

$('.btn-move-mails').on('click', function(event) {
	event.preventDefault();

	var folder = $(this).attr('data-folder');
	var currentMailbox = $('#currentMailbox').val();

	var uids = '';
	$.each($('.mail-change-seen'), function(key, value) {
		if($(value).prop('checked')) {
			uids = uids + value.value + ',';
		}
	});

	$.ajax({
		dataType: 'json',
		type: "POST",
		url: BASE_URL + "webmail/imapMoveMail",
		data: {
			csrf_token: CSRF_TOKEN,
			uids: uids,
			folder: folder,
			currentMailbox: currentMailbox
		}
	}).done(function( result ) {
		window.location.reload(true);
	});
});

$('.mail-change-folder').on('click', function(event) {
	$('.btn-mail-actions-change').attr('data-folder', $(this).val());
});

/*
* WEBMAIL ::: Adicionar campos de envio
*/

function addMailCopy(tipo) {
	var nome = 'email_cc';
	var titulo = 'Cópia';

	if(tipo == 'bcc') {
		nome = 'email_bcc';
		titulo = 'Cópia oculta';
	}

	var date = new Date();

	var h = date.getHours();
	var m = date.getMinutes();
	var s = date.getSeconds();
	var ms = date.getMilliseconds();

	var html = '<div class="col-12 '+h+m+s+ms+'">';
	html = html + '<label for="'+nome+'" class="form-label">'+titulo+':</label>';
	html = html + '<div class="input-group mb-3">';
	html = html + '<span class="input-group-text">';
	html = html + '<i class="fa-light fa-at"></i>';
	html = html + '</span>';
	html = html + '<input type="email" class="form-control" aria-label="'+nome+'" aria-describedby="'+nome+'" data-rule-required="true" data-msg-required="Campo obrigatório." id="'+nome+'" name="'+nome+'[]">';
	html = html + '<div class="input-group-append" onclick="removeInputWebmail('+h+m+s+ms+');">';
	html = html + '<span class="input-group-text h-100 border-danger border-start">';
	html = html + '<i class="fa-light fa-xmark-large text-danger"></i>';
	html = html + '</span>';
	html = html + '</div>';
	html = html + '</div>';
	html = html + '</div>';

	if(tipo == 'bcc' && $('#email_bcc').length) {
		$('#email_bcc').focus();
	}else {
		$('.append-mail-input').append(html);
	}
}

/*
* WEBMAIL ::: Remove campos de envio
*/

function removeInputWebmail(element) {
	$('.'+element).remove();
}

/*
* WEBMAIL ::: Imprimir e-mail
*/

function printWebmail() {
	var data = document.getElementById("printData").innerHTML;
	var de = document.getElementById("printDe").innerHTML;
	var para = document.getElementById("printPara").innerHTML;
	var assunto = document.getElementById("printAssunto").innerHTML;
	var mensagem = document.getElementById("printBody").innerHTML;

	var windows = window.open('', '');
	windows.document.write('<html>');
	windows.document.write('<body > <h1>'+assunto+'<br>');
	windows.document.write('<h4>'+de+'<h4>');
	windows.document.write('<h4>'+para+'<h4>');
	windows.document.write('<h4>Data do envio: '+data+'<h4>');
	windows.document.write('<hr>');
	windows.document.write(mensagem);
	windows.document.write('</body></html>');
	windows.document.close();
	windows.print();
}

// ---------------------------------------------------------------------------------------------]
// ---------------------------------------------------------------------------------------[ 2FA ]
// ---------------------------------------------------------------------------------------------]


$('.btn-2fa-back').on('click', function(e) {
	$('.cont-form-login').css('transform', 'translateX(0)');
	$('.cont-form-login-2fa').css('transform', 'translate(100%, -100%)');
});

$('.btn-2fa').on('click', function(event) {
	var codigo = '';
	$.each($('.input-2fa'), function(key, value) {
		codigo = codigo + value.value;
	});

	var data_twofa = $('#data_twofa').val();

	$.ajax({
		method: "POST",
		dataType: "json",
		url: BASE_URL + "login/autenticar",
		data: { 
			csrf_token: CSRF_TOKEN,
			codigo: codigo,
			data_twofa: data_twofa
		},
		beforeSend: function( xhr ) {
			$('.btn-2fa').html("<i class='fa-duotone fa-spinner-third fa-spin'></i> Verificando...");
		}
	})
	.done(function( result ) {
		$('.btn-2fa').html("Validar");

		if (result.response == 'success') {
			var swalHtml = "";
			swalHtml += '<i class="fa-light fa-check text-navy text-12 mb-3"></i><br/>';
			swalHtml += result.successMessage;

			var swalConfirmButtonText = 'Acessar painel <i class="fa-light fa-arrow-right ml-1"></i>';
			var swalCancelButtonText 	= ''
			var swalIsConfirmed 			= 1;
			var swalResult 						= 'window.location.href = BASE_URL + "pagina-inicial";';

			sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
			return;
		} 
		else if (result.response == 'error') {
			var swalHtml = "";
			swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
			swalHtml += result.errorMessage + "<br/>";
			swalHtml += result.log;

			var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
			var swalCancelButtonText 	= ''
			var swalIsConfirmed 			= 0;
			var swalResult 						= '';

			sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
			return;
		} 
		else {
			var swalHtml = "";
			swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
			swalHtml += result.errorMessage + "<br/>";

			var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
			var swalCancelButtonText 	= ''
			var swalIsConfirmed 			= 0;
			var swalResult 						= '';

			sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
			return;
		}
	})
});

/*
* 2FA ::: Input
*/

$('.input-2fa').on('keyup', function(event) {
	var key = $(this).data('key');

	if (event.key.length === 1 || event.key == 'Backspace') {
		if(event.key == 'Backspace') {
			if(key > 0) {
				$('.input-2fa-'+(key - 1)).focus().val('');
				$('.btn-2fa').attr('disabled', true);
			}
		}
		else {
			if(key < 6) {
				$('.input-2fa-'+(key+1)).focus().val('');
			}
			else {
				$('.btn-2fa').attr('disabled', false).click();
			}
		}
	}
});

/*
* 2FA ::: Gerar token mobile
*/

$('.generate-qr-2fa').on('click', function(event) {
	var dados = $(this).data('dados');

	$.ajax({
		dataType: 'json',
		type: 		"POST",
		url: 			BASE_URL + "cadastro-de-usuarios/gerar-2fa",
		data: {
			csrf_token: CSRF_TOKEN,
			dados: 			dados
		}
	})
	.done(function( result ) {
		if(result.error == '0') {
			html = '<h3 class="text-center">Escaneie o QR Code abaixo utilizando o Google Authenticator</h3>';
			html = html + result.qrcode+'<br>';
			html = html + '<p class="text-center mb-0">Apos escanear o QR Code clique no botão abaixo.</p>';

			Swal.fire({ 
				title: 							'',
				html: 							html,
				confirmButtonText:  'OK <i class="fas fa-angle-right"></i>',
				allowOutsideClick:  false,
				allowEscapeKey:     false,
				showCancelButton: 	false,
				customClass: {
					popup: 		'',
					actions: 	'p-2 pt-3 m-0',
				},
				showClass: {
					popup: 'animated bounceInUp faster'
				},
				hideClass: {
					popup: 'animated bounceOutDown faster'
				},
			})
			.then((result) => { 
				Swal.fire({ 
					title: 	'',
					html: '<p class="text-center mb-0">Digite no campo abaixo o codigo exibido no Google Authenticator</p>',
					input: 'text',
					inputAttributes: {
						autocapitalize: 'off',
						maxlength: 6
					},
					confirmButtonText:  'Validar <i class="fas fa-angle-right"></i>',
					allowOutsideClick:  false,
					allowEscapeKey:     false,
					showCancelButton: 	false,
					customClass: {
						popup: 		'',
						actions: 	'p-2 pt-3 m-0',
						input: 'text-center'
					},
					showClass: {
						popup: 'animated bounceInUp faster'
					},
					hideClass: {
						popup: 'animated bounceOutDown faster'
					},
				})
				.then((result) => {
					var codigo = result.value;

					$.ajax({
						dataType: 'json',
						type: "POST",
						url: BASE_URL + "cadastro-de-usuarios/valida-2fa",
						data: {
							csrf_token: CSRF_TOKEN,
							dados: dados,
							codigo: codigo
						}
					})
					.done(function( result ) {
						if(result.error == '0') {
							var swalHtml = "";
							swalHtml += '<i class="fa-light fa-check text-navy text-12 mb-3"></i><br/>';
							swalHtml += result.mensagem;

							var swalConfirmButtonText = 'Acessar painel <i class="fa-light fa-arrow-right ml-1"></i>';
							var swalCancelButtonText 	= ''
							var swalIsConfirmed 			= 1;
							var swalResult 						= 'document.location.reload(true)';

							sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
						}
						else {
							var swalHtml = "";
							swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
							swalHtml += result.mensagem;

							var swalConfirmButtonText = 'Vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
							var swalCancelButtonText 	= ''
							var swalIsConfirmed 			= 0;
							var swalResult 						= '';

							sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
						}
					});
				})
			});
		}
		else {
		}
	})
});

// ---------------------------------------------------------------------------------------------]
// --------------------------------------------------------------------------------[ PAGINATION ]
// ---------------------------------------------------------------------------------------------]

var paginationButton 	= $('.btn-pagination');
var paginationFilter 	= $('.btn-pagination-filter');
var paginationContent = $('.pagination-content');
var paginationLoader 	= $('.pagination-loader');
var paginationPages 	= $('.pagination-pages');

if(paginationButton.length > 0 || paginationFilter.length > 0) {
	function buttonPagination( btn ) {
		var page 						= btn.data('page');
		var limit 					= btn.data('limit');
		var offset 					= btn.data('offset');
		var pagination			= btn.data('pagination');
		
		var mod 						= btn.data('module');
		var cla 						= btn.data('class');
		var fun 						= btn.data('function');
		var index						= btn.data('index');
		var variable				= btn.data('variable');
		var api							= btn.data('api');
		var filterStatus		= btn.data('filter-status');
		var filterClass 		= btn.data('filter-class');

		var viewContent 	 	= btn.data('view-content');
		var viewPagination 	= btn.data('view-pagination');

		paginationContent.html('');
		paginationLoader.show();

		if(filterStatus == 1) {
			var filterInputs = new Array();
			var obj 				 = {};

			$( '.' + filterClass ).each(function(index, e) {
				obj[$(this).attr("name")] = $(this).val();
			});

			filterInputs = obj;
		}
		else {
			filterInputs = null;
		}

		var jqXHR = $.ajax({
			dataType: 'json',
			type: 		"POST",
			url: 			BASE_URL + "DH_pagination",
			data: {
				csrf_token: CSRF_TOKEN,
				page: 						page,
				limit: 						limit,
				offset: 					offset,
				pagination:				pagination,
				mod: 							mod,
				cla: 							cla,
				fun: 							fun,
				index: 						index,
				variable:					variable,
				api:							api,
				filterStatus:			filterStatus,
				filterInputs:			filterInputs,
				viewContent: 			viewContent,
				viewPagination: 	viewPagination
			},
			beforeSend: function( xhr ) {
				// scrollToElement('#wrapper', 500);
			}
		});

		jqXHR.done(function( result ) {
			paginationLoader.hide();
			paginationContent.html('').append(result.content);
			paginationPages.html('').append(result.pagination);
			console.log("Log: A função DH_pagination() foi realizada.");
			changeRegisterStatus();
		});

		jqXHR.fail(function() {
			console.log("Log: A função DH_pagination() gerou um ou mais erros.");
		});

		jqXHR.always(function() {
			console.log("Log: A função DH_pagination() foi finalizada.");
		});
	}
}

// ---------------------------------------------------------------------------------------------]
// --------------------------------------------------------------------------------[ VARIATIONS ]
// ---------------------------------------------------------------------------------------------]

$('.btn-add-variation').on('click', function() {
	var formData 						= new FormData();
	var selectedColorId 		= $('#id_cor').val();
	var selectedColorTitle 	= $('#id_cor').find(":selected").data("titulo");
	var selectedColorHex 		= $('#id_cor').find(":selected").data("hex");
	var selectedFiles 			= $('#imagens')[0].files;
	var CSRF_TOKEN 					= $('input[name="csrf_token"]').val();

	if (selectedColorId == '' || selectedColorId === null || selectedColorId === undefined) {
		var swalHtml = "";
		swalHtml += '<i class="fa-light fa-hand text-danger text-12 mb-3"></i><br/>';
		swalHtml += '<h1>Ops!</h1>';
		swalHtml += '<p class="mb-0 text-lowercase">É preciso selecionar uma das cores.</p>';

		var swalConfirmButtonText = 'Certo, vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
		var swalCancelButtonText 	= ''
		var swalIsConfirmed 			= 0;
		var swalResult 						= '';

		sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
		return false;
	}

	if (selectedFiles.length === 0) {
		var swalHtml = "";
		swalHtml += '<i class="fa-light fa-hand text-danger text-12 mb-3"></i><br/>';
		swalHtml += '<h1>Ops!</h1>';
		swalHtml += '<p class="mb-0 text-lowercase">Nenhuma imagem foi selecionada.</p>';

		var swalConfirmButtonText = 'Certo, vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
		var swalCancelButtonText 	= ''
		var swalIsConfirmed 			= 0;
		var swalResult 						= '';

		sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
		return false;
	}

	formData.append('id', $(this).data('id'));
	formData.append('modulo', $(this).data('modulo'));
	formData.append('tabela', $(this).data('tabela'));
	formData.append('pasta', $(this).data('pasta'));
	formData.append('subpasta', $(this).data('subpasta'));
	formData.append('index', $(this).data('index'));

	formData.append('id_cor', selectedColorId);
	formData.append('titulo_cor', selectedColorTitle);
	formData.append('hex_cor', selectedColorHex);
	formData.append('csrf_token', CSRF_TOKEN);

	for (var i = 0; i < selectedFiles.length; i++) {
		formData.append('imagens[' + i + '][name]', selectedFiles[i].name);
		formData.append('imagens[' + i + '][full_path]', selectedFiles[i].name);
		formData.append('imagens[' + i + '][type]', selectedFiles[i].type);
		formData.append('imagens[' + i + '][tmp_name]', selectedFiles[i].tmp_name);
		formData.append('imagens[' + i + '][error]', selectedFiles[i].error);
		formData.append('imagens[' + i + '][size]', selectedFiles[i].size);
		formData.append('imagens[' + i + '][file]', selectedFiles[i]); 
	}

	var jqXHR = $.ajax({
		dataType: 'json',
		type: 		"POST",
		url: 			BASE_URL + "DH_productsAddVariations",
		data: 		formData,
		cache: 				false,
		processData: 	false,
		contentType: 	false,
		beforeSend: function( xhr ) {
			$('#spiner').show();
		}
	});

	jqXHR.done(function( result ) {
		console.log("Log: A função DH_productsAddVariations() gerou um ou mais resultados.");

		$('#id_cor').val('');
		$('#imagens').val('');

		document.location.reload(true);
	});

	jqXHR.fail(function() {
		console.log("Log: A função DH_productsAddVariations() gerou um ou mais erros.");
	});

	jqXHR.always(function() {
		console.log("Log: A função DH_productsAddVariations() foi finalizada.");
	});
});

$('.btn-rem-variation').on('click', function(event) {
	event.preventDefault();

	var cadastroId 		= $(this).data("id-cadastro");
	var cadastroIdCor = $(this).data("id-cor");

	var jqXHR = $.ajax({
		dataType: 'json',
		type: 		"POST",
		url: 			BASE_URL + "DH_productsRemVariations",
		data: {
			csrf_token: 		CSRF_TOKEN,
			cadastroId:			cadastroId,
			cadastroIdCor:	cadastroIdCor
		},
		beforeSend: function( xhr ) {
			$('#spiner').show();
		}
	});

	jqXHR.done(function( result ) {
		console.log("Log: A função DH_productsRemVariations() gerou um ou mais resultados.");

		$('#spiner').hide();

		var swalHtml = "";
		swalHtml += '<i class="fa-light fa-check text-navy text-12 mb-3"></i><br/>';
		swalHtml += '<h1>Tudo certo!</h1>';
		swalHtml += '<p class="mb-0 text-lowercase">Os registros foram atualizados.</p>';

		var swalConfirmButtonText = 'Obrigado <i class="fa-light fa-arrow-right ml-1"></i>';
		var swalCancelButtonText 	= ''
		var swalIsConfirmed 			= 1;
		var swalResult 						= 'document.location.reload(true)';

		sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
	});

	jqXHR.fail(function() {
		console.log("Log: A função DH_productsRemVariations() gerou um ou mais erros.");
	});

	jqXHR.always(function() {
		console.log("Log: A função DH_productsRemVariations() foi finalizada.");
	});
});

// ---------------------------------------------------------------------------------------------]
// -----------------------------------------------------------------------------------[ MODULES ]
// ---------------------------------------------------------------------------------------------]

$('.btn-add-modules').on('click', function() {
	var formData 						= new FormData();
	var selectedColorId 		= $('#modulo_id_cor').val();
	var selectedColorTitle 	= $('#modulo_id_cor').find(":selected").data("titulo");
	var selectedTitle 			= $('#modulo_titulo').val();
	var CSRF_TOKEN 					= $('input[name="csrf_token"]').val();

	if (selectedColorId == '' || selectedColorId === null || selectedColorId === undefined) {
		var swalHtml = "";
		swalHtml += '<i class="fa-light fa-hand text-danger text-12 mb-3"></i><br/>';
		swalHtml += '<h1>Ops!</h1>';
		swalHtml += '<p class="mb-0 text-lowercase">É preciso selecionar uma das cores.</p>';

		var swalConfirmButtonText = 'Certo, vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
		var swalCancelButtonText 	= ''
		var swalIsConfirmed 			= 0;
		var swalResult 						= '';

		sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
		return false;
	}

	formData.append('id', $(this).data('id'));
	formData.append('modulo', $(this).data('modulo'));
	formData.append('tabela', $(this).data('tabela'));
	formData.append('pasta', $(this).data('pasta'));
	formData.append('subpasta', $(this).data('subpasta'));
	formData.append('index', $(this).data('index'));

	formData.append('modulo_id_cor', selectedColorId);
	formData.append('modulo_titulo_cor', selectedColorTitle);
	formData.append('modulo_titulo', selectedTitle);
	formData.append('csrf_token', CSRF_TOKEN);

	var jqXHR = $.ajax({
		dataType: 'json',
		type: 		"POST",
		url: 			BASE_URL + "DH_productsAddModuules",
		data: 		formData,
		cache: false,
		processData: false,
		contentType: false,
		beforeSend: function( xhr ) {
			$('#spiner').show();
		}
	});

	jqXHR.done(function( result ) {
		console.log("Log: A função DH_productsAddModuules() gerou um ou mais resultados.");

		$('#modulo_id_cor').val('');
		$('#modulos_imagens').val('');

		document.location.reload(true)
	});

	jqXHR.fail(function() {
		console.log("Log: A função DH_productsAddVariations() gerou um ou mais erros.");
	});

	jqXHR.always(function() {
		console.log("Log: A função DH_productsAddVariations() foi finalizada.");
	});
});

$('.btn-rem-modules').on('click', function(event) {
	event.preventDefault();

	var cadastroId		= $(this).data("id-cadastro");
	var cadastroIdCor	= $(this).data("id-cor");
	var cadastroKey 	= $(this).data("key-modulo");

	var jqXHR = $.ajax({
		dataType: 'json',
		type: 		"POST",
		url: 			BASE_URL + "DH_productsRemModule",
		data: {
			csrf_token: 		CSRF_TOKEN,
			cadastroId:			cadastroId,
			cadastroIdCor:	cadastroIdCor,
			cadastroKey:		cadastroKey
		},
		beforeSend: function( xhr ) {
			$('#spiner').show();
		}
	});

	jqXHR.done(function( result ) {
		console.log("Log: A função DH_productsRemVariations() gerou um ou mais resultados.");
		document.location.reload(true);
	});

	jqXHR.fail(function() {
		console.log("Log: A função DH_productsRemVariations() gerou um ou mais erros.");
	});

	jqXHR.always(function() {
		console.log("Log: A função DH_productsRemVariations() foi finalizada.");
	});
});

$('.btn-add-modules-gallery').on('click', function() {
	var formData 						= new FormData();
	var CSRF_TOKEN 					= $('input[name="csrf_token"]').val();

	var selectedCadId 			= $('#modulo_galeria_id_cor').find(":selected").val();
	var selectedColorId 		= $('#modulo_galeria_id_cor').find(":selected").data("id-cor");
	var selectedModKey 			= $('#modulo_galeria_id_cor').find(":selected").data("key-modulo");

	var selectedFiles 			= $('#modulos_imagens')[0].files;

	if (selectedCadId == '' || selectedCadId === null || selectedCadId === undefined) {
		var swalHtml = "";
		swalHtml += '<i class="fa-light fa-hand text-danger text-12 mb-3"></i><br/>';
		swalHtml += '<h1>Ops!</h1>';
		swalHtml += '<p class="mb-0 text-lowercase">É preciso selecionar uma das opções.</p>';

		var swalConfirmButtonText = 'Certo, vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
		var swalCancelButtonText 	= ''
		var swalIsConfirmed 			= 0;
		var swalResult 						= '';

		sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
		return false;
	}

	if (selectedFiles.length === 0) {
		var swalHtml = "";
		swalHtml += '<i class="fa-light fa-hand text-danger text-12 mb-3"></i><br/>';
		swalHtml += '<h1>Ops!</h1>';
		swalHtml += '<p class="mb-0 text-lowercase">Nenhuma imagem foi selecionada.</p>';

		var swalConfirmButtonText = 'Certo, vou verificar <i class="fa-light fa-arrow-right ml-1"></i>';
		var swalCancelButtonText 	= ''
		var swalIsConfirmed 			= 0;
		var swalResult 						= '';

		sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);
		return false;
	}

	formData.append('id', $(this).data('id'));
	formData.append('modulo', $(this).data('modulo'));
	formData.append('tabela', $(this).data('tabela'));
	formData.append('pasta', $(this).data('pasta'));
	formData.append('subpasta', $(this).data('subpasta'));
	formData.append('index', $(this).data('index'));

	formData.append('id', 				selectedCadId);
	formData.append('idCor', 			selectedColorId);
	formData.append('keyModulo',	selectedModKey);
	formData.append('csrf_token', CSRF_TOKEN);

	for (var i = 0; i < selectedFiles.length; i++) {
		formData.append('imagens[' + i + '][name]', selectedFiles[i].name);
		formData.append('imagens[' + i + '][full_path]', selectedFiles[i].name);
		formData.append('imagens[' + i + '][type]', selectedFiles[i].type);
		formData.append('imagens[' + i + '][tmp_name]', selectedFiles[i].tmp_name);
		formData.append('imagens[' + i + '][error]', selectedFiles[i].error);
		formData.append('imagens[' + i + '][size]', selectedFiles[i].size);
		formData.append('imagens[' + i + '][file]', selectedFiles[i]); 
	}

	var jqXHR = $.ajax({
		dataType: 'json',
		type: 		"POST",
		url: 			BASE_URL + "DH_productsAddModulesGallery",
		data: 		formData,
		cache: false,
		processData: false,
		contentType: false,
		beforeSend: function( xhr ) {
			$('#spiner').show();
		}
	});

	jqXHR.done(function( result ) {
		console.log("Log: A função DH_productsAddModulesGallery() gerou um ou mais resultados.");
		document.location.reload(true)
	});

	jqXHR.fail(function() {
		console.log("Log: A função DH_productsAddModulesGallery() gerou um ou mais erros.");
	});

	jqXHR.always(function() {
		console.log("Log: A função DH_productsAddModulesGallery() foi finalizada.");
	});
});

// ---------------------------------------------------------------------------------------------]
// --------------------------------------------------------------------------------------[ TABS ]
// ---------------------------------------------------------------------------------------------]

var lastClickedTab = null;

$('.row-tabs .nav-link').click(function(e) {
	var clickedTabId = $(this).attr('id');

	sessionStorage.setItem('lastClickedTab', clickedTabId);
	lastClickedTab = clickedTabId;
});

var savedTabId = sessionStorage.getItem('lastClickedTab');

if (savedTabId) {
	$('#' + savedTabId).trigger('click');
}

// ---------------------------------------------------------------------------------------------]
// ---------------------------------------------------------------------------------------[ END ]
// ---------------------------------------------------------------------------------------------]