// ---------------------------------------------------------------------------------------------]
// ---------------------------------------------------------------------------------------[ ALL ]
// ---------------------------------------------------------------------------------------------]

/*
* UPLOAD ::: Validate
*/

const fileTypes = [
	"application/msword",
	"application/vnd.openxmlformats-officedocument.wordprocessingml.document",
	"application/vnd.openxmlformats-officedocument.wordprocessingml.template",
	"application/vnd.ms-word.document.macroEnabled.12",
	"application/vnd.ms-word.template.macroEnabled.12",
	"application/vnd.ms-excel",
	"application/vnd.ms-excel",
	"application/vnd.ms-excel",
	"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
	"application/vnd.openxmlformats-officedocument.spreadsheetml.template",
	"application/vnd.ms-excel.sheet.macroEnabled.12",
	"application/vnd.ms-excel.template.macroEnabled.12",
	"application/vnd.ms-excel.addin.macroEnabled.12",
	"application/vnd.ms-excel.sheet.binary.macroEnabled.12",
	"application/vnd.ms-powerpoint",
	"application/vnd.ms-powerpoint",
	"application/vnd.ms-powerpoint",
	"application/vnd.ms-powerpoint",
	"application/vnd.openxmlformats-officedocument.presentationml.presentation",
	"application/vnd.openxmlformats-officedocument.presentationml.template",
	"application/vnd.openxmlformats-officedocument.presentationml.slideshow",
	"application/vnd.ms-powerpoint.addin.macroEnabled.12",
	"application/vnd.ms-powerpoint.presentation.macroEnabled.12",
	"application/vnd.ms-powerpoint.template.macroEnabled.12",
	"application/vnd.ms-powerpoint.slideshow.macroEnabled.12",
	"image/apng",
	"image/bmp",
	"image/gif",
	"image/jpeg",
	"image/pjpeg",
	"image/png",
	"image/svg+xml",
	"image/tiff",
	"image/webp",
	"image/x-icon",
	"application/pdf",
	"application/zip",
	"text/plain",
	"application/vnd.ms-fontobject",
	"application/font-woff",
	"application/x-font-truetype",
	"image/svg+xml",
	"application/x-font-opentype",
	"application/x-zip-compressed",
	"application/zip",
	"application/octet-stream",
	"image/vnd.adobe.photoshop",
	"application/x-photoshop",
	"application/photoshop",
	"application/psd",
	"image/psd",
	"video/mp4",
];

function validFileType(file) {
	var r = null;

	if(file.type == "") {

		var str1 = file.name;
		var str2 = ".psd";

		if(str1.indexOf(str2) != -1){
			r = true;
		}

	}
	else {
		r = fileTypes.includes(file.type);
	}

	return r; 
}

/*
* IMG ::: Preview 
*/

function btnImagePreview() {
	$(".btn-imagem-preview").on('change', function(e) {
		e.preventDefault();

		var countFiles 		= $(this)[0].files.length;
		var imgPath 			= $(this)[0].value;

		var extn 					= imgPath.substring(imgPath.lastIndexOf('.') + 1).toLowerCase();

		var dataHolder    = $(this).data('holder');
		var imageHolder 	= $("#" + dataHolder);

		imageHolder.empty();

		if($(this)[0].files[0].size > 2000000) {
			Swal.fire({ 
				title: 							'',
				html: 							'<i class="fal fa-info-circle"></i><br/> <h1>Ops...</h1> <br/> A imagem deve ter até 2MB.',
				confirmButtonText:  'Entendi, vou selecionar outra imagem <i class="fas fa-angle-right"></i>',
				allowOutsideClick:  true,
				allowEscapeKey:     true,
				showCancelButton: 	false,
				showClass: {
					popup: 'animated bounceInUp faster'
				},
				hideClass: {
					popup: 'animated bounceOutDown faster'
				},
				position: 'bottom'
			});

			$(this).val('');
		}
		else {
			if (extn == "gif" || extn == "png" || extn == "jpg" || extn == "jpeg" || extn == 'webp') {
				if (typeof(FileReader) != "undefined") {
					for (var i = 0; i < countFiles; i++) {
						var reader = new FileReader();

						reader.onload = function(e) {
							$("<img />", { "src": e.target.result, "class": "thumb-image"}).appendTo(imageHolder);
						}

						imageHolder.show();
						reader.readAsDataURL($(this)[0].files[i]);
					}
				} 
				else {
					Swal.fire({ 
						type: 							'error', 
						title: 							'Oops...', 
						html: 							'Navegador incompatível! <br> Recomendamos o uso do Google Chrome.', 
						confirmButtonColor: '#1ab394' 
					});

					$( this ).val('');
				}
			} 
			else {
				Swal.fire({ 
					type: 							'error', 
					title: 							'Oops...', 
					html: 							'Extensão incorreta! <br> Extensões permitidas: .gif, .png, .jpg e .jpeg', 
					confirmButtonColor: '#1ab394' 
				});

				$( this ).val('');
			}
		}
	});
}

btnImagePreview();

// ---------------------------------------------------------------------------------------------]
// -----------------------------------------------------------------------------------[ GALERIA ]
// ---------------------------------------------------------------------------------------------]

/*
* GALERIA ::: Upload
*/

var upCadastro  = null;
var upModulo    = null;
var upTabela    = null;
var upPasta     = null;
var upSubPasta  = null;
var upIndex     = null;

$("#uploaderGallery").pluploadQueue({
	runtimes :       'html5, html4',
	url :            BASE_URL + 'UPH_uploadImageGallery',
	max_file_size :  '2mb',
	unique_names :   true,
	max_file_count:  99,
	max_files:       99,
	multiple_queues: true,
	filters : [{
		title :                   "Imagens", 
		extensions :              "jpg,gif,png,jpeg"
	}],
	multipart_params : {
		"csrf_token": CSRF_TOKEN,
		"upUrl":      location,
		"upCadastro": $(".upCadastro").val(),
		"upModulo":   $(".upModulo").val(),
		"upTabela":   $(".upTabela").val(),
		"upPasta":    $(".upPasta").val(),
		"upSubPasta": $(".upSubPasta").val(),
		"upIndex":    $(".upIndex").val()
	},
	init : {
		FilesAdded: function(up, files) {
			var maxfiles = 20;

			if(up.files.length > maxfiles) {
				up.splice(maxfiles);

				Swal.fire({ 
					title:              '',
					html:               '<i class="fal fa-info-circle"></i><br/> <h1>Ops...</h1> <br/> É permitido apenas 20 imagens por vez.',
					confirmButtonText:  'Ok, entendi <i class="fas fa-angle-right"></i>',
					allowOutsideClick:  true,
					allowEscapeKey:     true,
					showCancelButton:   false,
					showClass: {
						popup: 'animated bounceInUp faster'
					},
					hideClass: {
						popup: 'animated bounceOutDown faster'
					},
					position: 'bottom'
				});
			}
		},
		BeforeUpload: function(up, files) {
		},
		FileUploaded: function(up, file, response) {
			var vals          = response.response.split("|");
			var upCadastro    = vals[0];
			var upModulo      = vals[1];
			var upTabela      = vals[2];
			var upPasta       = vals[3];
			var upSubPasta    = vals[4];
			var upIndex       = vals[5];
			var upImagem      = vals[6];
			var upImagemNome  = vals[7];

			$.ajax({
				type: "POST",
				url: 	BASE_URL + "UPH_saveImageGallery",
				data: { 
					csrf_token:    CSRF_TOKEN, 
					upCadastro:    upCadastro,
					upModulo:      upModulo,
					upTabela:      upTabela,
					upPasta:       upPasta,
					upSubPasta:    upSubPasta,
					upIndex:       upIndex,
					upImagem:      upImagem,
					upImagemNome:  upImagemNome
				},
			})
			.done(function( msg ) {
				msg = JSON.parse(msg);
				msg = msg.replaceAll("\"", "");

				var numImgs = $('.img-background').length;
				numImgs 		= numImgs + 1;

				$.ajax({
					type: 		"POST",
					dataType: "json",
					url:			BASE_URL + "UPH_saveNewOrder",
					data: {
						csrf_token: CSRF_TOKEN, 
						key:        numImgs-1,
						upCadastro: upCadastro,
						upModulo:   upModulo,
						upTabela:   upTabela,
						upPasta:    upPasta,
						upSubPasta: upSubPasta,
						upIndex:    upIndex,
						upImagem:   upImagem,
						newOrder:   numImgs
					}
				});
				
				const template 	= $('#gallery-item-template').prop('content');
				const clone 		= $(document.importNode(template, true));

				// -----------------------------------------------------------------> imgBackground
				const imgBackground = clone.find('.img-background');
				imgBackground.addClass(`img-background-${numImgs}`);

				// -----------------------------------------------------------------> linkGaleria
				const linkGaleria = clone.find('.link-galeria');

				if(upSubPasta != "") {
					linkGaleria.attr('href', `${PUBLICURL}uploads/${upPasta}/${upSubPasta}/${upImagem}`);
				}
				else {
					linkGaleria.attr('href', `${PUBLICURL}uploads/${upPasta}/${upImagem}`);
				}

				// -----------------------------------------------------------------> imgGaleria
				const imgGaleria = clone.find('.img-galeria');

				if(upSubPasta != "") {
					imgGaleria.attr('src', `${PUBLICURL}uploads/${upPasta}/${upSubPasta}/${upImagem}`);
				}
				else {
					imgGaleria.attr('src', `${PUBLICURL}uploads/${upPasta}/${upImagem}`);
				}

				// -----------------------------------------------------------------> inputOrder
				const inputOrder = clone.find('.input-order');
				inputOrder.addClass(`input-order-${numImgs}`);
				inputOrder.val(numImgs);

				// -----------------------------------------------------------------> inputName
				const inputName = clone.find('.input-name');
				inputName.addClass(`input-name-${numImgs}`);
				inputName.val(upImagemNome);

				// -----------------------------------------------------------------> inputDescription
				const inputDescription = clone.find('.input-description');
				inputDescription.addClass(`input-description-${numImgs}`);

				// -----------------------------------------------------------------> buttons
				const saveNewOrderButton = clone.find('.saveNewOrder');
				saveNewOrderButton.addClass(`saveNewOrder-${numImgs}`);

				const saveImagemNameButton = clone.find('.saveImagemName');
				saveImagemNameButton.addClass(`saveImagemName-${numImgs}`);

				const saveImagemDescripitonButton = clone.find('.saveImagemDescripiton');
				saveImagemDescripitonButton.addClass(`saveImagemDescripiton-${numImgs}`);

				const deleteImagemGalleryButton = clone.find('.deleteImagemGallery');
				deleteImagemGalleryButton.addClass(`deleteImagemGallery-${numImgs}`);

				// -----------------------------------------------------------------> buttons
				const buttons = clone.find('button, .deleteImagemGallery');
				buttons.each(function() {
					$(this).attr('data-key', numImgs);
					$(this).attr('data-upcadastro', upCadastro);
					$(this).attr('data-upmodulo', upModulo);
					$(this).attr('data-uptabela', upTabela);
					$(this).attr('data-uppasta', upPasta);
					$(this).attr('data-upsubpasta', upSubPasta);
					$(this).attr('data-upindex', upIndex);
					$(this).attr('data-upimagem', upImagem);
				});

				$('.lightBoxGallery .row').append(clone);
			});
		}
	}
});

/*
* GALERIA ::: Delete
*/

function deleteImagemGallery(todelete) {
	var upKey  				= todelete.data('key');
	var upkeygaleria	= todelete.data('upkeygaleria');
	var upkeymodulo		= todelete.data('upkeymodulo');
	var upKeyImage		= todelete.data('upkeyimage');
	var upIdCor				= todelete.data('upidcor');
	var upCadastro  	= todelete.data('upcadastro');
	var upModulo    	= todelete.data('upmodulo');
	var upTabela    	= todelete.data('uptabela');
	var upPasta     	= todelete.data('uppasta');
	var upSubPasta  	= todelete.data('upsubpasta');
	var upIndex     	= todelete.data('upindex');
	var upImagem    	= todelete.data('upimagem');

	$.ajax({
		type: 		"POST",
		dataType: "json",
		url: 			BASE_URL + "UPH_deleteImageGallery",
		data: {
			csrf_token: 	CSRF_TOKEN, 
			upKey: 				upKey,
			upkeygaleria: upkeygaleria,
			upkeymodulo: 	upkeymodulo,
			upKeyImage: 	upKeyImage,
			upIdCor: 			upIdCor,
			upCadastro: 	upCadastro,
			upModulo:   	upModulo,
			upTabela:   	upTabela,
			upPasta:    	upPasta,
			upSubPasta: 	upSubPasta,
			upIndex:    	upIndex,
			upImagem:   	upImagem
		}
	})
	.done(function( result ) {
		var msg = "";

		msg += result.original.mensagem + "<br/>";

		if(result.original.status == 1 || result.original.status == "1") {
			var el = todelete;
			var r1 = el.closest(".col-3"); 

			r1.remove();

			var toastIcon			= '<i class="fa-light fa-check me-1"></i>'; 
			var toastTitle		= 'Sucesso!';
			var toastMessage	= msg
			var toastType			= 'toast-success';
			var toastDelay		= 2500;
			var toastAutohide	= true;

			toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);
		}
		else {
			var toastIcon			= '<i class="fa-light fa-xmark me-1"></i>';
			var toastTitle		= 'Sucesso!';
			var toastMessage	= msg
			var toastType			= 'toast-danger';
			var toastDelay		= 2500;
			var toastAutohide	= true;

			toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);
		}
	});
}

$(document).on('click', '.deleteImagemGallery', function() {
	deleteImagemGallery($(this));
});

/*
* GALERIA ::: Change TITLE
*/

function saveImagemName(btn) {
	btn.html('').html('<i class="fa-duotone fa-spinner-third fa-spin"></i>').focusout();

	var key  				= btn.data('key');
	var upCadastro  = btn.data('upcadastro');
	var upModulo    = btn.data('upmodulo');
	var upTabela    = btn.data('uptabela');
	var upPasta     = btn.data('uppasta');
	var upSubPasta  = btn.data('upsubpasta');
	var upIndex     = btn.data('upindex');
	var upImagem    = btn.data('upimagem');

	if(upIndex == "galeria") {
		var newName = $('.input-name-' + key).val();
	}

	if(upIndex == "diferenciais") {
		var newName = $('.input-other-name-' + key).val();
	}

	$.ajax({
		type: 		"POST",
		dataType: "json",
		url: 			BASE_URL + "UPH_saveImagemName",
		data: {
			csrf_token: 					CSRF_TOKEN, 
			key:           				key,
			upCadastro:           upCadastro,
			upModulo:             upModulo,
			upTabela:             upTabela,
			upPasta:              upPasta,
			upSubPasta:           upSubPasta,
			upIndex:              upIndex,
			upImagem:             upImagem,
			newName:              newName
		}
	})
	.done(function( result ) {
		var msg = "";
		msg += result.mensagem + "<br/>";

		if(result.status == 1 || result.status == "1") {

			var toastIcon			= '<i class="fa-light fa-check me-1"></i>';
			var toastTitle		= 'Sucesso!';
			var toastMessage	= msg
			var toastType			= 'toast-success';
			var toastDelay		= 2500;
			var toastAutohide	= true;

			toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);

			$('.saveImagemName-' + key).html('').html('<i class="fa-light fa-check"></i>').focusout();

			setTimeout(function() {  
				$('.saveImagemName-' + key).html('').html('<i class="fa-light fa-floppy-disk"></i>').focusout();
			}, 1500);
		}
		else {
			var toastIcon			= '<i class="fa-light fa-xmark me-1"></i>';
			var toastTitle		= 'Ops!';
			var toastMessage	= msg
			var toastType			= 'toast-danger';
			var toastDelay		= 2500;
			var toastAutohide	= true;

			toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);

			$('.saveImagemName-' + key).html('').html('<i class="fa-light fa-floppy-disk"></i>').focusout();
		}
	});
}

$(document).on('click', '.saveImagemName', function() {
	saveImagemName($(this));
});

/*
* GALERIA ::: Change ORDER
*/

function saveNewOrder(btn) {
	btn.html('').html('<i class="fad fa-spinner-third fa-spin"></i>').focusout();

	var key  				= btn.data('key');
	var keyVariacao	= btn.data('key-variacao');
	var keyModulo		= btn.data('key-modulo');
	var upCadastro  = btn.data('upcadastro');
	var upModulo    = btn.data('upmodulo');
	var upTabela    = btn.data('uptabela');
	var upPasta     = btn.data('uppasta');
	var upSubPasta  = btn.data('upsubpasta');
	var upIndex     = btn.data('upindex');
	var upImagem    = btn.data('upimagem');

	var newOrder     			= $('.input-order-' + key).val();
	var newOrderVariation = $('.input-variation-order-' + key + '-' + keyVariacao).val();
	var newOrderModule 		= $('.input-module-order-' + key + '-' + keyModulo).val();

	$.ajax({
		type: 		"POST",
		dataType: "json",
		url:			BASE_URL + "UPH_saveNewOrder",
		data: {
			csrf_token: 					CSRF_TOKEN, 
			key:           				key,
			keyVariacao:					keyVariacao,
			keyModulo:						keyModulo,
			upCadastro:           upCadastro,
			upModulo:             upModulo,
			upTabela:             upTabela,
			upPasta:              upPasta,
			upSubPasta:           upSubPasta,
			upIndex:              upIndex,
			upImagem:             upImagem,
			newOrder:             newOrder,
			newOrderVariation:		newOrderVariation,
			newOrderModule:				newOrderModule
		}
	})
	.done(function( result ) {

		console.log(result);

		var msg = "";
		msg += result.mensagem + "<br/>";

		if(result.status == 1 || result.status == "1") {
			var toastIcon			= '<i class="fa-light fa-check me-1"></i>';
			var toastTitle		= 'Sucesso!';
			var toastMessage	= msg
			var toastType			= 'toast-success';
			var toastDelay		= 2500;
			var toastAutohide	= true;

			toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);

			if ($.trim(keyVariacao) !== '') {
				$('.saveNewOrder-' + keyVariacao).html('').html('<i class="fa-light fa-check"></i>').focusout();

				setTimeout(function() {  
					$('.saveNewOrder-' + keyVariacao).html('').html('<i class="fa-light fa-floppy-disk"></i>').focusout();
				}, 1500);
			}
			else {
				$('.saveNewOrder-' + key).html('').html('<i class="fa-light fa-check"></i>').focusout();

				setTimeout(function() {  
					$('.saveNewOrder-' + key).html('').html('<i class="fa-light fa-floppy-disk"></i>').focusout();
				}, 1500);
			}
		}
		else {
			var toastIcon			= '<i class="fa-light fa-xmark me-1"></i>';
			var toastTitle		= 'Ops!';
			var toastMessage	= msg
			var toastType			= 'toast-danger';
			var toastDelay		= 2500;
			var toastAutohide	= true;

			toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);

			$('.saveNewOrder-' + key).html('').html('<i class="fa-light fa-floppy-disk"></i>').focusout();
		}
	});
}

$(document).on('click', '.saveNewOrder', function() {
	saveNewOrder($(this));
});

/*
* GALERIA ::: Change DESCRIPTION
*/

function saveImagemDescripiton(btn) {
	btn.html('').html('<i class="fa-duotone fa-spinner-third fa-spin"></i>').focusout();

	var key  				= btn.data('key');
	var upCadastro  = btn.data('upcadastro');
	var upModulo    = btn.data('upmodulo');
	var upTabela    = btn.data('uptabela');
	var upPasta     = btn.data('uppasta');
	var upSubPasta  = btn.data('upsubpasta');
	var upIndex     = btn.data('upindex');
	var upImagem    = btn.data('upimagem');

	var newName 				= "";
	var newDescription 	= "";

	if(upIndex == "galeria") {
		newName 				= $('.input-name-' + key).val();
		newDescription 	= $('.input-description-' + key).val();
	}

	$.ajax({
		type: 				"POST",
		dataType: 		"json",
		url: 					BASE_URL + "UPH_saveImagemDescripiton",
		data: {
			csrf_token: 		CSRF_TOKEN, 
			key:        		key,
			upCadastro: 		upCadastro,
			upModulo:   		upModulo,
			upTabela:   		upTabela,
			upPasta:    		upPasta,
			upSubPasta: 		upSubPasta,
			upIndex:    		upIndex,
			upImagem:   		upImagem,
			newName:    		newName,
			newDescription:	newDescription,
		}
	})
	.done(function( result ) {
		var msg = "";
		msg += result.mensagem + "<br/>";

		if(result.status == 1 || result.status == "1") {

			var toastIcon			= '<i class="fa-light fa-check me-1"></i>';
			var toastTitle		= 'Sucesso!';
			var toastMessage	= msg
			var toastType			= 'toast-success';
			var toastDelay		= 2500;
			var toastAutohide	= true;

			toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);

			$('.saveImagemDescripiton-' + key).html('').html('<i class="fa-light fa-check"></i>').focusout();

			setTimeout(function() {  
				$('.saveImagemDescripiton-' + key).html('').html('<i class="fa-light fa-floppy-disk"></i>').focusout();
			}, 1500);
		}
		else {
			var toastIcon			= '<i class="fa-light fa-xmark me-1"></i>';
			var toastTitle		= 'Ops!';
			var toastMessage	= msg
			var toastType			= 'toast-danger';
			var toastDelay		= 2500;
			var toastAutohide	= true;

			toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);

			$('.saveImagemDescripiton-' + key).html('').html('<i class="fa-light fa-floppy-disk"></i>').focusout();
		}
	});
}

$(document).on('click', '.saveImagemDescripiton', function() {
	saveImagemDescripiton($(this));
});

// ---------------------------------------------------------------------------------------------]
// --------------------------------------------------------------------------------------[ FILE ]
// ---------------------------------------------------------------------------------------------]

/*
* FILE ::: Upload
*/

$('.custom-file-input').on('change', function(e) {
	var multiple = $(this).data('multiple');

	if(multiple == 1) {

    /*
    * Multi upload files
    */

		var files       = e.target.files;
		var count       = files.length;
		var valid       = 0;
		var errorFiles  = "";

		$.each(files, function(index, val) {
			ret = false;
			ret = validFileType(val);

			if(ret == true) {
				valid++;
			}
			else {
				errorFiles += val.name+"; ";
			}
		});

		if(count != valid) {
			Swal.fire({ 
				title:              '',
				html:               '<i class="fal fa-info-circle"></i><br/> <h1>Ops...</h1> <br/> Arquivo(s) com formato inválido: ' + errorFiles,
				confirmButtonText:  'Entendi, vou selecionar novamente <i class="fas fa-angle-right"></i>',
				allowOutsideClick:  true,
				allowEscapeKey:     true,
				showCancelButton:   false,
				showClass: {
					popup: 'animated bounceInUp faster'
				},
				hideClass: {
					popup: 'animated bounceOutDown faster'
				},
				position: 'bottom'
			});

			$(this).next('.custom-file-label').removeClass("selected").html('<i class="fal fa-file"></i> Selecionar arquivo...');
			$(this).val('');
		}
		else {
			var fileNames = "";

			$.each(files, function(index, val) {
				fileNames += val.name + "; ";
			});

			$(this).next('.custom-file-label').addClass("selected").html(fileNames);
		}
	}
	else if(multiple == 0) {

    /*
    * Single upload file
    */

		var file = e.target.files[0];
		ret      = validFileType(file);

		if(ret == true) {
			if(file.size > 10485760) {
				var swalHtml = "";
				swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
				swalHtml += '<h1>Ops!</h1>';
				swalHtml += '<p class="mb-0 text-lowercase">Tamanho do arquivo inválido, tamanho enviado: ' + file.size + '</p>';

				var swalConfirmButtonText = 'Vou selecionar outro <i class="fa-light fa-arrow-right ml-1"></i>';
				var swalCancelButtonText 	= ''
				var swalIsConfirmed 			= 1;
				var swalResult 						= '';

				sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);

				$(this).next('.custom-file-label').removeClass("selected").html('<i class="fal fa-file"></i> Selecionar arquivo...');
				$(this).val('');
			}
			else {
				let fileName = $(this).val().split('\\').pop();
				$(this).next('.custom-file-label').addClass("selected").html('<i class="fal fa-file"></i> ' + fileName);
			}
		}
		else {
			var swalHtml = "";
			swalHtml += '<i class="fa-light fa-xmark text-danger text-12 mb-3"></i><br/>';
			swalHtml += '<h1>Ops!</h1>';
			swalHtml += '<p class="mb-0 text-lowercase">Tipo de arquivo inválido, tipo enviado: ' + ret + '</p>';

			var swalConfirmButtonText = 'Vou selecionar outro <i class="fa-light fa-arrow-right ml-1"></i>';
			var swalCancelButtonText 	= ''
			var swalIsConfirmed 			= 1;
			var swalResult 						= '';

			sweetAlert2(swalHtml, swalConfirmButtonText, swalCancelButtonText, swalIsConfirmed, swalResult);

			$(this).next('.custom-file-label').removeClass("selected").html('<i class="fal fa-file"></i> Selecionar arquivo...');
			$(this).val('');
		}
	}
	else {

    /*
    * Erro!
    */

	}
}); 

/*
* FILE ::: Delete
*/

$('.btn-multi-rem-file').on('click', function(event) {
	event.preventDefault();

	var modulo    = $(this).data('modulo');
	var index     = $(this).data('index');
	var pasta     = $(this).data('pasta');
	var subpasta  = $(this).data('subpasta');
	var arquivo   = $(this).data('arquivo');
	var id        = $(this).data('id');
	var key       = $(this).data('key');

	$.ajax({
		type: "POST",
		url: BASE_URL+"inicial/MYC_multiDeleteFiles",
		data: {
			csrf_token: CSRF_TOKEN, 
			modulo:   modulo,
			index:    index,
			pasta:    pasta,
			subpasta: subpasta,
			arquivo:  arquivo,
			id:       id
		}
	}).done(function( msg ) {
		if(msg == 1) {

			$('.row-file-key-' + key).remove();

			Swal.fire({ 
				title:              '',
				html:               '<i class="fa-light fa-check-circle"></i><br/> <h1>Tudo certo!</h1> <br/> O arquivo foi removido com sucesso.',
				confirmButtonText:  'Entendi, vou selecionar outro arquivo <i class="fas fa-angle-right"></i>',
				allowOutsideClick:  true,
				allowEscapeKey:     true,
				showCancelButton:   false,
				showClass: {
					popup: 'animated bounceInUp faster'
				},
				hideClass: {
					popup: 'animated bounceOutDown faster'
				},
				position: 'bottom'
			});
		}
		else {
			Swal.fire({ 
				title:              '',
				html:               '<i class="fal fa-info-circle"></i><br/> <h1>Ops...</h1> <br/> Não foi possível remover o arquivo, atualize a página e tente novamente.',
				confirmButtonText:  'Entendi, vou fazer isso <i class="fas fa-angle-right"></i>',
				allowOutsideClick:  true,
				allowEscapeKey:     true,
				showCancelButton:   false,
				showClass: {
					popup: 'animated bounceInUp faster'
				},
				hideClass: {
					popup: 'animated bounceOutDown faster'
				},
				position: 'bottom'
			});
		}
	});
});

/*
* FILE ::: Áudio
*/

$('.btn-audio').on('change', function(e) {
	e.preventDefault();
	
	var file = e.target.files[0];
	ret      = validFileType(file);

	console.clear();
	console.log(file);
	return false;

	if(ret == true) {
	}
	else {
	}
});


// ---------------------------------------------------------------------------------------------]
// ----------------------------------------------------------------------------------[ DROPZONE ]
// ---------------------------------------------------------------------------------------------]

/*
* ALL ::: Envio de arquivos com plugin Dropzone
*/

const dropZone = $(".dropzone");

if(dropZone.length) {
	dropZone.dropzone({ 
		// Tradução
		dictDefaultMessage: "Clique ou arraste os arquivos ate aqui para enviar",
		dictFallbackMessage: "Seu navegador não possui suporte a função de arrastar e soltar",
		dictCancelUpload: "Cancelar upload",
		dictCancelUploadConfirmation: "Você tem certeza que deseja cancelar o upload?",
		dictRemoveFile: "Remover arquivo",
		dictMaxFilesExceeded: "Você não pode enviar mais arquivos.",

		// Parametros
		url: BASE_URL+"UPH_ajaxSaveDropzone",
		addRemoveLinks: true,
		init: function() {
			var myDropzone  = this;

			var pasta 	 	= $('#upPasta').val();
			var subpasta 	= $('#upSubpasta').val();
			var tabela 	 	= $('#upTabela').val();
			var item 	 	= $('#upItem').val();
			var coluna 	 	= $('#upColuna').val();
			var atualizaDB 	= $('#upAtualizaDB').val();

			$.ajax({
				dataType: 'json',
				type: "POST",
				url: BASE_URL + "UPH_ajaxGetDropzone",
				data: {
					csrf_token: CSRF_TOKEN,
					pasta: pasta,
					subpasta: subpasta,
				}
			}).done(function( result ) {
				if(result != '') {
					$.each(result, function(key, value) {
						let mockFile = { name: value.name, size: value.size };
						myDropzone.displayExistingFile(mockFile, value.url);
					});
				}
			});

			this.on("sending", function(file, xhr, formData){
				formData.append('csrf_token', CSRF_TOKEN);
				formData.append('pasta', $('#upPasta').val());
				formData.append('subpasta', $('#upSubpasta').val());
				formData.append('tabela', $('#upTabela').val());
				formData.append('item', $('#upItem').val());
				formData.append('coluna', $('#upColuna').val());
				formData.append('atualizaDB', $('#upAtualizaDB').val());
			});

			this.on("success", function() {
				var args = Array.prototype.slice.call(arguments);
				console.log(args);

				var toastIcon		= '<i class="fa-light fa-check-circle me-1"></i>';
				var toastTitle		= 'Sucesso!';
				var toastMessage	= 'O arquivo '+args[0].name+' foi enviado com sucesso.';
				var toastType		= 'toast-success';
				var toastDelay		= 2500;
				var toastAutohide	= true;
				toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);
			});

			this.on("error", function() {
				var args = Array.prototype.slice.call(arguments);

				var toastIcon		= '<i class="fa-light fa-triangle-exclamation me-1"></i>';
				var toastTitle		= 'Ops!';
				var toastMessage	= 'Houve um erro ao enviar o arquivo '+args[0].name;
				var toastType		= 'toast-danger';
				var toastDelay		= 2500;
				var toastAutohide	= true;
				toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);
			});

			this.on("removedfile", function(file) {
				var name 	 	= file.name;

				$.ajax({
					dataType: 'json',
					type: "POST",
					url: BASE_URL + "UPH_ajaxDeleteDropzone",
					data: {
						csrf_token: CSRF_TOKEN,
						name: name,
						pasta: pasta,
						subpasta: subpasta,
						tabela: tabela,
						item: item,
						coluna: coluna,
						atualizaDB: atualizaDB
					}
				}).done(function( result ) {
					if(result.status == 'success') {
						var toastIcon		= '<i class="fa-light fa-check-circle me-1"></i>';
						var toastTitle		= 'Sucesso!';
						var toastMessage	= result.message;
						var toastType		= 'toast-success';
						var toastDelay		= 2500;
						var toastAutohide	= true;

					}else {
						var toastIcon		= '<i class="fa-light fa-triangle-exclamation me-1"></i>';
						var toastTitle		= 'Ops!';
						var toastMessage	= result.message;
						var toastType		= 'toast-danger';
						var toastDelay		= 2500;
						var toastAutohide	= true;
					}

					toastShow(toastIcon, toastTitle, toastMessage, toastType, toastDelay, toastAutohide);
				});
			});
		}
	});
}