/// <reference types="node" />
import { RedisCommandArgument } from '../commands';
import { PubSubListener } from '../pub-sub';
export declare enum PubSubTypes {
    REGULAR = 0,
    PATTERN = 1,
    SHARDED = 2
}
export declare const MESSAGE_TYPES: {
    0: {
        subscribe: Buffer;
        unsubscribe: Buffer;
        message: Buffer;
    };
    1: {
        subscribe: Buffer;
        unsubscribe: Buffer;
        message: Buffer;
    };
    2: {
        subscribe: Buffer;
        unsubscribe: Buffer;
        message: Buffer;
    };
};
export declare type SubscriptionCallback = (counter: number, hadError: boolean) => void;
export declare class ClientPubSub {
    #private;
    get isActive(): boolean;
    subscribe<T extends boolean>(type: PubSubTypes, channels: RedisCommandArgument | Array<RedisCommandArgument>, listener: PubSubListener<T>, returnBuffers?: T): Array<RedisCommandArgument>;
    onSubscribe(counter: number, hadError: boolean): void;
    unsubscribe<T extends boolean>(type: PubSubTypes, channels: RedisCommandArgument | Array<RedisCommandArgument>, listener?: PubSubListener<T>, returnBuffers?: T): Array<RedisCommandArgument>;
    unsubscribeAll(type: PubSubTypes): number;
    onUnsubscribe(counter: number, hadError: boolean): void;
    reset(): void;
    subscribedChannels(): IterableIterator<[PubSubTypes, Array<string>]>;
    handleMessageReply(reply: any): boolean;
    isSubscriptionReply(reply: any): boolean;
}
