"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _ClientPubSub_isActive, _ClientPubSub_subscribing, _ClientPubSub_subscribed, _ClientPubSub_unsubscribing, _ClientPubSub_listeners;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientPubSub = exports.MESSAGE_TYPES = exports.PubSubTypes = void 0;
const pub_sub_1 = require("../pub-sub");
var PubSubTypes;
(function (PubSubTypes) {
    PubSubTypes[PubSubTypes["REGULAR"] = 0] = "REGULAR";
    PubSubTypes[PubSubTypes["PATTERN"] = 1] = "PATTERN";
    PubSubTypes[PubSubTypes["SHARDED"] = 2] = "SHARDED";
})(PubSubTypes = exports.PubSubTypes || (exports.PubSubTypes = {}));
exports.MESSAGE_TYPES = {
    [PubSubTypes.REGULAR]: {
        subscribe: Buffer.from('subscribe'),
        unsubscribe: Buffer.from('unsubscribe'),
        message: Buffer.from('message')
    },
    [PubSubTypes.PATTERN]: {
        subscribe: Buffer.from('psubscribe'),
        unsubscribe: Buffer.from('punsubscribe'),
        message: Buffer.from('pmessage')
    },
    [PubSubTypes.SHARDED]: {
        subscribe: Buffer.from('ssubscribe'),
        unsubscribe: Buffer.from('sunsubscribe'),
        message: Buffer.from('smessage')
    }
};
class ClientPubSub {
    constructor() {
        _ClientPubSub_isActive.set(this, false);
        _ClientPubSub_subscribing.set(this, 0);
        _ClientPubSub_subscribed.set(this, 0);
        _ClientPubSub_unsubscribing.set(this, 0);
        _ClientPubSub_listeners.set(this, {
            [PubSubTypes.REGULAR]: new pub_sub_1.PubSubListeners(),
            [PubSubTypes.PATTERN]: new pub_sub_1.PubSubListeners(),
            [PubSubTypes.SHARDED]: new pub_sub_1.PubSubListeners()
        });
    }
    get isActive() {
        return __classPrivateFieldGet(this, _ClientPubSub_isActive, "f");
    }
    subscribe(type, channels, listener, returnBuffers) {
        const toSubscribe = __classPrivateFieldGet(this, _ClientPubSub_listeners, "f")[type].subscribe(channels, listener, returnBuffers);
        if (toSubscribe.length) {
            __classPrivateFieldSet(this, _ClientPubSub_isActive, true, "f");
            __classPrivateFieldSet(this, _ClientPubSub_subscribing, __classPrivateFieldGet(this, _ClientPubSub_subscribing, "f") + toSubscribe.length, "f");
        }
        return toSubscribe;
    }
    onSubscribe(counter, hadError) {
        __classPrivateFieldSet(this, _ClientPubSub_subscribing, __classPrivateFieldGet(this, _ClientPubSub_subscribing, "f") - counter, "f");
        if (!hadError)
            __classPrivateFieldSet(this, _ClientPubSub_subscribed, __classPrivateFieldGet(this, _ClientPubSub_subscribed, "f") + counter, "f");
    }
    unsubscribe(type, channels, listener, returnBuffers) {
        const toUnsubscribe = __classPrivateFieldGet(this, _ClientPubSub_listeners, "f")[type].unsubscribe(channels, listener, returnBuffers);
        __classPrivateFieldSet(this, _ClientPubSub_unsubscribing, __classPrivateFieldGet(this, _ClientPubSub_unsubscribing, "f") + toUnsubscribe.length, "f");
        return toUnsubscribe;
    }
    unsubscribeAll(type) {
        const counter = __classPrivateFieldGet(this, _ClientPubSub_listeners, "f")[type].unsubscribeAll();
        __classPrivateFieldSet(this, _ClientPubSub_unsubscribing, __classPrivateFieldGet(this, _ClientPubSub_unsubscribing, "f") + counter, "f");
        return counter;
    }
    onUnsubscribe(counter, hadError) {
        __classPrivateFieldSet(this, _ClientPubSub_unsubscribing, __classPrivateFieldGet(this, _ClientPubSub_unsubscribing, "f") - counter, "f");
        if (!hadError)
            __classPrivateFieldSet(this, _ClientPubSub_subscribed, __classPrivateFieldGet(this, _ClientPubSub_subscribed, "f") - counter, "f");
        __classPrivateFieldSet(this, _ClientPubSub_isActive, !!(__classPrivateFieldGet(this, _ClientPubSub_subscribing, "f") ||
            __classPrivateFieldGet(this, _ClientPubSub_subscribed, "f") ||
            __classPrivateFieldGet(this, _ClientPubSub_unsubscribing, "f")), "f");
    }
    reset() {
        __classPrivateFieldSet(this, _ClientPubSub_isActive, false, "f");
        __classPrivateFieldSet(this, _ClientPubSub_subscribing, 0, "f");
        __classPrivateFieldSet(this, _ClientPubSub_subscribed, 0, "f");
        __classPrivateFieldSet(this, _ClientPubSub_unsubscribing, 0, "f");
    }
    *subscribedChannels() {
        yield [PubSubTypes.REGULAR, __classPrivateFieldGet(this, _ClientPubSub_listeners, "f")[PubSubTypes.REGULAR].getSubscribedChannels()];
        yield [PubSubTypes.PATTERN, __classPrivateFieldGet(this, _ClientPubSub_listeners, "f")[PubSubTypes.PATTERN].getSubscribedChannels()];
        yield [PubSubTypes.SHARDED, __classPrivateFieldGet(this, _ClientPubSub_listeners, "f")[PubSubTypes.SHARDED].getSubscribedChannels()];
    }
    handleMessageReply(reply) {
        if (exports.MESSAGE_TYPES[PubSubTypes.REGULAR].message.equals(reply[0])) {
            __classPrivateFieldGet(this, _ClientPubSub_listeners, "f")[PubSubTypes.REGULAR].emit(reply[2], reply[1]);
            return true;
        }
        else if (exports.MESSAGE_TYPES[PubSubTypes.PATTERN].message.equals(reply[0])) {
            __classPrivateFieldGet(this, _ClientPubSub_listeners, "f")[PubSubTypes.PATTERN].emit(reply[3], reply[2], reply[1]);
            return true;
        }
        else if (exports.MESSAGE_TYPES[PubSubTypes.SHARDED].message.equals(reply[0])) {
            __classPrivateFieldGet(this, _ClientPubSub_listeners, "f")[PubSubTypes.SHARDED].emit(reply[2], reply[1]);
            return true;
        }
        return false;
    }
    isSubscriptionReply(reply) {
        return exports.MESSAGE_TYPES[PubSubTypes.REGULAR].subscribe.equals(reply[0]) ||
            exports.MESSAGE_TYPES[PubSubTypes.REGULAR].unsubscribe.equals(reply[0]) ||
            exports.MESSAGE_TYPES[PubSubTypes.PATTERN].subscribe.equals(reply[0]) ||
            exports.MESSAGE_TYPES[PubSubTypes.PATTERN].unsubscribe.equals(reply[0]) ||
            exports.MESSAGE_TYPES[PubSubTypes.SHARDED].subscribe.equals(reply[0]) ||
            exports.MESSAGE_TYPES[PubSubTypes.SHARDED].unsubscribe.equals(reply[0]);
    }
}
exports.ClientPubSub = ClientPubSub;
_ClientPubSub_isActive = new WeakMap(), _ClientPubSub_subscribing = new WeakMap(), _ClientPubSub_subscribed = new WeakMap(), _ClientPubSub_unsubscribing = new WeakMap(), _ClientPubSub_listeners = new WeakMap();
