/// <reference types="node" />
import { RedisCommandArgument } from './commands';
declare type Listener<T> = (message: T, channel: T) => unknown;
export declare type PubSubListener<T extends boolean> = Listener<T extends true ? Buffer : string>;
export declare class PubSubListeners {
    #private;
    static channelKey(channel: RedisCommandArgument): string;
    subscribe<T extends boolean>(channels: RedisCommandArgument | Array<RedisCommandArgument>, listener: PubSubListener<T>, returnBuffers?: T): Array<RedisCommandArgument>;
    unsubscribe<T extends boolean>(channels: RedisCommandArgument | Array<RedisCommandArgument>, listener?: PubSubListener<T>, returnBuffers?: T): Array<RedisCommandArgument>;
    unsubscribeAll(): number;
    emit(message: Buffer, channel: Buffer, pattern?: Buffer): void;
    getSubscribedChannels(): Array<string>;
}
export {};
