"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _PubSubListeners_listeners;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PubSubListeners = void 0;
class PubSubListeners {
    constructor() {
        _PubSubListeners_listeners.set(this, new Map());
    }
    static channelKey(channel) {
        return typeof channel === 'string' ? channel : channel.toString();
    }
    subscribe(channels, listener, returnBuffers) {
        const toSubscribe = [];
        for (const channel of (Array.isArray(channels) ? channels : [channels])) {
            const key = PubSubListeners.channelKey(channel);
            let listeners = __classPrivateFieldGet(this, _PubSubListeners_listeners, "f").get(key);
            if (!listeners) {
                listeners = {
                    buffers: new Set(),
                    strings: new Set()
                };
                __classPrivateFieldGet(this, _PubSubListeners_listeners, "f").set(key, listeners);
                toSubscribe.push(channel);
            }
            // https://github.com/microsoft/TypeScript/issues/23132
            (returnBuffers ? listeners.buffers : listeners.strings).add(listener);
        }
        return toSubscribe;
    }
    unsubscribe(channels, listener, returnBuffers) {
        const channelsToUnsubscribe = [];
        for (const channel of (Array.isArray(channels) ? channels : [channels])) {
            const key = PubSubListeners.channelKey(channel), sets = __classPrivateFieldGet(this, _PubSubListeners_listeners, "f").get(key);
            if (!sets)
                continue;
            let shouldUnsubscribe;
            if (listener) {
                // https://github.com/microsoft/TypeScript/issues/23132
                (returnBuffers ? sets.buffers : sets.strings).delete(listener);
                shouldUnsubscribe = !sets.buffers.size && !sets.strings.size;
            }
            else {
                shouldUnsubscribe = true;
            }
            if (shouldUnsubscribe) {
                channelsToUnsubscribe.push(channel);
                __classPrivateFieldGet(this, _PubSubListeners_listeners, "f").delete(key);
            }
        }
        return channelsToUnsubscribe;
    }
    unsubscribeAll() {
        const { size } = __classPrivateFieldGet(this, _PubSubListeners_listeners, "f");
        __classPrivateFieldGet(this, _PubSubListeners_listeners, "f").clear();
        return size;
    }
    emit(message, channel, pattern) {
        const keyString = (pattern ?? channel).toString(), listeners = __classPrivateFieldGet(this, _PubSubListeners_listeners, "f").get(keyString);
        if (!listeners)
            return;
        for (const listener of listeners.buffers) {
            listener(message, channel);
        }
        if (!listeners.strings.size)
            return;
        const channelString = pattern ? channel.toString() : keyString, messageString = channelString === '__redis__:invalidate' ?
            // https://github.com/redis/redis/pull/7469
            // https://github.com/redis/redis/issues/7463
            (message === null ? null : message.map(x => x.toString())) :
            message.toString();
        for (const listener of listeners.strings) {
            listener(messageString, channelString);
        }
    }
    getSubscribedChannels() {
        return [...__classPrivateFieldGet(this, _PubSubListeners_listeners, "f").keys()];
    }
}
exports.PubSubListeners = PubSubListeners;
_PubSubListeners_listeners = new WeakMap();
