<?php
namespace Login;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

use Psr\Log\LoggerInterface;

use CodeIgniter\I18n\Time;
use CodeIgniter\I18n\TimeDifference;

use Store\DataHelper;
use Constant\ConstantHelper;

class LoginHelper extends Controller {
	public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger) {
		parent::initController($request, $response, $logger);
	}

 	function LG_getLoginSeo() {
 		$this->dataHelper 		= new DataHelper;
		$this->constantHelper = new ConstantHelper;
		
 		$this->constantHelper->CNT_dataConstant();

 		$seo = array(
 			'title'				=> '',
 			'description'	=> '',
 			'keywords'		=> '',
 			'canonical'		=> '',
 			'author'			=> '',
 			'url'					=> '',
 			'image'				=> '',
 			'alt'					=> '',
 			'site_name'		=> ''
 		);

 		$db	 			= \Config\Database::connect();

 		$table 			= 'cad_seo';
 		$column 		= 'url';
 		$folder 		= 'upload_cad_seo';
 		$subfolder 	= 'item_';

 		$builder  = $db->table($table);

 		$builder->where($column, 'cms');

 		$query    = $builder->get();
 		$result 	= $query->getRow(); 

 		$seo['title'] 				= $result->titulo;
 		$seo['description'] 	= $result->descricao;
 		$seo['keywords'] 			= $result->tags;
 		$seo['canonical'] 		= BASEURL;
 		$seo['author'] 				= $result->autor;
 		$seo['url'] 					= BASEURL;
 		$seo['alt'] 					= $result->titulo;
 		$seo['site_name'] 		= $this->dataHelper->DH_getInstitucional()->titulo;

 		if(isset($subfolder) AND !empty($subfolder)) {
 			$seo['image'] = PUBLICURL . 'uploads/' . $folder . '/' . $subfolder . $result->id . '/' . $result->imagem;
 		}
 		else {
 			$seo['image'] = PUBLICURL . 'uploads/' . $folder . '/' . $result->imagem;
 		}

 		return (object) $seo;
 	}

 	/**
	* Pega todos os cadastros da tabela cad_ancora;
	* 
	* @version 1.0.0.0 - 2022-07-16
	* 
 	* @return object
	*/

 	function LG_getLoginAncoras() {
 		$db 			= \Config\Database::connect();

 		$table 		= "cad_ancora";
 		$builder  = $db->table($table);
 		$query    = $builder->get();

 		$consulta = $query->getResult();

 		$lista 		= array();
 		$login 		= array('icon_login', 'background_login', 'icon_maps');

 		foreach ($consulta as $key => $cons) {
 			if(in_array($cons->atalho, $login)) {
 				$lista[$cons->atalho] = $cons;
 			}
 			else {
 				unset($consulta[$key]);
 			}
 		}

 		return $lista;
 	}

 	/**
	* Pega as configurações para envio de email;
	* 
	* @version 1.0.0.0 - 2023-02-10
	* 
 	* @return object
	*/

 	function LG_getLoginConfig() {
 		$db 			= \Config\Database::connect();

 		$table 		= "cms_conf_gerais";
 		$builder  = $db->table($table);
 		
 		$builder->select("form_login");

 		$query    = $builder->get();

 		return $query->getRow();
 	}


 	/**
	* Pega os dados da plataforma ativada
	* 
	* @version 1.0.0.0 - 2022-11-11
	* 
	* @uses $_POST['num']		ajax
	*/

	function LG_getPlataforma() {
		$db 			= \Config\Database::connect();
		$table 		= "cms_plataformas";
		$builder  = $db->table($table);

		$builder->where('ativo', 1);
		
		$query    = $builder->get();
		$result 	= $query->getRow();

		return $result;
	}

	/**
	* Pega as três cores principais, para serem usadas na customização do painel.
	* São usadas na view_topo_assets:
	* 
	* --color-custom-primary
	* --color-custom-secondary
	* --color-custom-tertiary
	* 
	* @version 1.0.0.0 - 2022-07-16
	*
 	* @return object
	*/

 	function LG_getCores() {
 		$db 			= \Config\Database::connect();

 		$table 		= "conf_cores";
 		$builder  = $db->table($table);
 		$query    = $builder->get();

 		return $query->getRow();
 	}

	/***************************************************************
	*
	*			End LoginHelper							
	*
	***************************************************************/
}
